/*
 * Decompiled with CFR 0.152.
 */
package org.baraza;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.InputStream;
import java.util.Properties;
import java.util.Scanner;
import java.util.logging.Logger;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.baraza.app.BApp;
import org.baraza.ide.BIDE;
import org.baraza.server.BClient;
import org.baraza.server.BServer;
import org.baraza.server.tomcat.BTomcat;
import org.baraza.utils.BDesEncrypter;
import org.baraza.xml.BElement;
import org.baraza.xml.BXML;

public class Baraza
extends JApplet
implements WindowListener {
    Logger log = Logger.getLogger(Baraza.class.getName());
    BApp app = null;
    BIDE ide = null;
    BServer server = null;
    BClient client = null;
    JFrame frame;

    public static void main(String[] args) {
        String mode = "run";
        String configDir = "./projects/";
        String dbpath = null;
        String configFile = null;
        String encryptionKey = null;
        if (args.length > 0) {
            mode = args[0].trim();
        }
        if (args.length > 1) {
            configDir = args[1];
        }
        if (args.length > 2) {
            dbpath = args[2];
        }
        if (args.length > 3) {
            configFile = args[3];
        }
        if (args.length > 4) {
            encryptionKey = args[4];
        }
        if (mode == null) {
            mode = "run";
        }
        Baraza baraza = null;
        if (args.length < 2) {
            System.out.println("Enter the proper command arguments : java -jar build/baraza.jar run ./projects/");
        } else if (mode.equals("server")) {
            BServer lserver = new BServer(configDir);
            lserver.start();
        } else if (mode.equals("stop")) {
            BClient lserver = new BClient("stop", true, configDir);
        } else if (mode.equals("tomcat") && args.length > 2) {
            baraza = new Baraza();
            baraza.tomcat(configDir, configFile, encryptionKey, dbpath);
        } else if (mode.equals("tomcat")) {
            System.out.println("Tomcat project key : ");
            Scanner scanner = new Scanner(System.in);
            dbpath = scanner.nextLine();
            baraza = new Baraza();
            baraza.tomcat(configDir, configFile, encryptionKey, dbpath);
        } else {
            baraza = new Baraza();
            baraza.run(configDir, mode, dbpath, configFile, encryptionKey);
        }
    }

    public void run(String configDir, String mode, String dbpath, String configFile, String encryptionKey) {
        int sm = this.start(configDir, mode, dbpath, configFile, encryptionKey);
        if (sm < 2) {
            this.frame = new JFrame("Baraza Project");
            this.frame.addWindowListener(this);
            this.frame.setDefaultCloseOperation(3);
            if (sm == 0) {
                this.frame.getContentPane().add(this.app);
            } else if (sm == 1) {
                this.frame.getContentPane().add(this.ide);
            }
            this.frame.setSize(1000, 800);
            this.frame.setVisible(true);
        }
    }

    @Override
    public void init() {
        String encryptionKey;
        String configFile;
        String dbpath;
        String mode;
        String config = this.getParameter("config");
        int sm = this.start(config, mode = this.getParameter("mode"), dbpath = this.getParameter("dbpath"), configFile = this.getParameter("configfile"), encryptionKey = this.getParameter("encryptionkey"));
        if (sm == 0) {
            this.getContentPane().add(this.app);
        } else if (sm == 1) {
            this.getContentPane().add(this.ide);
        }
    }

    public int start(String configDir, String mode, String dbpath, String configFile, String encryptionKey) {
        int sm = 0;
        BXML xml = null;
        if (encryptionKey == null) {
            if (configFile == null) {
                configFile = "config.xml";
            }
            xml = new BXML(configDir + configFile, false);
        } else {
            if (configFile == null) {
                configFile = "config.cph";
            }
            BDesEncrypter decrypter = new BDesEncrypter(encryptionKey);
            InputStream inXml = decrypter.decrypt(configDir + configFile);
            xml = new BXML(inXml);
        }
        BElement root = xml.getRoot();
        Properties props = System.getProperties();
        if (root.getAttribute("pictures_url") != null) {
            props.setProperty("pictures_url", root.getAttribute("pictures_url"));
        }
        if (root.getAttribute("photo_access") != null) {
            props.setProperty("photo_access", root.getAttribute("photo_access"));
        }
        if (root.getAttribute("repository_url") != null) {
            props.setProperty("repository_url", root.getAttribute("repository_url"));
        }
        if (root.getAttribute("rep_username") != null) {
            props.setProperty("rep_username", root.getAttribute("rep_username"));
        }
        if (root.getAttribute("rep_password") != null) {
            props.setProperty("rep_password", root.getAttribute("rep_password"));
        }
        if (mode != null) {
            if (mode.equals("run")) {
                sm = 0;
            } else if (mode.equals("develop")) {
                sm = 1;
            } else if (mode.equals("server")) {
                sm = 2;
            } else if (mode.equals("stop")) {
                sm = 3;
            }
        } else if (root.getAttribute("mode") != null) {
            if (root.getAttribute("mode").equals("run")) {
                sm = 0;
            } else if (root.getAttribute("mode").equals("develop")) {
                sm = 1;
            } else if (root.getAttribute("mode").equals("server")) {
                sm = 2;
            }
        }
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception ex) {
            System.out.println("Error Loading the look : " + ex);
        }
        switch (sm) {
            case 0: {
                this.app = new BApp(configDir, configFile, dbpath, encryptionKey);
                break;
            }
            case 1: {
                this.ide = new BIDE(configDir);
                break;
            }
            case 2: {
                this.server = new BServer(configDir);
                this.server.start();
                break;
            }
            case 3: {
                this.client = new BClient("stop", true, configDir);
            }
        }
        return sm;
    }

    public void tomcat(String configDir, String configFile, String encryptionKey, String appName) {
        BXML xml = null;
        if (appName == null) {
            System.out.println("Tomcat launch arguments : java -jar build/baraza.jar run ./projects/ <<application>>");
            return;
        }
        if (encryptionKey == null) {
            if (configFile == null) {
                configFile = "config.xml";
            }
            xml = new BXML(configDir + configFile, false);
        } else {
            if (configFile == null) {
                configFile = "config.cph";
            }
            BDesEncrypter decrypter = new BDesEncrypter(encryptionKey);
            InputStream inXml = decrypter.decrypt(configDir + configFile);
            xml = new BXML(inXml);
        }
        BElement root = xml.getRoot();
        BElement appEl = root.getElementByKey(appName);
        if (appEl == null) {
            System.out.println("Ensure the <<application>> is a key for the application you want to run");
            return;
        }
        BTomcat cat = new BTomcat(appEl, configDir, appName);
        cat.start();
    }

    @Override
    public void windowDeactivated(WindowEvent ev) {
    }

    @Override
    public void windowActivated(WindowEvent ev) {
    }

    @Override
    public void windowDeiconified(WindowEvent ev) {
    }

    @Override
    public void windowIconified(WindowEvent ev) {
    }

    @Override
    public void windowOpened(WindowEvent ev) {
    }

    @Override
    public void windowClosed(WindowEvent ev) {
    }

    @Override
    public void windowClosing(WindowEvent ev) {
        this.close();
        this.frame.dispose();
        System.exit(0);
    }

    @Override
    public void destroy() {
        this.close();
    }

    public void close() {
        System.clearProperty("photo_access");
        System.clearProperty("repository_url");
        System.clearProperty("rep_username");
        System.clearProperty("rep_password");
        if (this.app != null) {
            this.app.close();
        }
        if (this.ide != null) {
            this.ide.close();
        }
    }
}

