/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.baraza.DB.BCrossSet;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.xml.BElement;

public class BCrossTab {
    List<String> titles;
    List<String> fieldNames;
    List<String> keyFieldData;
    Vector<Vector<Object>> dataTable;
    BQuery baseRs;
    Map<String, BCrossSet> crosstabRs;
    BElement view;

    public BCrossTab(BDB db, BElement view, String wheresql, String sortby) {
        this.view = view;
        System.out.println("BASE : " + wheresql);
        System.out.println("BASE : " + view.toString());
        this.baseRs = new BQuery(db, view, wheresql, null);
        this.dataTable = new Vector();
        this.titles = new ArrayList<String>();
        this.fieldNames = new ArrayList<String>();
        this.crosstabRs = new HashMap<String, BCrossSet>();
        for (BElement el : view.getElements()) {
            if (el.getName().equals("CROSSTAB")) {
                BQuery ctq = new BQuery(db, el, wheresql, null);
                BCrossSet cs = new BCrossSet(ctq.getData());
                this.crosstabRs.put(el.getAttribute("name"), cs);
                ctq.close();
                for (String csc : cs.getColumns().keySet()) {
                    this.titles.add(csc);
                }
                continue;
            }
            this.titles.add(el.getAttribute("title", ""));
            this.fieldNames.add(el.getValue());
        }
    }

    public String getGrid(List<String> viewKeys, List<String> viewData, boolean addJSc, String viewKey, boolean sfield) {
        StringBuffer myhtml = new StringBuffer();
        int btSize = this.baseRs.getData().size();
        Vector<String> keyData = this.baseRs.getKeyFieldData();
        System.out.println("BASE : size " + btSize);
        myhtml.append("<div class='table-scrollable'>\n");
        myhtml.append("<table id='crosstab' class='table table-striped table-bordered table-hover'>\n");
        myhtml.append("<thead><tr>");
        for (BElement el : this.view.getElements()) {
            if (el.getName().equals("CROSSTAB")) {
                BCrossSet cs = this.crosstabRs.get(el.getAttribute("name"));
                myhtml.append(cs.getColTitles());
                continue;
            }
            myhtml.append("<th>" + el.getAttribute("title") + "</th>");
        }
        myhtml.append("</tr></thead>\n");
        int j = 0;
        for (Vector<Object> data : this.baseRs.getData()) {
            Vector dataRow = new Vector();
            int i = 0;
            myhtml.append("<tr>");
            for (BElement el : this.view.getElements()) {
                if (el.getName().equals("CROSSTAB")) {
                    BCrossSet cs = this.crosstabRs.get(el.getAttribute("name"));
                    myhtml.append(cs.getRowHtml(keyData.get(j)));
                    continue;
                }
                if (data.get(i) == null) {
                    myhtml.append("<td></td>");
                } else {
                    String dv = data.get(i).toString();
                    myhtml.append("<td>" + dv + "</td>");
                }
                ++i;
            }
            ++j;
            myhtml.append("</tr>\n");
            this.dataTable.add(data);
        }
        myhtml.append("</table>\n");
        myhtml.append("</div>\n");
        return myhtml.toString();
    }

    public String getCsv() {
        StringBuffer myCsv = new StringBuffer();
        int btSize = this.baseRs.getData().size();
        Vector<String> keyData = this.baseRs.getKeyFieldData();
        System.out.println("BASE : size " + btSize);
        int i = 0;
        for (BElement el : this.view.getElements()) {
            if (el.getName().equals("CROSSTAB")) {
                BCrossSet cs = this.crosstabRs.get(el.getAttribute("name"));
                myCsv.append(cs.getCsvTitles());
            } else {
                if (i != 0) {
                    myCsv.append(",");
                }
                myCsv.append(this.getCsvValue(el.getAttribute("title")));
            }
            ++i;
        }
        myCsv.append("\n");
        int j = 0;
        for (Vector<Object> data : this.baseRs.getData()) {
            Vector dataRow = new Vector();
            i = 0;
            for (BElement el : this.view.getElements()) {
                if (el.getName().equals("CROSSTAB")) {
                    BCrossSet cs = this.crosstabRs.get(el.getAttribute("name"));
                    myCsv.append(cs.getRowCsv(keyData.get(j)));
                    continue;
                }
                if (i != 0) {
                    myCsv.append(",");
                }
                myCsv.append(this.getCsvValue(data.get(i)));
                ++i;
            }
            ++j;
            myCsv.append("\n");
            this.dataTable.add(data);
        }
        return myCsv.toString();
    }

    public String getCsvValue(Object cellVal) {
        String mystr = "";
        if (cellVal != null) {
            mystr = cellVal.toString().startsWith("0") ? "\"'" + cellVal.toString() + "\"" : "\"" + cellVal.toString() + "\"";
        }
        return mystr;
    }

    public void close() {
        this.baseRs.close();
    }
}

