/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.baraza.xml.BElement;

public class BImportModel
extends AbstractTableModel {
    Logger log = Logger.getLogger(BImportModel.class.getName());
    List<String> columnTitle = new ArrayList<String>();
    List<Integer> columnWidth = new ArrayList<Integer>();
    List<Integer> dataWidth = new ArrayList<Integer>();
    Vector<Vector<Object>> rows = new Vector();
    String sql;
    String keyfield;
    List<String> keylist;

    public BImportModel(BElement fielddef) {
        for (BElement el : fielddef.getElements()) {
            if (el.getAttribute("title") == null) continue;
            this.columnTitle.add(el.getAttribute("title"));
            this.columnWidth.add(Integer.valueOf(el.getAttribute("w")));
            this.dataWidth.add(Integer.valueOf(el.getAttribute("dw", "0")));
        }
    }

    @Override
    public String getColumnName(int col) {
        return this.columnTitle.get(col);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnTitle.size();
    }

    @Override
    public Object getValueAt(int aRow, int aColumn) {
        Vector<Object> row = this.rows.elementAt(aRow);
        return row.elementAt(aColumn);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Vector<Object> dataRow = this.rows.elementAt(row);
        dataRow.setElementAt(value.toString(), col);
    }

    public void getTextData(JPanel panel, String delimiter) {
        JFileChooser fc;
        int returnVal;
        FileReader input = null;
        String filename = "";
        this.rows.removeAllElements();
        if (delimiter == null) {
            delimiter = ",";
        }
        if ((returnVal = (fc = new JFileChooser()).showOpenDialog(panel)) == 0) {
            filename = fc.getSelectedFile().getAbsolutePath();
            try {
                input = new FileReader(filename);
                BufferedReader reader = new BufferedReader(input);
                String myline = "";
                do {
                    if ((myline = reader.readLine()) == null) continue;
                    int x = myline.indexOf("\"");
                    while (x >= 0) {
                        String newline;
                        x = myline.indexOf("\"");
                        int l = myline.length();
                        int y = -1;
                        if (x < 0 || (y = myline.indexOf("\"", x + 1)) <= x) continue;
                        myline = newline = myline.substring(0, x) + myline.substring(x + 1, y).replace(",", "") + myline.substring(y + 1, l);
                    }
                    String[] mytokens = myline.split(delimiter);
                    if (mytokens.length <= 0) continue;
                    Vector<String> myvec = new Vector<String>();
                    for (int j = 0; j < this.getColumnCount(); ++j) {
                        if (j < mytokens.length) {
                            myvec.add(this.getstrvalue(mytokens[j]));
                            continue;
                        }
                        myvec.add("");
                    }
                    this.rows.add(myvec);
                } while (myline != null);
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                System.out.println("File error.");
            }
        }
        this.fireTableChanged(null);
    }

    public void getRecordData(JPanel panel) {
        FileReader input = null;
        String filename = "";
        this.rows.removeAllElements();
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(panel);
        if (returnVal == 0) {
            filename = fc.getSelectedFile().getAbsolutePath();
            try {
                input = new FileReader(filename);
                BufferedReader reader = new BufferedReader(input);
                int mdw = 0;
                for (Integer dw : this.dataWidth) {
                    mdw += dw.intValue();
                }
                String myline = "";
                do {
                    if ((myline = reader.readLine()) == null || myline.length() != mdw) continue;
                    int sp = 0;
                    Vector<String> myvec = new Vector<String>();
                    for (Integer dw : this.dataWidth) {
                        String mytoken = myline.substring(sp, sp + dw);
                        sp += dw.intValue();
                        myvec.add(mytoken.trim());
                    }
                    this.rows.add(myvec);
                } while (myline != null);
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                this.log.severe("File error : " + ex);
            }
        }
        this.fireTableChanged(null);
    }

    public void getExcelData(JPanel panel, String worksheet) {
        String filename = "";
        this.rows.removeAllElements();
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(panel);
        if (returnVal == 0) {
            filename = fc.getSelectedFile().getAbsolutePath();
            POIFSFileSystem fs = null;
            HSSFWorkbook wb = null;
            DirectoryNode rootdir = null;
            try {
                FileInputStream stream = new FileInputStream(filename);
                fs = new POIFSFileSystem((InputStream)stream);
                rootdir = fs.getRoot();
                wb = new HSSFWorkbook(fs);
            }
            catch (IOException ex) {
                this.log.severe("an I/O error occurred, or the InputStream did not provide a compatible POIFS data structure : " + ex);
            }
            HSSFSheet sheet = wb.getSheetAt(Integer.valueOf(worksheet).intValue());
            HSSFRow row = null;
            int i = 0;
            String myline = "";
            for (i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
                Vector<String> myvec = new Vector<String>();
                row = sheet.getRow(i);
                if (row != null) {
                    myline = this.getstrvalue(row, 0);
                    for (int j = 0; j < this.getColumnCount(); ++j) {
                        myvec.add(this.getstrvalue(row, j));
                    }
                    if (myline.equals("")) continue;
                    this.rows.add(myvec);
                    continue;
                }
                myline = "";
            }
        }
        this.fireTableChanged(null);
    }

    public void clearupload() {
        this.rows.removeAllElements();
        this.fireTableChanged(null);
    }

    public String getstrvalue(String mystr) {
        String newstr = mystr.replaceAll("\"", "").trim();
        return newstr;
    }

    public String getstrvalue(HSSFRow row, int column) {
        String mystr = "";
        HSSFCell cell = row.getCell(column);
        if (cell == null) {
            cell = row.createCell(column);
        }
        if (cell.getCellType() == 1) {
            if (cell.getStringCellValue() != null) {
                mystr = mystr + cell.getStringCellValue().trim();
            }
        } else if (cell.getCellType() == 0) {
            mystr = mystr + cell.getNumericCellValue();
        }
        return mystr;
    }

    public Vector<Vector<Object>> getData() {
        return this.rows;
    }

    public void close() {
    }
}

