/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.baraza.xml.BElement;

public class BImportVector {
    Logger log = Logger.getLogger(BImportVector.class.getName());
    List<String> columnTitle = new ArrayList<String>();
    List<Integer> columnWidth = new ArrayList<Integer>();
    List<Integer> dataWidth = new ArrayList<Integer>();
    Vector<Vector<Object>> rows = new Vector();
    String sql;
    String delimiter = null;
    String keyfield;
    List<String> keylist;

    public BImportVector(BElement view) {
        this.delimiter = view.getAttribute("delimiter");
        for (BElement el : view.getElements()) {
            if (el.getAttribute("title") == null) continue;
            this.columnTitle.add(el.getAttribute("title"));
            this.columnWidth.add(Integer.valueOf(el.getAttribute("w")));
            this.dataWidth.add(Integer.valueOf(el.getAttribute("dw", "0")));
        }
    }

    public String getColumnName(int col) {
        return this.columnTitle.get(col);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.columnTitle.size();
    }

    public Object getValueAt(int aRow, int aColumn) {
        Vector<Object> row = this.rows.elementAt(aRow);
        return row.elementAt(aColumn);
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
        Vector<Object> dataRow = this.rows.elementAt(row);
        dataRow.setElementAt(value.toString(), col);
    }

    public void getTextData(InputStream input) {
        this.rows.removeAllElements();
        if (this.delimiter == null) {
            this.delimiter = ",";
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            String myline = "";
            do {
                if ((myline = reader.readLine()) == null) continue;
                int x = myline.indexOf("\"");
                while (x >= 0) {
                    String newline;
                    x = myline.indexOf("\"");
                    int l = myline.length();
                    int y = -1;
                    if (x < 0 || (y = myline.indexOf("\"", x + 1)) <= x) continue;
                    myline = newline = myline.substring(0, x) + myline.substring(x + 1, y).replace(",", "") + myline.substring(y + 1, l);
                }
                String[] mytokens = myline.split(this.delimiter);
                if (mytokens.length <= 0) continue;
                Vector<String> myvec = new Vector<String>();
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    if (j < mytokens.length) {
                        myvec.add(this.getstrvalue(mytokens[j]));
                        continue;
                    }
                    myvec.add("");
                }
                this.rows.add(myvec);
            } while (myline != null);
            if (input != null) {
                input.close();
            }
        }
        catch (IOException ex) {
            System.out.println("File error.");
        }
    }

    public void getRecordData(InputStream input) {
        this.rows.removeAllElements();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            int mdw = 0;
            for (Integer dw : this.dataWidth) {
                mdw += dw.intValue();
            }
            String myline = "";
            do {
                if ((myline = reader.readLine()) == null || myline.length() != mdw) continue;
                int sp = 0;
                Vector<String> myvec = new Vector<String>();
                for (Integer dw : this.dataWidth) {
                    String mytoken = myline.substring(sp, sp + dw);
                    sp += dw.intValue();
                    myvec.add(mytoken.trim());
                }
                this.rows.add(myvec);
            } while (myline != null);
            if (input != null) {
                input.close();
            }
        }
        catch (IOException ex) {
            this.log.severe("File error : " + ex);
        }
    }

    public void getExcelData(InputStream input, String fileName, String worksheet, Integer firstRow) {
        this.rows.removeAllElements();
        XSSFWorkbook wb = null;
        try {
            if (fileName.indexOf(".xlsx") > 1) {
                wb = new XSSFWorkbook(input);
            } else if (fileName.indexOf(".xls") > 1) {
                wb = new HSSFWorkbook(input);
            }
        }
        catch (IOException ex) {
            this.log.severe("an I/O error occurred, or the InputStream did not provide a compatible POIFS data structure : " + ex);
        }
        Sheet sheet = wb.getSheetAt(Integer.valueOf(worksheet).intValue());
        Row row = null;
        int i = 0;
        if (firstRow < sheet.getFirstRowNum()) {
            firstRow = sheet.getFirstRowNum();
        }
        String myline = "";
        for (i = firstRow.intValue(); i <= sheet.getLastRowNum(); ++i) {
            Vector<String> myvec = new Vector<String>();
            row = sheet.getRow(i);
            if (row != null) {
                myline = this.getCellValue(row, 0);
                for (int j = 0; j < this.getColumnCount(); ++j) {
                    myvec.add(this.getCellValue(row, j));
                }
                if (myline.equals("")) continue;
                this.rows.add(myvec);
                continue;
            }
            myline = "";
        }
    }

    public String numberFormat(double cellVal) {
        DecimalFormat formatter = new DecimalFormat("############.###");
        return formatter.format(cellVal);
    }

    public void clearupload() {
        this.rows.removeAllElements();
    }

    public String getstrvalue(String mystr) {
        String newstr = mystr.replaceAll("\"", "").trim();
        return newstr;
    }

    public String getCellValue(Row row, int column) {
        String mystr = "";
        Cell cell = row.getCell(column);
        if (cell == null) {
            cell = row.createCell(column);
        }
        if (cell.getCellType() == 1) {
            if (cell.getStringCellValue() != null) {
                mystr = mystr + cell.getStringCellValue().trim();
            }
        } else if (cell.getCellType() == 0) {
            mystr = mystr + this.numberFormat(cell.getNumericCellValue());
        } else if (cell.getCellType() == 2) {
            if (cell.getCachedFormulaResultType() == 0) {
                mystr = mystr + this.numberFormat(cell.getNumericCellValue());
            } else if (cell.getCachedFormulaResultType() == 1) {
                mystr = mystr + cell.getRichStringCellValue();
            }
        }
        return mystr;
    }

    public Vector<Vector<Object>> getData() {
        return this.rows;
    }

    public void close() {
    }
}

