/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.baraza.DB.BDB;
import org.baraza.DB.BTableLinks;
import org.baraza.DB.BUser;
import org.baraza.utils.BCipher;
import org.baraza.utils.BDateFormat;
import org.baraza.utils.BLogHandle;
import org.baraza.utils.Bio;
import org.baraza.xml.BElement;

public class BQuery {
    Logger log = Logger.getLogger(BQuery.class.getName());
    int tableLimit = -1;
    BElement view = null;
    BDB db = null;
    BUser user = null;
    Statement st = null;
    ResultSet rs = null;
    ResultSetMetaData rsmd = null;
    boolean isAddNew = false;
    boolean isEdit = false;
    String tableSelect = null;
    String tableName;
    String updateTable = null;
    int colnum = 0;
    Vector<Vector<Object>> data;
    Vector<String> titles;
    Vector<String> fieldNames;
    Vector<String> keyFieldData;
    Vector<String> autoFields;
    List<Boolean> columnEdit;
    List<BTableLinks> ForeignLinks = null;
    Map<String, String> params;
    Map<String, String> addNewBlock;
    String keyField = null;
    String keyFieldId = null;
    String mysql = null;
    String auditID = null;
    boolean firstFetch = true;
    boolean noaudit = false;
    boolean readonly = false;
    boolean iforg = false;
    int errCode = 0;
    String changeTrack = "";
    Integer rowStart = null;
    Integer fertchSize = null;
    String orgID = null;
    String userOrg = null;

    public BQuery() {
        this.init();
    }

    public BQuery(String[] titleArray) {
        this.init();
        for (String mnName : titleArray) {
            this.titles.add(mnName);
        }
    }

    public BQuery(BDB db, BElement view, String wheresql, String orderby) {
        this.db = db;
        this.user = db.getUser();
        this.buildQuery(db, view, wheresql, orderby);
    }

    public BQuery(BDB db, BElement view, String wheresql, String orderby, boolean ff) {
        this.firstFetch = ff;
        this.db = db;
        this.user = db.getUser();
        this.buildQuery(db, view, wheresql, orderby);
    }

    public BQuery(BDB db, BElement view, String wheresql, String orderby, BUser user, boolean ff) {
        this.firstFetch = ff;
        this.db = db;
        this.user = user == null ? db.getUser() : user;
        this.buildQuery(db, view, wheresql, orderby);
    }

    public BQuery(BDB db, BElement view, String wheresql, String orderby, boolean ff, Integer rowStart, Integer fertchSize) {
        this.firstFetch = ff;
        this.rowStart = rowStart;
        this.fertchSize = fertchSize;
        this.db = db;
        this.user = db.getUser();
        this.buildQuery(db, view, wheresql, orderby);
    }

    public BQuery(BDB db, String myfields, String tableName, int limit) {
        this.init();
        this.db = db;
        this.user = db.getUser();
        this.tableName = tableName;
        this.tableLimit = limit;
        this.mysql = "SELECT " + myfields + "\nFROM " + tableName;
        this.makeQuery();
        if (this.tableLimit > 0) {
            this.ForeignLinks = db.getForeignLinks(tableName);
        }
    }

    public BQuery(BDB db, String mysql) {
        this.init();
        this.db = db;
        this.user = db.getUser();
        this.mysql = mysql;
        this.makeQuery();
    }

    public BQuery(BDB db, String mysql, int limit) {
        this.init();
        this.db = db;
        this.user = db.getUser();
        this.mysql = mysql;
        this.tableLimit = limit;
        this.makeQuery();
    }

    public void buildQuery(BDB db, BElement view, String wheresql, String orderby) {
        String[] paramArr;
        this.init();
        this.view = view;
        this.db = db;
        this.tableName = view.getAttribute("table");
        this.keyField = view.getAttribute("keyfield");
        String keyFnct = view.getAttribute("key_fnct");
        this.tableLimit = Integer.valueOf(view.getAttribute("limit", "0"));
        this.updateTable = view.getAttribute("updatetable");
        this.auditID = view.getAttribute("auditid");
        String linkField = view.getAttribute("linkfield");
        String userField = view.getAttribute("user");
        String hint = view.getAttribute("hint");
        String reportTitle = view.getAttribute("reporttitle");
        String paramStr = view.getAttribute("params");
        String inputParamStr = view.getAttribute("inputparams");
        boolean hasKF = true;
        String colNames = "";
        if (view.getAttribute("noaudit", "false").equals("true")) {
            this.noaudit = true;
        }
        if (view.getAttribute("readonly", "false").equals("true")) {
            this.readonly = true;
        }
        for (BElement el : view.getElements()) {
            String colName = el.getValue();
            if (colName.equals("")) continue;
            if (!this.fieldNames.contains(colName)) {
                String function = el.getAttribute("fnct");
                if (el.getName().equals("ACTION")) {
                    function = null;
                }
                if (!colNames.equals("")) {
                    colNames = colNames + ", ";
                }
                colNames = function != null ? colNames + "(" + function + ") as " + colName : colNames + colName;
                this.fieldNames.add(colName);
            }
            if (el.getAttribute("title") == null && el.getAttribute("tab") == null) continue;
            this.titles.add(el.getAttribute("title"));
            if (el.getAttribute("edit", "false").equals("true")) {
                this.columnEdit.add(true);
                continue;
            }
            this.columnEdit.add(false);
        }
        if (this.keyField != null && !this.fieldNames.contains(this.keyField)) {
            colNames = keyFnct == null ? colNames + ", " + this.keyField : colNames + ", (" + keyFnct + ") as " + this.keyField;
            this.fieldNames.add(this.keyField);
        }
        colNames = this.addField(colNames, linkField);
        colNames = this.addField(colNames, userField);
        colNames = this.addField(colNames, hint);
        colNames = this.addField(colNames, reportTitle);
        for (BElement el : view.getElements()) {
            colNames = this.addField(colNames, el.getAttribute("editkey"));
        }
        if (paramStr != null) {
            for (String param : paramArr = paramStr.split(",")) {
                this.params.put(param.trim().toLowerCase(), null);
                colNames = this.addField(colNames, param.trim().toLowerCase());
            }
        }
        if (inputParamStr != null) {
            for (String param : paramArr = inputParamStr.split(",")) {
                String[] inParamArr = param.split("=");
                colNames = this.addField(colNames, inParamArr[0].trim().toLowerCase());
            }
        }
        this.orgID = db.getOrgID();
        if (this.orgID != null && view.getAttribute("noorg") == null && this.user != null) {
            this.userOrg = this.user.getUserOrg();
            if (view.getAttribute("orgid") != null) {
                this.orgID = view.getAttribute("orgid");
            }
            if (view.getAttribute("noorg.query") == null) {
                colNames = this.addField(colNames, this.orgID);
            }
        }
        this.iforg = view.getAttribute("noorg") == null;
        if (this.auditID != null && view.getName().equals("FORM")) {
            colNames = this.addField(colNames, this.auditID);
        }
        this.tableSelect = "SELECT " + colNames + "\nFROM " + this.tableName;
        if (this.tableName != null) {
            this.filterBuild(wheresql, orderby);
            this.log.fine(this.mysql);
            this.makeQuery();
            if (this.firstFetch) {
                this.readData();
            }
        }
    }

    public String addField(String colNames, String colName) {
        if (colName == null) {
            return colNames;
        }
        if (!this.fieldNames.contains(colName)) {
            colNames = colNames + ", " + colName;
            this.fieldNames.add(colName);
        }
        return colNames;
    }

    public void init() {
        this.titles = new Vector();
        this.fieldNames = new Vector();
        this.keyFieldData = new Vector();
        this.autoFields = new Vector();
        this.data = new Vector();
        this.columnEdit = new ArrayList<Boolean>();
        this.params = new HashMap<String, String>();
        this.addNewBlock = new HashMap<String, String>();
    }

    public void makeQuery() {
        BLogHandle lh;
        if (this.db != null && (lh = this.db.getLogHandle()) != null) {
            lh.config(this.log);
        }
        if (this.db.getReadOnly()) {
            this.readonly = true;
        }
        try {
            this.st = this.readonly ? this.db.getDB().createStatement() : this.db.getDB().createStatement(1005, 1008);
            if (this.tableLimit > 0) {
                this.st.setFetchSize(this.tableLimit);
            } else if (this.tableLimit == 0) {
                this.st.setFetchSize(1000);
            }
            this.rs = this.st.executeQuery(this.mysql);
            this.rsmd = this.rs.getMetaData();
            this.colnum = this.rsmd.getColumnCount();
        }
        catch (SQLException ex) {
            this.rs = null;
            this.log.severe("Get Table read and Metadata Error : " + ex);
            this.log.severe("SQL " + this.mysql);
        }
        if (this.view == null) {
            this.titles = new Vector<String>(this.getFields());
            this.fieldNames = new Vector<String>(this.getFields());
        }
        this.getAutoFields();
    }

    public void refresh() {
        try {
            this.rs = this.st.executeQuery(this.mysql);
        }
        catch (SQLException ex) {
            this.log.severe("Get Table refresh Error : " + ex);
        }
    }

    public void filter(String wheresql, String orderby) {
        if (this.tableSelect != null) {
            this.filterBuild(wheresql, orderby);
            this.log.fine(this.mysql);
            this.makeQuery();
        }
    }

    public void filterBuild(String wheresql, String orderby) {
        this.mysql = this.tableSelect;
        if (wheresql != null) {
            wheresql = "\nWHERE " + wheresql;
        }
        if (this.view != null) {
            if (this.view.getAttribute("where") != null) {
                wheresql = wheresql == null ? "\nWHERE " + this.view.getAttribute("where") : wheresql + " AND " + this.view.getAttribute("where");
            }
            if (this.view.getAttribute("user") != null) {
                String userFilter = "(" + this.view.getAttribute("user") + " = '" + this.user.getUserID() + "')";
                wheresql = wheresql == null ? "\nWHERE " + userFilter : wheresql + " AND " + userFilter;
            }
            if (this.view.getAttribute("group") != null) {
                String groupFilter = "(" + this.view.getAttribute("group") + " IN (" + this.db.getGroupIDs() + "))";
                wheresql = wheresql == null ? "\nWHERE " + groupFilter : wheresql + " AND " + groupFilter;
            }
            if (this.view.getAttribute("noorg") == null && this.orgID != null && this.userOrg != null) {
                String orgFilter = "(" + this.orgID + " = '" + this.userOrg + "')";
                wheresql = wheresql == null ? "\nWHERE " + orgFilter : wheresql + " AND " + orgFilter;
            }
            if (this.view.getAttribute("user_fnct") != null && this.view.getAttribute("user_field") != null) {
                String userFnct = "SELECT " + this.view.getAttribute("user_fnct") + "('" + this.user.getUserID() + "')";
                userFnct = this.db.executeFunction(userFnct);
                userFnct = "(" + this.view.getAttribute("user_field") + " = '" + userFnct + "')";
                wheresql = wheresql == null ? "\nWHERE " + userFnct : wheresql + " AND " + userFnct;
            }
        }
        if (wheresql != null) {
            this.mysql = this.mysql + wheresql;
        }
        if (this.view != null && this.view.getAttribute("groupby") != null) {
            this.mysql = this.mysql + "\nGROUP BY " + this.view.getAttribute("groupby");
        }
        if (orderby != null) {
            orderby = "\nORDER BY " + orderby;
        }
        if (this.view != null) {
            if (this.view.getAttribute("orderby") != null) {
                orderby = orderby == null ? "\nORDER BY " + this.view.getAttribute("orderby") : orderby + ", " + this.view.getAttribute("orderby");
            }
            if (this.keyField != null && orderby == null) {
                orderby = "\nORDER BY " + this.keyField;
            }
        }
        if (orderby != null) {
            this.mysql = this.mysql + orderby;
        }
    }

    public void setSQL(String lsql) {
        this.mysql = lsql;
    }

    public boolean moveNext() {
        boolean ans = false;
        try {
            if (this.rs != null) {
                ans = this.rs.next();
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table move next error : " + ex);
        }
        return ans;
    }

    public boolean movePrevious() {
        boolean ans = false;
        try {
            if (this.rs != null) {
                ans = this.rs.previous();
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table move previous error : " + ex);
        }
        return ans;
    }

    public int getRow() {
        int ans = -1;
        try {
            if (this.rs != null) {
                ans = this.rs.getRow();
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table move to row error : " + ex);
        }
        return ans;
    }

    public boolean moveFirst() {
        boolean ans = false;
        try {
            if (this.rs != null) {
                ans = this.rs.first();
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table move first error : " + ex);
        }
        return ans;
    }

    public boolean moveLast() {
        boolean ans = false;
        try {
            if (this.rs != null) {
                ans = this.rs.last();
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table move last error : " + ex);
        }
        return ans;
    }

    public void beforeFirst() {
        try {
            if (this.rs != null) {
                this.rs.beforeFirst();
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table move first error : " + ex);
        }
    }

    public boolean isLast() {
        boolean ans = false;
        try {
            if (this.rs != null) {
                ans = this.rs.isLast();
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table islast check error : " + ex);
        }
        return ans;
    }

    public boolean isFirst() {
        boolean ans = false;
        try {
            if (this.rs != null) {
                ans = this.rs.isFirst();
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table isFirst check error : " + ex);
        }
        return ans;
    }

    public boolean movePos(int pos) {
        boolean ans = false;
        try {
            if (this.rs != null) {
                ans = this.rs.absolute(pos);
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table absolute move error : " + ex);
        }
        return ans;
    }

    public void reset() {
        try {
            if (this.rs != null) {
                this.rs.beforeFirst();
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table move before first data error : " + ex);
        }
    }

    public int rowNumber() {
        int ans = 0;
        try {
            if (this.rs != null) {
                ans = this.rs.getRow();
            }
        }
        catch (SQLException ex) {
            this.log.severe("Table get row number error : " + ex);
        }
        return ans;
    }

    public String readField(String fieldName) {
        String ans = null;
        try {
            ans = this.rs.getString(fieldName);
        }
        catch (SQLException ex) {
            this.log.severe("Data field read error : " + ex);
        }
        return ans;
    }

    public String readField(int fieldPos) {
        String ans = null;
        try {
            ans = this.rs.getString(fieldPos);
        }
        catch (SQLException ex) {
            this.log.severe("Data field read error : " + ex);
        }
        return ans;
    }

    public String getString(String fieldName) {
        return this.readField(fieldName);
    }

    public int getInt(String fieldName) {
        int ans = 0;
        try {
            ans = this.rs.getInt(fieldName);
        }
        catch (SQLException ex) {
            this.log.severe("Data field read error : " + ex);
        }
        return ans;
    }

    public Float getFloat(String fieldName) {
        Float ans = new Float("0.0");
        try {
            ans = Float.valueOf(this.rs.getFloat(fieldName));
        }
        catch (SQLException ex) {
            this.log.severe("Data field read error : " + ex);
        }
        return ans;
    }

    public Double getDouble(String fieldName) {
        Double ans = new Double("0.0");
        try {
            ans = this.rs.getDouble(fieldName);
        }
        catch (SQLException ex) {
            this.log.severe("Data field read error : " + ex);
        }
        return ans;
    }

    public Date getDate(String fieldName) {
        Date ans = null;
        try {
            ans = this.rs.getDate(fieldName);
        }
        catch (SQLException ex) {
            this.log.severe("Data field read error : " + ex);
        }
        return ans;
    }

    public Time getTime(String fieldName) {
        Time ans = null;
        try {
            ans = this.rs.getTime(fieldName);
        }
        catch (SQLException ex) {
            this.log.severe("Data field read error : " + ex);
        }
        return ans;
    }

    public Boolean getBoolean(String fieldName) {
        Boolean ans = false;
        try {
            ans = this.rs.getBoolean(fieldName);
        }
        catch (SQLException ex) {
            this.log.severe("Data field read error : " + ex);
        }
        return ans;
    }

    public String getBoolean(String fieldName, int fType) {
        String ans = "Yes";
        try {
            boolean dans = this.rs.getBoolean(fieldName);
            if (fType == 1) {
                ans = dans ? "Yes" : "No";
            } else if (fType == 2) {
                ans = dans ? "True" : "False";
            }
        }
        catch (SQLException ex) {
            this.log.severe("Data field read error : " + ex);
        }
        return ans;
    }

    public String getFormatField(int fieldPos) {
        String ans = "";
        int fldPos = fieldPos + 1;
        try {
            int type = this.getFieldType(fldPos);
            if (type == 91 || type == 92 || type == 93) {
                SimpleDateFormat dateParse = new SimpleDateFormat("dd-MMM-yyyy");
                if (this.rs.getString(fldPos) != null) {
                    ans = dateParse.format(this.rs.getDate(fldPos));
                }
            } else {
                ans = this.rs.getString(fldPos);
            }
            if (ans == null) {
                ans = "";
            }
        }
        catch (SQLException ex) {
            this.log.severe("Data field read error : " + ex);
        }
        return ans;
    }

    public String updateField(String fname, String fvalue) {
        String errMsg = "";
        if (this.isAddNew) {
            if (fvalue != null && fvalue.length() > 0) {
                this.addNewBlock.put(fname, fvalue);
            }
        } else {
            errMsg = this.updateRecField(fname, fvalue);
        }
        return errMsg;
    }

    public String updateRecField(String fname, String fvalue) {
        String errMsg = "";
        if (this.isEdit) {
            String oldvalue = this.readField(fname);
            if (oldvalue == null) {
                if (fvalue == null) {
                    return errMsg;
                }
            } else {
                if (oldvalue.equals(fvalue)) {
                    return errMsg;
                }
                this.changeTrack = this.changeTrack + "," + fname + ":\"" + oldvalue + "\"";
            }
        }
        try {
            int columnindex = this.rs.findColumn(fname);
            if (fvalue == null) {
                this.rs.updateNull(fname);
            } else if (fvalue.length() < 1) {
                this.rs.updateNull(fname);
            } else {
                int type = this.getFieldType(columnindex);
                int colLen = this.getFieldSize(columnindex);
                switch (type) {
                    case -1: 
                    case 1: 
                    case 12: {
                        if (colLen < fvalue.length()) {
                            String errFld = fname;
                            if (this.view != null) {
                                errFld = this.view.getElement(fname).getAttribute("title");
                                if (errFld == null) {
                                    errFld = this.view.getElement(fname).getAttribute("tab");
                                }
                                if (errFld == null) {
                                    errFld = fname;
                                }
                            }
                            errMsg = errMsg == null ? errFld + " is too long maximum is : " + colLen : errMsg + "\n<br>" + errFld + " is too long maximum is : " + colLen;
                        }
                        this.rs.updateString(fname, fvalue);
                        break;
                    }
                    case -7: {
                        if (fvalue.equals("true")) {
                            this.rs.updateBoolean(fname, true);
                            break;
                        }
                        this.rs.updateBoolean(fname, false);
                        break;
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        int ivalue = Integer.valueOf(fvalue);
                        this.rs.updateInt(fname, ivalue);
                        break;
                    }
                    case 2: {
                        BigDecimal bdValue = new BigDecimal(fvalue);
                        this.rs.updateBigDecimal(fname, bdValue);
                        break;
                    }
                    case -5: {
                        long lvalue = Long.valueOf(fvalue);
                        this.rs.updateLong(fname, lvalue);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        double dvalue = Double.valueOf(fvalue);
                        this.rs.updateDouble(fname, dvalue);
                        break;
                    }
                    case 91: {
                        Date dtvalue = Date.valueOf(fvalue);
                        this.rs.updateDate(fname, dtvalue);
                        break;
                    }
                    case 92: {
                        Time tvalue = Time.valueOf(fvalue);
                        this.rs.updateTime(fname, tvalue);
                        break;
                    }
                    case 93: {
                        Timestamp tsvalue = Timestamp.valueOf(fvalue);
                        this.rs.updateTimestamp(fname, tsvalue);
                        break;
                    }
                    case 2005: {
                        Clob clb = this.db.createClob();
                        clb.setString(1L, fvalue);
                        this.rs.updateClob(fname, clb);
                    }
                }
            }
        }
        catch (SQLException ex) {
            errMsg = fname + " : " + ex.getMessage() + "\n";
            this.log.severe("The SQL Exeption on update field " + fname + " : " + ex);
        }
        catch (NumberFormatException ex) {
            errMsg = fname + " : " + ex.getMessage() + "\n";
            this.log.severe("Number format exception on field = " + fname + " : value = " + fvalue + " : " + ex);
        }
        return errMsg;
    }

    public String updateBytes(String fname, byte[] bdata) {
        String errMsg = null;
        try {
            this.rs.updateBytes(fname, bdata);
        }
        catch (SQLException ex) {
            errMsg = fname + " : " + ex.getMessage() + "\n";
            this.log.severe("The SQL Exeption on updateBytes field " + fname + " : " + ex);
        }
        return errMsg;
    }

    public byte[] getBytes(String fname) {
        try {
            byte[] bdata = this.rs.getBytes(fname);
            return bdata;
        }
        catch (SQLException ex) {
            this.log.severe("The SQL Exeption on updateBytes field " + fname + " : " + ex);
            return null;
        }
    }

    public String recDelete() {
        String errMsg = null;
        this.errCode = 0;
        try {
            String recordid = this.getKeyField();
            this.rs.deleteRow();
            this.recAudit("DELETE", recordid);
        }
        catch (SQLException ex) {
            errMsg = this.getErrMessage(ex.getMessage()) + "\n";
            this.errCode = ex.getErrorCode();
            this.log.severe("Delete row error : " + ex);
        }
        return errMsg;
    }

    public boolean recAdd() {
        this.addNewBlock = new HashMap<String, String>();
        this.isAddNew = true;
        this.errCode = 0;
        return this.isAddNew;
    }

    public boolean recEdit() {
        this.errCode = 0;
        if (!this.isAddNew) {
            this.isEdit = true;
            this.changeTrack = "{userid:" + this.user.getUserID();
        }
        return this.isEdit;
    }

    public String recSave() {
        String errMsg = "";
        this.errCode = 0;
        try {
            if (this.isAddNew) {
                errMsg = this.saveNewRec();
                if (errMsg == null) {
                    this.recAudit("INSERT", this.keyFieldId);
                    this.isAddNew = false;
                }
            } else if (this.isEdit) {
                if (this.db.isFullAudit(this.tableName) || this.auditID != null) {
                    String autoKeyID = this.db.insAudit(this.tableName, this.getString(this.keyField), "PREPARE");
                    if (this.auditID != null) {
                        this.rs.updateInt(this.auditID, (int)Integer.valueOf(autoKeyID));
                    }
                    if (this.db.isFullAudit(this.tableName)) {
                        this.changeTrack = this.changeTrack + "}";
                        this.db.insAuditDetails(autoKeyID, this.changeTrack);
                        System.out.println("changes : " + this.changeTrack);
                    }
                }
                this.rs.updateRow();
                this.rs.moveToCurrentRow();
                this.recAudit("EDIT", null);
                this.isEdit = false;
            }
        }
        catch (SQLException ex) {
            this.errCode = ex.getErrorCode();
            errMsg = this.getErrMessage(null);
            errMsg = errMsg == null ? ex.getMessage() + "\n" : errMsg + "\n";
            this.log.severe("Update record error : " + ex);
            this.log.severe("The error code " + this.errCode);
        }
        if (errMsg == null) {
            errMsg = "";
        }
        return errMsg;
    }

    public String saveNewRec() {
        String errMsg = null;
        String fname = "";
        String fvalue = "";
        if (this.auditID != null) {
            String autoKeyID = this.db.insAudit(this.tableName, "NEW", "PREPARE");
            this.addNewBlock.put(this.auditID, autoKeyID);
        }
        if (this.iforg && this.orgID != null && !this.addNewBlock.containsKey(this.orgID)) {
            if (this.userOrg != null) {
                this.addNewBlock.put(this.orgID, this.userOrg);
            } else {
                this.addNewBlock.put(this.orgID, "0");
            }
        }
        String usql = "INSERT INTO " + this.tableName + " (";
        if (this.db.getDBSchema() != null) {
            usql = "INSERT INTO " + this.db.getDBSchema() + "." + this.tableName + " (";
        }
        String psql = ") VALUES (";
        boolean ff = true;
        for (String field : this.addNewBlock.keySet()) {
            if (ff) {
                ff = false;
            } else {
                usql = usql + ", ";
                psql = psql + ", ";
            }
            usql = usql + field;
            psql = psql + "?";
        }
        usql = usql + psql + ")";
        this.log.fine("BASE 100 : " + usql);
        try {
            PreparedStatement ps = this.db.getDB().prepareStatement(usql, 1);
            int col = 1;
            int columnindex = -1;
            int type = -1;
            int colLen = -1;
            Iterator<String> iterator = this.addNewBlock.keySet().iterator();
            while (iterator.hasNext()) {
                String field;
                fname = field = iterator.next();
                fvalue = this.addNewBlock.get(field);
                columnindex = this.rs.findColumn(field);
                type = this.getFieldType(columnindex);
                colLen = this.getFieldSize(columnindex);
                this.log.fine("BASE 1010 : " + col + " : " + fname + " : " + fvalue + " : " + type + " : " + colLen);
                switch (type) {
                    case -1: 
                    case 1: 
                    case 12: {
                        if (colLen < fvalue.length()) {
                            String errFld = fname;
                            if (this.view != null) {
                                errFld = this.view.getElement(fname).getAttribute("title");
                                if (errFld == null) {
                                    errFld = this.view.getElement(fname).getAttribute("tab");
                                }
                                if (errFld == null) {
                                    errFld = fname;
                                }
                            }
                            errMsg = errMsg == null ? errFld + " is too long maximum is : " + colLen : errMsg + "\n<br>" + errFld + " is too long maximum is : " + colLen;
                        }
                        ps.setString(col, fvalue);
                        break;
                    }
                    case -7: {
                        if (fvalue.equals("true")) {
                            ps.setBoolean(col, true);
                            break;
                        }
                        ps.setBoolean(col, false);
                        break;
                    }
                    case -6: 
                    case 4: 
                    case 5: {
                        int ivalue = Integer.valueOf(fvalue);
                        ps.setInt(col, ivalue);
                        break;
                    }
                    case 2: {
                        BigDecimal bdValue = new BigDecimal(fvalue);
                        ps.setBigDecimal(col, bdValue);
                        break;
                    }
                    case -5: {
                        long lvalue = Long.valueOf(fvalue);
                        ps.setLong(col, lvalue);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        double dvalue = Double.valueOf(fvalue);
                        ps.setDouble(col, dvalue);
                        break;
                    }
                    case 91: {
                        Date dtvalue = Date.valueOf(fvalue);
                        ps.setDate(col, dtvalue);
                        break;
                    }
                    case 92: {
                        Time tvalue = Time.valueOf(fvalue);
                        ps.setTime(col, tvalue);
                        break;
                    }
                    case 93: {
                        Timestamp tsvalue = Timestamp.valueOf(fvalue);
                        ps.setTimestamp(col, tsvalue);
                        break;
                    }
                    case 2005: {
                        Clob clb = this.db.createClob();
                        clb.setString(1L, fvalue);
                        ps.setClob(col, clb);
                        break;
                    }
                    default: {
                        ps.setString(col, fvalue);
                    }
                }
                ++col;
            }
            ps.executeUpdate();
            ResultSet rsb = ps.getGeneratedKeys();
            if (rsb.next()) {
                this.keyFieldId = rsb.getString(1);
                if (this.db.getDBType() == 2) {
                    this.filter("rowid = '" + this.keyFieldId + "'", null);
                } else {
                    this.filter(this.getKeyFieldName() + " = '" + this.keyFieldId + "'", null);
                }
                this.moveFirst();
            }
        }
        catch (SQLException ex) {
            this.errCode = ex.getErrorCode();
            String errCodeMsg = this.getErrMessage(null);
            if (errCodeMsg == null) {
                errCodeMsg = ex.getMessage();
            }
            errMsg = errMsg == null ? errCodeMsg + "\n" : errMsg + "\n<br>" + errCodeMsg + "\n";
            this.log.severe("The SQL Exeption on new record " + fname + " : " + ex);
            this.log.severe("The error code " + this.errCode);
        }
        catch (NumberFormatException ex) {
            errMsg = fname + " : " + ex.getMessage() + "\n";
            this.log.severe("Number format exception on field = " + fname + " : value = " + fvalue + " : " + ex);
        }
        return errMsg;
    }

    public String updateFields(Map<String, String[]> reqParams, List<String> viewData, String remoteAddr, String linkData) {
        String saveMsg = "";
        for (BElement el : this.view.getElements()) {
            String[] dataValues = reqParams.get(el.getValue());
            String dataValue = null;
            if (dataValues != null && dataValues.length > 0) {
                dataValue = dataValues[0];
            }
            if (dataValue != null && dataValue.trim().equals("")) {
                dataValue = null;
            }
            if (el.getAttribute("enabled", "true").equals("false")) continue;
            if (el.getName().equals("CHECKBOX")) {
                if (el.getAttribute("ischar") == null) {
                    if (dataValue == null) {
                        saveMsg = saveMsg + this.updateField(el.getValue(), "false");
                        continue;
                    }
                    saveMsg = saveMsg + this.updateField(el.getValue(), dataValue);
                    continue;
                }
                if (dataValue == null) {
                    saveMsg = saveMsg + this.updateField(el.getValue(), "0");
                    continue;
                }
                saveMsg = saveMsg + this.updateField(el.getValue(), "1");
                continue;
            }
            if (el.getName().equals("USERFIELD")) {
                saveMsg = saveMsg + this.updateField(el.getValue(), this.user.getUserID());
                continue;
            }
            if (el.getName().equals("USERNAME")) {
                saveMsg = saveMsg + this.updateField(el.getValue(), this.user.getUserName());
                continue;
            }
            if (el.getName().equals("REMOTEIP")) {
                saveMsg = saveMsg + this.updateField(el.getValue(), remoteAddr);
                continue;
            }
            if (el.getName().equals("DEFAULT")) {
                saveMsg = saveMsg + this.updateField(el.getValue(), el.getAttribute("default"));
                continue;
            }
            if (el.getName().equals("FUNCTION")) {
                if (el.getAttribute("when", "").equals("new")) {
                    if (!"!new!".equals(linkData)) continue;
                    saveMsg = saveMsg + this.updateField(el.getValue(), this.db.executeFunction(el.getAttribute("function")));
                    continue;
                }
                if (el.getAttribute("function") == null) continue;
                saveMsg = saveMsg + this.updateField(el.getValue(), this.db.executeFunction(el.getAttribute("function")));
                continue;
            }
            if (el.getName().equals("LEVELKEY")) {
                int vds = viewData.size();
                int lvl = Integer.valueOf(el.getAttribute("level", "0"));
                String levelKeyData = viewData.get(vds - lvl);
                this.updateField(el.getValue(), levelKeyData);
                continue;
            }
            if (dataValue == null) {
                this.updateField(el.getValue(), null);
                continue;
            }
            if (el.getName().equals("COMBOBOX")) {
                this.updateField(el.getValue(), dataValue);
                continue;
            }
            if (el.getName().equals("COMBOLIST")) {
                saveMsg = saveMsg + this.updateField(el.getValue(), dataValue);
                continue;
            }
            if (el.getName().equals("PICTURE")) {
                saveMsg = saveMsg + this.updateField(el.getValue(), dataValue);
                continue;
            }
            if (el.getName().equals("MULTISELECT")) {
                String msv = null;
                if (dataValues.length > 0) {
                    for (String msvs : dataValues) {
                        msv = msv == null ? msvs : msv + "," + msvs;
                    }
                }
                saveMsg = saveMsg + this.updateField(el.getValue(), msv);
                continue;
            }
            if (el.getName().equals("TEXTDECIMAL")) {
                dataValue = dataValue.replace(",", "");
                saveMsg = saveMsg + this.updateField(el.getValue(), dataValue);
                continue;
            }
            if (el.getName().equals("TEXTDATE")) {
                String dbdate = BDateFormat.parseDate(dataValue, el.getAttribute("dbformat"), this.db.getDBType());
                if (dbdate != null) {
                    saveMsg = saveMsg + this.updateField(el.getValue(), dbdate);
                    continue;
                }
                saveMsg = saveMsg + "Date format error for : " + el.getValue() + "<br>\n";
                continue;
            }
            if (el.getName().equals("TEXTTIMESTAMP")) {
                String dbdate = BDateFormat.parseTimeStamp(dataValue);
                if (dbdate != null) {
                    saveMsg = saveMsg + this.updateField(el.getValue(), dbdate);
                    continue;
                }
                saveMsg = saveMsg + "Date format error for : " + el.getValue() + "<br>\n";
                continue;
            }
            if (el.getName().equals("SPINTIME")) {
                String dbdate = BDateFormat.parseTime(dataValue, el.getAttribute("type", "1"));
                if (dbdate != null) {
                    saveMsg = saveMsg + this.updateField(el.getValue(), dbdate);
                    continue;
                }
                saveMsg = saveMsg + "Time format error for : " + el.getValue() + "<br>\n";
                continue;
            }
            if (dataValue == null) continue;
            saveMsg = saveMsg + this.updateField(el.getValue(), dataValue);
        }
        if (!"".equals(saveMsg)) {
            saveMsg = saveMsg + "<br>";
        }
        saveMsg = saveMsg + this.recSave();
        return saveMsg;
    }

    public String getErrMessage(String err) {
        String errSql;
        String errAns;
        String errCheck = err;
        if (err == null) {
            errCheck = Integer.toString(this.errCode);
        }
        if ((errAns = this.db.executeFunction(errSql = "SELECT error_message FROM sys_errors WHERE sys_error = '" + errCheck + "';")) == null) {
            errAns = err;
        }
        return errAns;
    }

    public void cancel() {
        this.isAddNew = false;
        this.isEdit = false;
    }

    public void recAudit(String changetype, String oldRecordid) {
        if (this.noaudit) {
            return;
        }
        if (this.keyField == null) {
            return;
        }
        String recordid = oldRecordid;
        if (oldRecordid == null) {
            recordid = this.getString(this.keyField);
        }
        if (recordid == null) {
            try {
                String pksql = "SELECT " + this.keyField + " FROM " + this.tableName;
                ResultSet pkrs = this.db.readQuery(pksql);
                pkrs.last();
                recordid = pkrs.getString(this.keyField);
                pkrs.close();
            }
            catch (SQLException pksql) {
                // empty catch block
            }
        }
        if (this.user != null) {
            String inssql = "INSERT INTO sys_audit_trail (user_id, user_ip, table_name, record_id, change_type) VALUES('";
            inssql = inssql + this.user.getUserID() + "', '" + this.user.getUserIP() + "', '" + this.tableName + "', '" + recordid + "', '" + changetype + "')";
            this.log.fine(inssql);
            this.db.executeQuery(inssql);
        }
    }

    public List<String> getFields() {
        ArrayList<String> fieldList = new ArrayList<String>();
        try {
            for (int column = 1; column <= this.colnum; ++column) {
                fieldList.add(this.rsmd.getColumnLabel(column));
            }
        }
        catch (SQLException ex) {
            this.log.severe("Field Name read error : " + ex);
        }
        return fieldList;
    }

    public Vector<String> getAutoFields() {
        this.autoFields = new Vector();
        try {
            for (int column = 1; column <= this.colnum; ++column) {
                if (!this.rsmd.isAutoIncrement(column)) continue;
                this.autoFields.add(this.rsmd.getColumnLabel(column));
            }
        }
        catch (SQLException ex) {
            this.log.severe("Field Name read error : " + ex);
        }
        return this.autoFields;
    }

    public int getFieldSize(int column) {
        int fieldSize = -1;
        try {
            if (column <= this.colnum) {
                fieldSize = this.rsmd.getColumnDisplaySize(column);
            }
        }
        catch (SQLException ex) {
            this.log.severe("Field size error : " + ex);
        }
        return fieldSize;
    }

    public int getFieldType(String columnName) {
        int fieldType = -1;
        try {
            int column = this.rs.findColumn(columnName);
            if (column <= this.colnum) {
                fieldType = this.rsmd.getColumnType(column);
            }
        }
        catch (SQLException ex) {
            this.log.severe("Field type read error : " + ex);
        }
        return fieldType;
    }

    public int getFieldType(int column) {
        int fieldType = -1;
        try {
            if (column <= this.colnum) {
                fieldType = this.rsmd.getColumnType(column);
            }
        }
        catch (SQLException ex) {
            this.log.severe("Field type read error : " + ex);
        }
        return fieldType;
    }

    public void readData() {
        this.readData(-1);
    }

    public void readData(int limit) {
        if (this.rs == null) {
            return;
        }
        try {
            if (!this.readonly) {
                this.rs.beforeFirst();
            }
            int i = 0;
            this.data.clear();
            this.keyFieldData.clear();
            while (this.rs.next()) {
                Vector<Object> newRow = new Vector<Object>();
                if (this.view == null) {
                    for (int column = 1; column <= this.titles.size(); ++column) {
                        newRow.addElement(this.rs.getObject(column));
                    }
                } else {
                    for (BElement el : this.view.getElements()) {
                        String fldName = el.getValue();
                        if (fldName.trim().equals("")) continue;
                        if (el.getName().equals("CHECKBOX")) {
                            newRow.addElement(this.rs.getBoolean(fldName));
                            continue;
                        }
                        if (el.getAttribute("java") != null) {
                            String javaCall = el.getAttribute("java");
                            if (!javaCall.equals("password")) continue;
                            newRow.addElement(BCipher.password(this.rs.getString(fldName)));
                            continue;
                        }
                        newRow.addElement(this.rs.getObject(fldName));
                    }
                }
                if (this.keyField != null) {
                    this.keyFieldData.addElement(this.rs.getString(this.keyField));
                }
                this.data.addElement(newRow);
                if (!(limit > 0 & limit < i)) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (SQLException ex) {
            this.log.severe("Field data read error : " + ex);
        }
    }

    public String readDocument(boolean heading, boolean trim) {
        StringBuffer mystr = new StringBuffer();
        try {
            this.rs.beforeFirst();
            if (heading) {
                mystr.append("<table class='table table-hover'>\n");
                mystr.append("<thead><tr>");
                if (this.view == null) {
                    for (int column = 0; column < this.titles.size(); ++column) {
                        mystr.append("<th>" + this.titles.get(column) + "</th>");
                    }
                } else {
                    for (BElement el : this.view.getElements()) {
                        if (el.getValue().equals("")) continue;
                        mystr.append("<th>" + el.getAttribute("title") + "</th>");
                    }
                }
                mystr.append("</tr></thead>");
            }
            mystr.append("\n<tbody>");
            boolean alt = true;
            while (this.rs.next()) {
                if (alt) {
                    mystr.append("<tr>");
                    alt = false;
                } else {
                    mystr.append("<tr>");
                    alt = true;
                }
                if (this.view == null) {
                    for (int column = 1; column <= this.titles.size(); ++column) {
                        String cd = this.rs.getString(column);
                        if (cd == null) {
                            mystr.append("<td></td>");
                            continue;
                        }
                        mystr.append("<td>");
                        if (trim && cd.length() > 25) {
                            mystr.append(cd.substring(0, 24));
                        } else {
                            mystr.append(cd);
                        }
                        mystr.append("</td>");
                    }
                } else {
                    for (BElement el : this.view.getElements()) {
                        if (el.getValue().equals("")) continue;
                        String cd = this.formatData(el);
                        mystr.append("<td>");
                        if (trim && cd.length() > 25) {
                            mystr.append(cd.substring(0, 24));
                        } else {
                            mystr.append(cd);
                        }
                        mystr.append("</td>");
                    }
                }
                mystr.append("</tr>\n");
            }
            mystr.append("</tbody>");
            if (heading) {
                mystr.append("\n</table>");
            }
        }
        catch (SQLException ex) {
            this.log.severe("Field read data error : " + ex);
        }
        return mystr.toString();
    }

    public String getJSON() {
        JsonArrayBuilder myja = Json.createArrayBuilder();
        try {
            this.rs.beforeFirst();
            while (this.rs.next()) {
                JsonObjectBuilder myjo = Json.createObjectBuilder();
                if (this.view == null) {
                    for (int column = 0; column < this.titles.size(); ++column) {
                        String cValue = this.rs.getString(column + 1);
                        if (this.titles.get(column) == null || cValue == null) continue;
                        myjo.add(this.titles.get(column), this.rs.getString(column + 1));
                    }
                } else {
                    for (BElement el : this.view.getElements()) {
                        if (el.getValue().equals("")) continue;
                        myjo.add(el.getValue(), this.formatData(el));
                    }
                    myjo.add("keyfield", this.getKeyField());
                }
                myja.add(myjo);
            }
        }
        catch (SQLException ex) {
            this.log.severe("Field read data error : " + ex);
        }
        JsonArray jsTb = myja.build();
        return jsTb.toString();
    }

    public String getRowJSON() {
        JsonObjectBuilder myjo = Json.createObjectBuilder();
        try {
            if (this.view == null) {
                for (int column = 0; column < this.titles.size(); ++column) {
                    myjo.add(this.titles.get(column), this.rs.getString(column + 1));
                }
            } else {
                for (BElement el : this.view.getElements()) {
                    if (el.getValue().equals("")) continue;
                    myjo.add(el.getValue(), this.formatData(el));
                }
                myjo.add("keyfield", this.getKeyField());
            }
        }
        catch (SQLException ex) {
            this.log.severe("Field read data error : " + ex);
        }
        return myjo.build().toString();
    }

    public String getFooter() {
        StringBuffer mystr = new StringBuffer();
        try {
            this.rs.beforeFirst();
            block2: while (this.rs.next()) {
                int column;
                if (this.view == null) {
                    for (column = 1; column <= this.titles.size(); ++column) {
                        String cd = this.rs.getString(column);
                        if (cd != null) {
                            if (cd.length() > 25) {
                                mystr.append(cd.substring(0, 24));
                            } else {
                                mystr.append(cd);
                            }
                            mystr.append(", ");
                        }
                        if (column > 2) continue block2;
                    }
                    continue;
                }
                column = 1;
                for (BElement el : this.view.getElements()) {
                    if (!el.getValue().equals("")) {
                        String cd = this.formatData(el);
                        if (cd.length() > 25) {
                            mystr.append(cd.substring(0, 24));
                        } else {
                            mystr.append(cd);
                        }
                        mystr.append(",");
                    }
                    if (column > 2) continue block2;
                    ++column;
                }
            }
        }
        catch (SQLException ex) {
            this.log.severe("Field read data error : " + ex);
        }
        return mystr.toString();
    }

    public Vector<Vector<Object>> getData() {
        return this.data;
    }

    public void importData(Vector<Vector<Object>> newData) {
        for (int j = 0; j < newData.size(); ++j) {
            Vector<Object> newRow = newData.get(j);
            if (this.keyFieldData.contains(newRow.get(0).toString())) continue;
            this.recAdd();
            int i = 0;
            for (BElement el : this.view.getElements()) {
                String errStr;
                if (!el.getValue().equals("") && newRow.get(i) != null && !(errStr = this.updateField(el.getValue(), newRow.get(i).toString())).equals("")) {
                    this.log.severe(newRow.get(0).toString());
                }
                ++i;
            }
            String errStr = this.recSave();
            if (errStr.equals("")) continue;
            this.log.severe(newRow.get(0).toString());
        }
    }

    public int getColumnCount() {
        return this.titles.size();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public void removeRow(int aRow) {
        if (aRow >= 0) {
            this.data.remove(aRow);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName(int aCol) {
        return this.titles.get(aCol);
    }

    public Vector<String> getFieldNames() {
        return this.fieldNames;
    }

    public String getFieldName(int aCol) {
        return this.fieldNames.get(aCol);
    }

    public Vector<String> getColumnNames() {
        return this.titles;
    }

    public Vector<String> getKeyFieldData() {
        return this.keyFieldData;
    }

    public void addColumnName(String title) {
        this.titles.add(title);
    }

    public Object getValueAt(int aRow, int aCol) {
        return this.data.get(aRow).get(aCol);
    }

    public String getKeyFieldName() {
        return this.keyField;
    }

    public String getKeyField() {
        String key = null;
        if (this.keyField != null) {
            key = this.readField(this.keyField);
        }
        return key;
    }

    public int insertRow() {
        Vector<String> dataRow = new Vector<String>();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            dataRow.add("");
        }
        this.data.add(dataRow);
        return this.data.size();
    }

    public int insertRow(Vector<Object> dataRow) {
        this.data.add(dataRow);
        return this.data.size();
    }

    public void setValueAt(Object value, int aRow, int aCol) {
        Vector<Object> dataRow = this.data.elementAt(aRow);
        dataRow.setElementAt(value, aCol);
        if (this.updateTable != null) {
            String autoKeyID = this.db.insAudit(this.tableName, this.keyFieldData.get(aRow), "EDIT");
            String sql = "UPDATE " + this.updateTable + " SET " + this.fieldNames.get(aCol);
            sql = value == null ? sql + " = null" : (this.view.getElement(aCol).getAttribute("ischar", "false").equals("true") ? (value.equals("true") ? sql + " = '1'" : sql + " = '0'") : sql + " = '" + value.toString() + "'");
            if (this.auditID != null) {
                sql = sql + ", " + this.auditID + " = " + autoKeyID;
            }
            sql = sql + " WHERE " + this.getKeyFieldName() + " = '" + this.keyFieldData.get(aRow) + "'";
            this.log.fine(sql);
            this.db.executeQuery(sql);
        }
    }

    public String getViewSQL() {
        return this.db.getViewSQL(this.tableName);
    }

    public void clear() {
        this.data.clear();
    }

    public BElement getDeskConfig(int cfg) {
        BElement tel = null;
        this.ForeignLinks = this.db.getForeignLinks(this.tableName);
        if (this.ForeignLinks.size() > 0) {
            if (this.db.getViews().contains("vw_" + this.tableName)) {
                String lsql = "SELECT * FROM vw_" + this.tableName;
                BQuery newquery = new BQuery(this.db, lsql);
                tel = newquery.getGridConfig();
                tel.setAttribute("name", this.initCap(this.tableName));
                tel.setAttribute("keyfield", this.getColumnName(0));
                tel.setAttribute("table", "vw_" + this.tableName);
                newquery.close();
            } else {
                tel = this.getGridConfig();
            }
        } else {
            tel = this.getGridConfig();
        }
        if (cfg == 1) {
            tel.setAttribute("linkfield", this.getFieldName(1));
        }
        tel.addNode(this.getFormConfig(cfg));
        return tel;
    }

    public BElement getTableConfig() {
        BElement tel = this.getGridConfig();
        tel.addNode(this.getFormConfig(0));
        return tel;
    }

    public BElement getGridConfig() {
        BElement tel = new BElement("GRID");
        if (this.rs == null) {
            return tel;
        }
        try {
            tel.setAttribute("name", this.initCap(this.tableName));
            tel.setAttribute("keyfield", this.rsmd.getColumnLabel(1));
            tel.setAttribute("table", this.tableName);
            for (int column = 1; column <= this.colnum; ++column) {
                String colType = this.getFormField(column);
                int fieldSize = this.rsmd.getColumnDisplaySize(column);
                if (colType.equals("TEXTFIELD") && fieldSize == 1) {
                    colType = "CHECKBOX";
                }
                BElement fel = new BElement(colType);
                String fieldname = this.rsmd.getColumnLabel(column);
                fel.setAttribute("title", this.initCap(fieldname));
                fel.setAttribute("w", "75");
                fel.setValue(fieldname);
                if (fieldSize >= 500) continue;
                tel.addNode(fel);
            }
        }
        catch (SQLException ex) {
            this.log.severe("Gid configs read error : " + ex);
        }
        return tel;
    }

    public BElement getFormConfig(int cfg) {
        BElement tel = new BElement("FORM");
        if (this.rs == null) {
            return tel;
        }
        try {
            tel.setAttribute("name", this.initCap(this.tableName));
            tel.setAttribute("table", this.tableName);
            tel.setAttribute("keyfield", this.rsmd.getColumnLabel(1));
            int y = 10;
            int x = 10;
            int w = 150;
            int h = 20;
            int startCol = 1;
            this.ForeignLinks = this.db.getForeignLinks(this.tableName);
            if (cfg == 1) {
                tel.setAttribute("linkfield", this.getFieldName(1));
            }
            for (int column = startCol; column <= this.colnum; ++column) {
                String fieldName = this.rsmd.getColumnLabel(column);
                int fieldSize = this.rsmd.getColumnDisplaySize(column);
                String colType = this.getFormField(column);
                boolean ischar = false;
                boolean fieldShow = true;
                if (this.rsmd.isAutoIncrement(column)) {
                    fieldShow = false;
                }
                if (cfg == 1 && column == 2) {
                    fieldShow = false;
                }
                if (fieldName.equals("org_id")) {
                    fieldShow = false;
                }
                if (!fieldShow) continue;
                BTableLinks tbLink = null;
                for (BTableLinks tbLinks : this.ForeignLinks) {
                    if (!tbLinks.getKeyColumn().equals(fieldName)) continue;
                    tbLink = tbLinks;
                    colType = "COMBOBOX";
                    fieldSize = 250;
                }
                w = 150;
                if (colType.equals("TEXTFIELD") && fieldSize == 1) {
                    colType = "CHECKBOX";
                    ischar = true;
                }
                if (fieldSize > 1000) {
                    colType = "TEXTAREA";
                }
                if (fieldSize > 110) {
                    w = 430;
                    if (x == 290) {
                        y += h;
                        x = 10;
                    }
                }
                h = 20;
                if (colType.equals("TEXTAREA")) {
                    h = 70;
                }
                BElement fel = new BElement(colType);
                fel.setValue(fieldName);
                fel.setAttribute("title", this.initCap(fieldName));
                fel.setAttribute("x", Integer.toString(x));
                fel.setAttribute("y", Integer.toString(y));
                fel.setAttribute("w", Integer.toString(w));
                fel.setAttribute("h", Integer.toString(h));
                if (ischar) {
                    fel.setAttribute("ischar", "true");
                }
                if (tbLink != null) {
                    fel.setAttribute("lptable", tbLink.getForeignTable());
                    String mysql = "SELECT " + tbLink.getForeignColumn().replace("_id", "_name") + " FROM " + tbLink.getForeignTable();
                    ResultSet lrs = this.db.readQuery(mysql, 1);
                    if (lrs == null) {
                        fel.setAttribute("lpfield", tbLink.getForeignColumn());
                    } else {
                        fel.setAttribute("lpfield", tbLink.getForeignColumn().replace("_id", "_name"));
                    }
                    if (lrs != null) {
                        lrs.close();
                    }
                    if (!fieldName.equals(tbLink.getForeignColumn())) {
                        fel.setAttribute("lpkey", tbLink.getForeignColumn());
                    }
                }
                tel.addNode(fel);
                if (x == 10) {
                    if (w == 430) {
                        y += h;
                        continue;
                    }
                    x = 290;
                    continue;
                }
                x = 10;
                y += h;
            }
        }
        catch (SQLException ex) {
            this.log.severe("Form config read error : " + ex);
        }
        return tel;
    }

    public BElement getMigrateConfig() {
        BElement imp = new BElement("IMPORT");
        BElement exp = new BElement("EXPORT");
        if (this.rs == null) {
            return imp;
        }
        try {
            imp.setAttribute("name", this.initCap(this.tableName));
            imp.setAttribute("keyfield", this.rsmd.getColumnLabel(1));
            imp.setAttribute("noaudit", "true");
            imp.setAttribute("table", this.tableName);
            exp.setAttribute("name", this.initCap(this.tableName));
            exp.setAttribute("keyfield", this.rsmd.getColumnLabel(1));
            exp.setAttribute("table", this.tableName);
            for (int column = 1; column <= this.colnum; ++column) {
                String colType = this.getFormField(column);
                BElement fel = new BElement(colType);
                String fieldname = this.rsmd.getColumnLabel(column);
                fel.setAttribute("title", this.initCap(fieldname));
                fel.setAttribute("w", "75");
                fel.setValue(fieldname);
                imp.addNode(fel);
                exp.addNode(fel);
            }
            imp.addNode(exp);
        }
        catch (SQLException ex) {
            this.log.severe("Gid configs read error : " + ex);
        }
        return imp;
    }

    public Class getColumnClass(int aCol) {
        int type = 12;
        if (this.db != null) {
            type = this.getFieldType(aCol + 1);
        }
        if (this.view != null && this.view.getElement(aCol).getName().equals("CHECKBOX")) {
            return Boolean.class;
        }
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -7: {
                return Boolean.class;
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 7: 
            case 8: {
                return Double.class;
            }
            case 92: {
                return Time.class;
            }
            case 93: {
                return Timestamp.class;
            }
            case 91: {
                return Date.class;
            }
        }
        return Object.class;
    }

    public String getFormField(int aCol) {
        String coltype = "TEXTFIELD";
        switch (this.getFieldType(aCol)) {
            case 1: 
            case 12: {
                coltype = "TEXTFIELD";
                break;
            }
            case -1: 
            case 2005: {
                coltype = "TEXTAREA";
                break;
            }
            case -7: {
                coltype = "CHECKBOX";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                coltype = "TEXTFIELD";
                break;
            }
            case -5: {
                coltype = "TEXTFIELD";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                coltype = "TEXTDECIMAL";
                break;
            }
            case 91: {
                coltype = "TEXTDATE";
                break;
            }
            case 92: {
                coltype = "SPINTIME";
                break;
            }
            case 93: {
                coltype = "TEXTTIMESTAMP";
            }
        }
        return coltype;
    }

    public List<BTableLinks> getLinks() {
        return this.ForeignLinks;
    }

    public List<BTableLinks> getLinks(List<String> linkTables) {
        for (BTableLinks tbl : this.ForeignLinks) {
            tbl.setActive(linkTables);
        }
        return this.ForeignLinks;
    }

    public String initCap(String mystr) {
        if (mystr != null) {
            mystr = mystr.toLowerCase();
            String[] mylines = mystr.split("_");
            mystr = "";
            for (String myline : mylines) {
                String newline = "";
                if (myline.length() > 0) {
                    newline = myline.replaceFirst(myline.substring(0, 1), myline.substring(0, 1).toUpperCase());
                    if (myline.trim().toUpperCase().equals("ID")) {
                        newline = "ID";
                    }
                    if (myline.trim().toUpperCase().equals("IS")) {
                        newline = null;
                    }
                }
                if (newline == null) continue;
                mystr = mystr + newline + " ";
            }
            mystr = mystr.trim();
        }
        return mystr;
    }

    public String formatData(BElement el) {
        String response = "";
        String format = el.getAttribute("format");
        String pattern = el.getAttribute("pattern");
        if (format == null) {
            if (el.getName().equals("TEXTDATE")) {
                format = "date";
            } else if (el.getName().equals("TEXTTIMESTAMP")) {
                format = "timestamp";
            } else if (el.getName().equals("CHECKBOX")) {
                format = "boolean";
            } else if (el.getName().equals("TEXTDECIMAL")) {
                format = "double";
            } else if (el.getName().equals("SPINTIME")) {
                format = "time";
            }
        }
        try {
            if (this.rs.getString(el.getValue()) == null) {
                response = "";
            } else if (format == null) {
                response = this.rs.getString(el.getValue());
            } else if (format.equals("clob")) {
                Clob cl = this.rs.getClob(el.getValue());
                if (cl != null) {
                    response = cl.getSubString(1L, (int)cl.length());
                }
            } else if (format.equals("boolean")) {
                response = this.rs.getBoolean(el.getValue()) ? "Yes" : "No";
            } else if (format.equals("boolcolor")) {
                response = this.rs.getBoolean(el.getValue()) ? "*" : "&nbsp;";
            } else if (format.equals("date")) {
                String mydate;
                if (pattern == null) {
                    pattern = "dd-MMM-yyyy";
                }
                SimpleDateFormat dateformatter = new SimpleDateFormat(pattern);
                response = mydate = dateformatter.format(this.rs.getDate(el.getValue()));
            } else if (format.equals("time")) {
                String mydate;
                if (pattern == null) {
                    pattern = "HH:mm";
                }
                SimpleDateFormat dateformatter = new SimpleDateFormat(pattern);
                response = mydate = dateformatter.format(this.rs.getTime(el.getValue()));
            } else if (format.equals("timestamp")) {
                String mydate;
                if (pattern == null) {
                    pattern = "MMM dd, yyyy hh:mm a";
                }
                SimpleDateFormat dateformatter = new SimpleDateFormat(pattern);
                response = mydate = dateformatter.format(this.rs.getTimestamp(el.getValue()));
            } else if (format.equals("double")) {
                if (pattern == null) {
                    NumberFormat numberFormatter = NumberFormat.getNumberInstance();
                    response = numberFormatter.format(this.rs.getDouble(el.getValue()));
                } else {
                    DecimalFormat myFormatter = new DecimalFormat(pattern);
                    response = myFormatter.format(this.rs.getDouble(el.getValue()));
                }
            }
        }
        catch (SQLException ex) {
            this.log.severe("Query data field formating error : " + el.getName() + " : " + el.getValue() + " : " + ex);
        }
        return response;
    }

    public void savecvs(String filename) {
        String mystr = "";
        for (int i = 0; i < this.getRowCount(); ++i) {
            int colcount = this.getColumnCount() - 1;
            for (int j = 0; j <= colcount; ++j) {
                mystr = j == colcount ? mystr + this.getCsvValueAt(i, j) + "\r\n" : mystr + this.getCsvValueAt(i, j) + ",";
            }
        }
        Bio io = new Bio();
        io.saveFile(filename, mystr);
    }

    public String getCsv() {
        String mystr = "";
        boolean isTitle = true;
        if (this.view != null && this.view.getAttribute("notitle", "false").equals("true")) {
            isTitle = false;
        }
        if (isTitle) {
            for (String title : this.titles) {
                mystr = mystr + title + ",";
            }
            mystr = mystr + "\r\n";
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            int colcount = this.getColumnCount() - 1;
            for (int j = 0; j <= colcount; ++j) {
                mystr = j == colcount ? mystr + this.getCsvValueAt(i, j) + "\r\n" : mystr + this.getCsvValueAt(i, j) + ",";
            }
        }
        return mystr;
    }

    public String getCsvValueAt(int aRow, int aColumn) {
        Vector<Object> row = this.data.elementAt(aRow);
        Object myobj = row.elementAt(aColumn);
        Class myclass = this.getColumnClass(aColumn);
        String mystr = "";
        if (myobj != null) {
            mystr = myclass == String.class ? (myobj.toString().startsWith("0") ? "\"'" + myobj.toString() + "\"" : "\"" + myobj.toString() + "\"") : myobj.toString();
        }
        return mystr;
    }

    public String getTableXml(String ifNull) {
        BElement tableXml = new BElement(this.view.getAttribute("name"));
        if (this.moveFirst()) {
            for (BElement el : this.view.getElements()) {
                BElement xel = new BElement(el.getAttribute("xmlName"));
                String elValue = this.getString(el.getValue());
                if (elValue == null) {
                    elValue = ifNull;
                }
                xel.setValue(elValue);
                tableXml.addNode(xel);
            }
        }
        return tableXml.toString();
    }

    public String getXmlData(String ifNull) {
        StringBuilder tableXml = new StringBuilder();
        this.beforeFirst();
        while (this.moveNext()) {
            BElement rowXml = new BElement(this.view.getAttribute("name"));
            for (BElement el : this.view.getElements()) {
                BElement xel = new BElement(el.getAttribute("title"));
                String elValue = this.getString(el.getValue());
                if (elValue == null) {
                    elValue = ifNull;
                }
                xel.setValue(elValue);
                rowXml.addNode(xel);
            }
            tableXml.append(rowXml.toString());
        }
        return tableXml.toString();
    }

    public int getDBType() {
        return this.db.getDBType();
    }

    public List<Boolean> getColumnEdits() {
        return this.columnEdit;
    }

    public Map<String, String> getParams() {
        for (String param : this.params.keySet()) {
            this.params.put(param, this.readField(param));
        }
        return this.params;
    }

    public void setTitles(String[] titleArray) {
        this.titles.clear();
        for (String mnName : titleArray) {
            this.titles.add(mnName);
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public int getColnum() {
        return this.colnum;
    }

    public void close() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.st != null) {
                this.st.close();
            }
            this.data.clear();
            this.data = null;
        }
        catch (SQLException ex) {
            this.log.severe("SQL Close Error : " + ex);
        }
    }
}

