/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.util.List;
import java.util.Vector;

public class BTableLinks {
    String keyTable;
    String keyColumn;
    String foreignTable;
    String foreignColumn;
    String joinType;
    boolean active = false;
    boolean keyPresent = true;
    boolean foreignPresent = true;

    public BTableLinks(String keyTable, String keyColumn, String foreignTable, String foreignColumn) {
        this.keyTable = keyTable;
        this.keyColumn = keyColumn;
        this.foreignTable = foreignTable;
        this.foreignColumn = foreignColumn;
        this.joinType = " INNER JOIN ";
    }

    public String getKeyTable() {
        return this.keyTable;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getForeignTable() {
        return this.foreignTable;
    }

    public String getForeignColumn() {
        return this.foreignColumn;
    }

    public void setActive(List<String> sourceTables) {
        this.active = false;
        if (!this.foreignTable.equals(this.keyTable)) {
            for (String sourceTable : sourceTables) {
                if (!sourceTable.equals(this.foreignTable)) continue;
                this.active = true;
            }
        }
    }

    public void setLinked(List<String> sourceTables) {
        for (String sourceTable : sourceTables) {
            if (sourceTable.equals(this.keyTable)) {
                this.keyPresent = false;
            }
            if (!sourceTable.equals(this.foreignTable)) continue;
            this.foreignPresent = false;
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public String toString() {
        String mysql = "";
        if (this.foreignTable.equals(this.keyTable)) {
            mysql = this.keyTable;
        } else if (this.keyPresent && this.foreignPresent) {
            mysql = this.foreignTable + this.joinType + this.keyTable + " ON ";
            mysql = mysql + this.foreignTable + "." + this.foreignColumn + " = " + this.keyTable + "." + this.keyColumn;
        } else if (this.keyPresent) {
            mysql = this.joinType + this.keyTable + " ON ";
            mysql = mysql + this.foreignTable + "." + this.foreignColumn + " = " + this.keyTable + "." + this.keyColumn;
        } else if (this.foreignPresent) {
            mysql = this.joinType + this.foreignTable + " ON ";
            mysql = mysql + this.foreignTable + "." + this.foreignColumn + " = " + this.keyTable + "." + this.keyColumn;
        }
        return mysql;
    }

    public Vector<Object> getData() {
        Vector<Object> dataRow = new Vector<Object>();
        dataRow.add(this.foreignTable);
        dataRow.add(this.foreignColumn);
        dataRow.add(this.joinType);
        dataRow.add(this.keyTable);
        dataRow.add(this.keyColumn);
        return dataRow;
    }
}

