/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.baraza.DB.BDB;
import org.baraza.app.BCalendar;
import org.baraza.app.BDrillDown;
import org.baraza.app.BForm;
import org.baraza.app.BGrid;
import org.baraza.app.BGrids;
import org.baraza.app.BTabs;
import org.baraza.reports.BReport;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

class BFilter
extends JSplitPane
implements TreeSelectionListener,
MouseListener,
ActionListener {
    Logger log = Logger.getLogger(BFilter.class.getName());
    BLogHandle logHandle;
    BDB db;
    Map<String, String> progarationParams;
    Map<String, String> params;
    List<BGrids> grids;
    List<BDrillDown> drilldown;
    List<BCalendar> calendar;
    List<BReport> reports;
    List<BTabs> tabs;
    List<BGrid> filterGrids;
    List<BForm> filterForms;
    JTabbedPane topPanes;
    JTabbedPane bottomPanes;
    JSplitPane splitPane;

    public BFilter(BLogHandle logHandle, BDB db, BElement view, String reportDir) {
        super(1);
        this.db = db;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.grids = new ArrayList<BGrids>();
        this.drilldown = new ArrayList<BDrillDown>();
        this.calendar = new ArrayList<BCalendar>();
        this.reports = new ArrayList<BReport>();
        this.tabs = new ArrayList<BTabs>();
        this.filterGrids = new ArrayList<BGrid>();
        this.filterForms = new ArrayList<BForm>();
        this.progarationParams = new HashMap<String, String>();
        this.params = new HashMap<String, String>();
        int location = Integer.valueOf(view.getAttribute("split", "150"));
        super.setOneTouchExpandable(true);
        super.setDividerLocation(location);
        this.topPanes = new JTabbedPane();
        this.bottomPanes = new JTabbedPane();
        this.topPanes.addMouseListener(this);
        if (view.getAttribute("type", "vert").equals("vert")) {
            super.setOrientation(0);
            super.addImpl(this.topPanes, "top", 1);
            super.addImpl(this.bottomPanes, "bottom", 2);
        } else {
            super.addImpl(this.topPanes, "left", 1);
            super.addImpl(this.bottomPanes, "right", 2);
        }
        for (BElement el : view.getElements()) {
            int gs;
            if (el.getName().equals("GRID")) {
                this.grids.add(new BGrids(logHandle, db, el, reportDir, true));
                gs = this.grids.size() - 1;
                this.bottomPanes.addTab(el.getAttribute("name"), this.grids.get(gs));
                continue;
            }
            if (el.getName().equals("JASPER")) {
                this.reports.add(new BReport(logHandle, db, el, reportDir));
                this.bottomPanes.addTab(el.getAttribute("name"), this.reports.get(this.reports.size() - 1));
                continue;
            }
            if (el.getName().equals("DRILLDOWN")) {
                this.drilldown.add(new BDrillDown(logHandle, db, el, reportDir));
                gs = this.drilldown.size() - 1;
                this.topPanes.addTab(el.getAttribute("name"), this.drilldown.get(gs));
                this.drilldown.get(gs).setListener(this);
                this.tabs.add(new BTabs(4, this.drilldown.size() - 1));
                continue;
            }
            if (el.getName().equals("CALENDAR")) {
                this.calendar.add(new BCalendar(el));
                int cs = this.calendar.size() - 1;
                this.topPanes.addTab(el.getAttribute("name"), this.calendar.get(cs));
                this.calendar.get(cs).setListener(this);
                this.tabs.add(new BTabs(5, cs));
                continue;
            }
            if (el.getName().equals("FILTERGRID")) {
                this.filterGrids.add(new BGrid(logHandle, db, el, reportDir));
                gs = this.filterGrids.size() - 1;
                this.topPanes.addTab(el.getAttribute("name"), this.filterGrids.get(gs));
                this.filterGrids.get(gs).setListener(this);
                this.tabs.add(new BTabs(7, gs));
                continue;
            }
            if (!el.getName().equals("FILTERFORM")) continue;
            this.filterForms.add(new BForm(logHandle, db, el));
            gs = this.filterForms.size() - 1;
            this.topPanes.addTab(el.getAttribute("name"), this.filterForms.get(gs));
            this.filterForms.get(gs).setListener(this);
            this.tabs.add(new BTabs(8, gs));
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent ev) {
        int i = this.topPanes.getSelectedIndex();
        if (this.tabs.get(i).getType() == 4) {
            i = this.tabs.get(i).getIndex();
            String filterName = this.drilldown.get(i).getFilterName();
            String filterKey = this.drilldown.get(i).getKey();
            if (filterKey != null) {
                for (BReport report : this.reports) {
                    report.putparams(filterName, filterKey);
                    report.drillReport();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        int i = this.topPanes.getSelectedIndex();
        if (ev.getComponent().equals(this.topPanes)) {
            if (this.tabs.get(i = this.tabs.get(i).getIndex()).getType() == 4) {
                this.drilldown.get(i).createtree();
            }
            if (this.tabs.get(i).getType() == 7) {
                this.filterGrids.get(i).showMain();
            }
        } else {
            String filterKey;
            String filterName;
            if (this.tabs.get(i).getType() == 4) {
                i = this.tabs.get(i).getIndex();
                this.drilldown.get(i).createtree();
            }
            if (this.tabs.get(i).getType() == 7) {
                i = this.tabs.get(i).getIndex();
                filterName = this.filterGrids.get(i).getFilterName();
                filterKey = this.filterGrids.get(i).getKey();
                if (filterKey != null) {
                    for (BReport report : this.reports) {
                        report.putparams(filterName, filterKey);
                        report.drillReport();
                    }
                    for (BGrids grid : this.grids) {
                        grid.link(filterKey, this.params, this.progarationParams);
                        grid.hideForms();
                    }
                }
            }
            if (this.tabs.get(i).getType() == 5) {
                i = this.tabs.get(i).getIndex();
                filterName = this.calendar.get(i).getFilterName();
                filterKey = this.calendar.get(i).getKey();
                if (filterKey != null) {
                    for (BReport report : this.reports) {
                        report.putparams(filterName, filterKey);
                        report.drillReport();
                    }
                    for (BGrids grid : this.grids) {
                        grid.link(filterKey, this.params, this.progarationParams);
                        grid.hideForms();
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if ("Filter".equals(aKey)) {
            int i = this.topPanes.getSelectedIndex();
            i = this.tabs.get(i).getIndex();
            System.out.println(i);
            for (BReport report : this.reports) {
                report.putparams(this.filterForms.get(i).getParam());
            }
            for (BGrids grid : this.grids) {
                grid.filter(this.filterForms.get(i).getWhere());
                grid.hideForms();
            }
        } else if ("Print All".equals(aKey)) {
            int i = this.topPanes.getSelectedIndex();
            i = this.tabs.get(i).getIndex();
            String filterName = this.filterGrids.get(i).getFilterName();
            String update = this.filterGrids.get(i).getUpdate();
            Vector<String> keys = this.filterGrids.get(i).getKeys();
            for (String key : keys) {
                boolean printed = true;
                for (BReport report : this.reports) {
                    if (report.printReport(filterName, key)) continue;
                    printed = false;
                }
                if (!printed || update == null) continue;
                String updSql = "SELECT " + update + "('" + this.db.getUserID() + "', '" + this.db.getUserIP();
                updSql = updSql + "', '" + key + "')";
                System.out.println(updSql);
                this.db.executeQuery(updSql);
            }
            this.filterGrids.get(i).showMain();
            this.filterGrids.get(i).refresh();
        }
    }
}

