/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.baraza.DB.BDB;
import org.baraza.app.BGrid;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BGridBox
extends JTextField
implements MouseListener {
    Logger log = Logger.getLogger(BGridBox.class.getName());
    BLogHandle logHandle;
    BGrid grid;
    BDB db;
    boolean showgrid = false;
    String sql;
    String name;
    String lpkey;
    String lptable;
    String lpfield;
    String linkData;
    String datakey = null;

    public BGridBox(BLogHandle logHandle, BDB db, BElement el) {
        this.db = db;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        super.setHorizontalAlignment(10);
        super.setCaretPosition(0);
        super.setEnabled(false);
        super.addMouseListener(this);
        this.lptable = el.getAttribute("lptable", "");
        this.lpfield = el.getAttribute("lpfield", "");
        this.name = el.getValue();
        this.lpkey = el.getAttribute("lpkey") == null ? this.name : el.getAttribute("lpkey");
        this.grid = new BGrid(logHandle, db, el.getFirst(), "");
        this.grid.setListener(this);
        this.grid.setVisible(false);
    }

    public void refresh() {
        this.grid.refresh();
    }

    public void setBounds(int x, int y, int w, int h, int lw, int ph) {
        super.setBounds(x + lw, y, w, h);
        this.grid.setBounds(x, y + h, lw + w, ph);
    }

    public void setLinkData(String lkdata) {
        this.grid.setLinkData(lkdata);
        this.grid.refresh();
        System.out.println(lkdata);
    }

    @Override
    public void setText(String ldata) {
        this.sql = "SELECT (" + this.lpfield + ") as lpfield  FROM " + this.lptable + " WHERE " + this.lpkey + " = ";
        this.sql = ldata == null ? this.sql + ldata : (ldata.trim().length() == 0 ? this.sql + "null" : this.sql + "'" + ldata + "'");
        String rsd = this.db.executeFunction(this.sql);
        this.datakey = ldata;
        super.setText(rsd);
        super.moveCaretPosition(0);
    }

    @Override
    public String getText() {
        return this.datakey;
    }

    public JPanel getGrid() {
        return this.grid;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.showgrid) {
            this.grid.setVisible(true);
            this.grid.refresh();
            this.showgrid = true;
        } else {
            this.grid.setVisible(false);
            this.datakey = this.grid.getKey();
            this.setText(this.datakey);
            this.showgrid = false;
        }
    }
}

