/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.com;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class BLicense {
    KeyPair keyPair = this.generateKey();

    public static void main(String[] args) {
        BLicense lic = new BLicense();
        KeyPair kpl = lic.generateKey();
        byte[] signedData = lic.signData(kpl, "my data");
        boolean signed = lic.verifyData(kpl.getPublic().getEncoded(), signedData, "my data  ");
    }

    public String createLicense(String holder, String productKey, String MachineID, String databaseID) {
        String licData = holder + "\n" + productKey + "\n" + MachineID + "\n" + databaseID;
        byte[] signedData = this.signData(this.keyPair, licData);
        Base64 encd = new Base64();
        String encodData = Base64.encodeBase64URLSafeString((byte[])signedData);
        String encodPK = Base64.encodeBase64URLSafeString((byte[])this.keyPair.getPublic().getEncoded());
        System.out.println("License : " + encodData + "===================" + encodPK);
        return encodData + "===================" + encodPK;
    }

    public boolean verifyLicense(String holder, String productKey, String MachineID, String databaseID, byte[] signedData, byte[] publicKey) {
        String licData = holder + "\n" + productKey + "\n" + MachineID + "\n" + databaseID;
        boolean signed = this.verifyData(publicKey, signedData, licData);
        return signed;
    }

    public byte[] getPublicKey() {
        return this.keyPair.getPublic().getEncoded();
    }

    private KeyPair generateKey() {
        KeyPair pair = null;
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DSA", "SUN");
            keyGen.initialize(1024, random);
            pair = keyGen.generateKeyPair();
            PublicKey pub = pair.getPublic();
            PrivateKey privateKey = pair.getPrivate();
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("Public key generation error : " + ex);
        }
        catch (NoSuchProviderException ex) {
            System.out.println("Public key generation error : " + ex);
        }
        return pair;
    }

    private byte[] signData(KeyPair pair, String data) {
        try {
            Signature dsa = Signature.getInstance("SHA1withDSA", "SUN");
            dsa.initSign(pair.getPrivate());
            dsa.update(data.getBytes("UTF-8"));
            byte[] realSig = dsa.sign();
            return realSig;
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("No algorithim : " + ex.getMessage());
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("Unsupported Encoding : " + ex.getMessage());
        }
        catch (NoSuchProviderException ex) {
            System.out.println("Public key generation error : " + ex);
        }
        catch (SignatureException ex) {
            System.out.println("Public key generation error : " + ex);
        }
        catch (InvalidKeyException ex) {
            System.out.println("Public key generation error : " + ex);
        }
        return null;
    }

    private boolean verifyData(byte[] publicKey, byte[] signedData, String data) {
        boolean signed = false;
        try {
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            Signature sig = Signature.getInstance("SHA1withDSA", "SUN");
            sig.initVerify(pubKey);
            sig.update(data.getBytes("UTF-8"));
            signed = sig.verify(signedData);
            System.out.println("signature verifies: " + signed);
        }
        catch (NoSuchAlgorithmException ex) {
            System.out.println("No algorithim : " + ex.getMessage());
        }
        catch (UnsupportedEncodingException ex) {
            System.out.println("Unsupported Encoding : " + ex.getMessage());
        }
        catch (SignatureException ex) {
            System.out.println("Public key generation error : " + ex);
        }
        catch (NoSuchProviderException ex) {
            System.out.println("Public key generation error : " + ex);
        }
        catch (InvalidKeyException ex) {
            System.out.println("Public key generation error : " + ex);
        }
        catch (InvalidKeySpecException ex) {
            System.out.println("Public key generation error : " + ex);
        }
        return signed;
    }
}

