/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.com;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.DB.BTableModel;
import org.baraza.com.BOBChequeTable;
import org.baraza.reports.BReport;
import org.baraza.utils.BAmountInWords;

public class BOBCheque
extends JApplet
implements Printable,
ActionListener,
ListSelectionListener,
WindowListener {
    List<String> prnline;
    List<Integer> prnx;
    List<Integer> prny;
    BDB db;
    BReport rpt;
    BOBCheque a_prn;
    BOBChequeTable tbdef;
    BTableModel eftTModel;
    JFrame frame;
    JPanel panel;
    JButton bt;
    JButton expBT;
    JButton clearBT;
    JPasswordField pF;
    JTable table;
    JTable eftTable;
    JLabel label;
    JScrollPane asp;
    JSplitPane splitPane;

    public static void main(String[] args) {
        BOBCheque prn = new BOBCheque();
        prn.addFrame();
    }

    @Override
    public void init() {
        this.a_prn = new BOBCheque();
        this.getContentPane().add(this.a_prn.splitPane);
    }

    @Override
    public void destroy() {
        this.a_prn.close();
    }

    public void addFrame() {
        this.a_prn = new BOBCheque();
        this.frame = new JFrame("Cheque Printing");
        this.frame.addWindowListener(this);
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().add(this.a_prn.splitPane);
        this.frame.setLocation(50, 50);
        this.frame.setSize(1100, 500);
        this.frame.setVisible(true);
    }

    public BOBCheque() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception ex) {
            System.out.println("Error Loading the look : " + ex);
        }
        boolean orcl = true;
        String dbclass = "org.postgresql.Driver";
        String dbpath = "jdbc:postgresql://192.168.0.2/finance";
        if (orcl) {
            dbclass = "oracle.jdbc.driver.OracleDriver";
            dbpath = "jdbc:oracle:thin:@172.100.3.22:1524:erp";
            this.db = new BDB(dbclass, dbpath, "erpdbuser", "Imis2goke");
        } else {
            this.db = new BDB(dbclass, dbpath, "tegemeo", "tegeme0");
        }
        this.tbdef = new BOBChequeTable();
        this.makeCheque();
        this.makeEFT();
        this.prnline = new ArrayList<String>();
        this.prnx = new ArrayList<Integer>();
        this.prny = new ArrayList<Integer>();
        this.bt = new JButton("Print Cheques");
        this.bt.addActionListener(this);
        this.expBT = new JButton("Export EFT");
        this.expBT.addActionListener(this);
        this.clearBT = new JButton("Clear EFT");
        this.clearBT.addActionListener(this);
        this.pF = new JPasswordField(10);
        this.label = new JLabel("Enter Security Code :");
        this.table = new JTable(this.tbdef);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoCreateRowSorter(true);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.asp = new JScrollPane(this.table);
        this.asp.setVerticalScrollBarPolicy(22);
        this.eftTable = new JTable(this.eftTModel);
        this.eftTable.setFillsViewportHeight(true);
        this.eftTable.setAutoCreateRowSorter(true);
        this.eftTable.getSelectionModel().addListSelectionListener(this);
        JScrollPane eftSP = new JScrollPane(this.eftTable);
        eftSP.setVerticalScrollBarPolicy(22);
        this.rpt = new BReport(this.db, "http://172.100.3.34:8080/cheques/reports/", "EM_bankpaymentadvise.jasper");
        JPanel btPanel = new JPanel();
        btPanel.add(this.label);
        btPanel.add(this.pF);
        btPanel.add(this.bt);
        JPanel ebtPanel = new JPanel();
        ebtPanel.add(this.expBT);
        ebtPanel.add(this.clearBT);
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)this.asp, "Center");
        this.panel.add((Component)btPanel, "Last");
        JPanel ePanel = new JPanel(new BorderLayout());
        ePanel.add((Component)eftSP, "Center");
        ePanel.add((Component)ebtPanel, "Last");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Cheque Printing", this.panel);
        tabbedPane.addTab("EFT", ePanel);
        this.splitPane = new JSplitPane(1, tabbedPane, this.rpt);
        this.splitPane.setDividerLocation(800);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pf.getImageableX(), pf.getImageableY());
        Font font = new Font("Serif", 0, 10);
        FontMetrics metrics = g.getFontMetrics(font);
        int lineHeight = metrics.getHeight();
        for (int i = 0; i < this.prnline.size(); ++i) {
            g.drawString(this.prnline.get(i), (int)this.prnx.get(i), (int)this.prny.get(i));
        }
        return 0;
    }

    public void addLine(String ln, int x, int y) {
        this.prnline.add(ln);
        this.prnx.add(x);
        this.prny.add(y);
    }

    public void makeCheque() {
        String mysql = "SELECT c_bpartner.name, fin_payment.fin_payment_id, fin_payment.paymentdate, fin_payment.amount, fin_payment.referenceno ";
        mysql = mysql + "FROM (c_bpartner INNER JOIN fin_payment ON c_bpartner.c_bpartner_id = fin_payment.c_bpartner_id) ";
        mysql = mysql + "\tINNER JOIN fin_paymentmethod ON fin_payment.fin_paymentmethod_id = fin_paymentmethod.fin_paymentmethod_id ";
        mysql = mysql + "WHERE (fin_payment.processed = 'Y')  AND (fin_payment.isreceipt = 'N') AND (fin_paymentmethod.name = 'Cheque') AND (fin_payment.em_dc2_is_printed = 'N')";
        BQuery rs = new BQuery(this.db, mysql);
        this.tbdef.clear();
        while (rs.moveNext()) {
            Vector<String> cl = new Vector<String>();
            String ref = rs.getString("referenceno");
            if (ref == null) {
                ref = "";
            }
            Date cdate = rs.getDate("paymentdate");
            String cname = rs.getString("name");
            float camount = rs.getFloat("amount").floatValue();
            int cba = (int)camount;
            SimpleDateFormat dateformatter = new SimpleDateFormat("dd.MMM.yyyy");
            String mydate = dateformatter.format(cdate);
            DecimalFormat dformatter = new DecimalFormat("###,###,###.00");
            String s = dformatter.format(camount);
            String sfs = BAmountInWords.convert(cba);
            int cbc = Integer.valueOf(s.substring(s.length() - 2, 2));
            if (cbc > 5) {
                sfs = sfs + " " + BAmountInWords.convert(cbc) + " cents\n";
            }
            cl.add(ref);
            cl.add(mydate);
            cl.add(cname);
            cl.add(s);
            cl.add(sfs);
            cl.add(rs.getString("fin_payment_id"));
            this.tbdef.cheques.add(cl);
            System.out.println(mydate + ", " + cname + ", :" + camount + ": " + cba + ", " + cbc);
            System.out.println(sfs);
        }
        this.tbdef.refresh();
    }

    public void makeEFT() {
        String mysql = "SELECT c_bpartner.name, fin_payment.paymentdate, fin_payment.amount, fin_payment.referenceno, ";
        mysql = mysql + "c_bp_bankaccount.routingno, c_bp_bankaccount.accountno, c_bp_bankaccount.swiftcode, fin_payment.fin_payment_id ";
        mysql = mysql + "FROM ((c_bpartner INNER JOIN fin_payment ON c_bpartner.c_bpartner_id = fin_payment.c_bpartner_id) ";
        mysql = mysql + "INNER JOIN fin_paymentmethod ON fin_payment.fin_paymentmethod_id = fin_paymentmethod.fin_paymentmethod_id) ";
        mysql = mysql + "INNER JOIN c_bp_bankaccount ON c_bpartner.c_bpartner_id = c_bp_bankaccount.c_bpartner_id ";
        mysql = mysql + "WHERE (fin_payment.processed = 'Y') AND (fin_payment.isreceipt = 'N') AND (fin_paymentmethod.name = 'EFT') AND (fin_payment.em_dc2_is_printed = 'N') ";
        String[] titles = new String[]{"Supplier", "Payment Date", "Amount", "Reference Number", "Bank Code", "Account Number", "Swift Code", "Payment ID"};
        this.eftTModel = new BTableModel(this.db, mysql, -1);
        this.eftTModel.setTitles(titles);
    }

    public void printCheque() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            int[] selection = this.table.getSelectedRows();
            for (int i = 0; i < selection.length; ++i) {
                Vector<String> s = this.tbdef.cheques.get(this.table.convertRowIndexToModel(selection[i]));
                this.prnline.clear();
                this.prnx.clear();
                this.prny.clear();
                String mysql = "SELECT c_bpartner.name, fin_payment.fin_payment_id, fin_payment.paymentdate, fin_payment.amount, fin_payment.referenceno ";
                mysql = mysql + "FROM (c_bpartner INNER JOIN fin_payment ON c_bpartner.c_bpartner_id = fin_payment.c_bpartner_id) ";
                mysql = mysql + "\tINNER JOIN fin_paymentmethod ON fin_payment.fin_paymentmethod_id = fin_paymentmethod.fin_paymentmethod_id ";
                mysql = mysql + "WHERE fin_payment.fin_payment_id = '" + s.get(5) + "'";
                BQuery rs = new BQuery(this.db, mysql);
                try {
                    if (!rs.moveNext()) continue;
                    this.addLine(s.get(1), 420, 75);
                    this.addLine(s.get(2), 80, 195);
                    this.addLine(s.get(3), 420, 180);
                    String aiw = s.get(4);
                    int lenAiw = aiw.length();
                    if (lenAiw < 32) {
                        this.addLine(s.get(4), 130, 220);
                    } else {
                        int lenPost = aiw.indexOf(" ", 30);
                        this.addLine(aiw.substring(0, lenPost), 130, 220);
                        this.addLine(aiw.substring(lenPost, lenAiw - 1), 80, 245);
                    }
                    printJob.print();
                    this.rpt.printReport("filterid", s.get(5));
                    mysql = "UPDATE fin_payment SET em_dc2_is_printed = 'Y' ";
                    mysql = mysql + "WHERE fin_payment_id = '" + rs.getString("fin_payment_id") + "'";
                    this.db.executeQuery(mysql);
                    continue;
                }
                catch (PrinterException pe) {
                    System.out.println("Error printing: " + pe);
                }
            }
        }
        this.makeCheque();
    }

    public void exportData() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            String filename = fc.getSelectedFile().getAbsolutePath() + ".csv";
            this.eftTModel.savecvs(filename);
        }
    }

    public void clearEFT() {
        String mysql = "UPDATE (SELECT fin_payment.em_dc2_is_printed ";
        mysql = mysql + "FROM fin_payment INNER JOIN fin_paymentmethod ON fin_payment.fin_paymentmethod_id = fin_paymentmethod.fin_paymentmethod_id ";
        mysql = mysql + "WHERE (fin_payment.processed = 'Y') AND (fin_paymentmethod.name = 'EFT') AND (fin_payment.em_dc2_is_printed = 'N')) t ";
        mysql = mysql + "SET t.em_dc2_is_printed = 'Y'";
        this.db.executeQuery(mysql);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if ("Print Cheques".equals(aKey)) {
            String password = new String(this.pF.getPassword());
            if (password.equals("bankpassword")) {
                this.printCheque();
            } else {
                this.label.setText("Wrong bank code");
            }
        } else if ("Export EFT".equals(aKey)) {
            this.exportData();
        } else if ("Clear EFT".equals(aKey)) {
            this.clearEFT();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        int selectionindex = this.table.getSelectionModel().getLeadSelectionIndex();
        if (selectionindex >= 0 && selectionindex < this.tbdef.cheques.size()) {
            Vector<String> s = this.tbdef.cheques.get(selectionindex);
            this.rpt.putparams("filterid", s.get(4));
            this.rpt.showReport();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.a_prn.close();
    }

    public void close() {
        this.db.close();
    }
}

