/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.reports.BReportFile;
import org.baraza.server.data.BData;
import org.baraza.server.deploy.BDeploy;
import org.baraza.server.escalation.BEscalation;
import org.baraza.server.export.BExport;
import org.baraza.server.sms.BKannel;
import org.baraza.server.sms.BSMS;
import org.baraza.server.sms.BSoapSMS;
import org.baraza.server.sqlcron.BSQLCron;
import org.baraza.server.tomcat.BTomcat;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;
import org.baraza.xml.BXML;

public class BServerTimed
extends Thread {
    Logger log = Logger.getLogger(BServerTimed.class.getName());
    boolean listening = true;
    String type = null;
    int delay = 2000;
    BLogHandle logHandle;
    BDB db = null;
    BElement root = null;
    BEscalation escalation = null;
    BData data = null;
    BReportFile reportFile = null;
    BExport export = null;
    BDeploy deploy = null;
    BSMS sms = null;
    BKannel kannel = null;
    BSoapSMS soapSMS = null;
    BTomcat tomcat = null;
    BSQLCron sqlcron = null;

    public BServerTimed(String configDir, BElement el, BLogHandle logHandle) {
        this.logHandle = logHandle;
        logHandle.config(this.log);
        String ps = System.getProperty("file.separator");
        String xmlfile = configDir + el.getAttribute("path") + ps + "configs" + ps + el.getAttribute("xmlfile");
        this.db = new BDB(el);
        this.db.logConfig(logHandle);
        BXML xml = new BXML(xmlfile, false);
        this.root = xml.getRoot();
        this.type = this.root.getName();
        if (el.getAttribute("noaudit") == null) {
            String ipaddress = "";
            try {
                InetAddress i = InetAddress.getLocalHost();
                ipaddress = i.toString();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            this.db.setUser(ipaddress, el.getAttribute("dbusername"), this.type);
        }
        if (this.type.equals("ESCALATION")) {
            this.escalation = new BEscalation(this.db, this.root, logHandle);
        }
        if (this.type.equals("DATA")) {
            this.data = new BData(this.db, this.root, logHandle);
        }
        if (this.type.equals("EXPORT")) {
            this.export = new BExport(this.db, this.root, logHandle);
        }
        if (this.type.equals("DEPLOY")) {
            this.deploy = new BDeploy(this.db, this.root, logHandle);
        }
        if (this.type.equals("REPORTS")) {
            this.reportFile = new BReportFile(this.db, this.root, logHandle);
        }
        if (this.type.equals("SMS")) {
            this.sms = new BSMS(this.db, this.root, logHandle);
        }
        if (this.type.equals("KANNEL")) {
            this.kannel = new BKannel(this.db, this.root, logHandle);
        }
        if (this.type.equals("SOAPSMS")) {
            this.soapSMS = new BSoapSMS(this.db, this.root, logHandle);
        }
        if (this.type.equals("TOMCAT")) {
            this.tomcat = new BTomcat(this.db, this.root, logHandle, configDir + el.getAttribute("path"));
            this.tomcat.start();
        }
        if (this.type.equals("SQLCRON")) {
            this.sqlcron = new BSQLCron(this.db, this.root, logHandle);
        }
    }

    public String getType() {
        return this.type;
    }

    public void sendMessage(String inputLine) {
        if (this.sms != null) {
            this.sms.sendMessage(inputLine);
        }
    }

    public String sendMessage(String number, String message, String accesscode) {
        String st = null;
        if (this.sms != null) {
            st = this.sms.sendMessage(number, message, accesscode);
        }
        return st;
    }

    @Override
    public void run() {
        while (this.listening) {
            if (this.escalation != null && !this.escalation.isExecuting()) {
                this.delay = this.escalation.process();
            }
            if (this.data != null && !this.data.isExecuting()) {
                this.delay = this.data.process();
            }
            if (this.kannel != null && !this.kannel.isExecuting()) {
                this.delay = this.kannel.process();
            }
            if (this.soapSMS != null) {
                this.delay = this.soapSMS.process();
            }
            if (this.export != null) {
                this.delay = this.export.process();
            }
            if (this.deploy != null) {
                this.delay = this.deploy.process();
            }
            if (this.reportFile != null) {
                this.delay = this.reportFile.process();
            }
            if (this.sqlcron != null) {
                this.delay = this.sqlcron.process();
            }
            if (this.sms != null && !this.sms.isRunning()) {
                this.delay = this.sms.getDelay();
                if (!this.sms.isConnected()) {
                    this.log.info("SMS System attempting a restart");
                    this.sms = new BSMS(this.db, this.root, this.logHandle);
                }
            }
            try {
                BServerTimed.sleep(this.delay);
            }
            catch (InterruptedException ex) {
                this.log.info(this.type + " Servers Stopped");
            }
        }
    }

    public void close() {
        this.listening = false;
        if (this.escalation != null) {
            this.escalation.close();
        }
        if (this.data != null) {
            this.data.close();
        }
        if (this.export != null) {
            this.export.close();
        }
        if (this.deploy != null) {
            this.deploy.close();
        }
        if (this.reportFile != null) {
            this.reportFile.close();
        }
        if (this.sms != null) {
            this.sms.close();
        }
        if (this.kannel != null) {
            this.kannel.close();
        }
        if (this.soapSMS != null) {
            this.soapSMS.close();
        }
        if (this.tomcat != null) {
            this.tomcat.close();
        }
        if (this.sqlcron != null) {
            this.sqlcron.close();
        }
        if (this.db != null) {
            this.db.close();
        }
        this.interrupt();
    }
}

