/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.export;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.server.ssh.Bssh;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BExport {
    Logger log = Logger.getLogger(BExport.class.getName());
    BElement root;
    BDB db;
    int delay;
    String delimeter;

    public BExport(BDB db, BElement root, BLogHandle logHandle) {
        this.root = root;
        this.db = db;
        logHandle.config(this.log);
    }

    public int process() {
        this.delimeter = this.root.getAttribute("delimeter", "\t");
        String shost = this.root.getAttribute("shost");
        String sftp = this.root.getAttribute("sftp");
        String suser = this.root.getAttribute("suser");
        String spasswd = this.root.getAttribute("spasswd");
        for (BElement el : this.root.getElements()) {
            String lfile = this.tableExport(el);
            if (sftp == null || lfile == null) continue;
            Bssh bssh = new Bssh(shost, sftp, suser, spasswd, lfile);
        }
        this.delay = Integer.valueOf(this.root.getAttribute("delay", "30")) * 60 * 1000;
        this.log.info(new Date() + " Export : Done");
        return this.delay;
    }

    public String tableExport(BElement el) {
        String mysql = "";
        String mydata = "";
        String myfile = null;
        for (BElement ell : el.getElements()) {
            if (ell.getName().equals("TEXTFIELD")) {
                if (!mysql.equals("")) {
                    mysql = mysql + ", ";
                }
                if (ell.getAttribute("basetable") != null) {
                    mysql = mysql + ell.getAttribute("basetable") + ".";
                }
                mysql = mysql + ell.getValue();
                continue;
            }
            if (!ell.getName().equals("TEXTFUNC")) continue;
            if (!mysql.equals("")) {
                mysql = mysql + ", ";
            }
            mysql = mysql + ell.getAttribute("function") + " as " + ell.getValue();
        }
        mysql = "SELECT " + mysql + " FROM " + el.getAttribute("table");
        if (el.getAttribute("wheresql") != null) {
            mysql = mysql + " WHERE " + el.getAttribute("wheresql");
        }
        if (el.getAttribute("ordersql") != null) {
            mysql = mysql + " ORDER BY " + el.getAttribute("ordersql");
        }
        this.log.fine(mysql);
        BQuery rs = new BQuery(this.db, mysql);
        int linecount = 1;
        while (rs.moveNext()) {
            String myln = "";
            for (BElement ell : el.getElements()) {
                String tag;
                if (!myln.equals("")) {
                    myln = myln + this.delimeter;
                }
                tag = (tag = ell.getAttribute("tag")) != null ? "\"" : "";
                if (ell.getName().equals("TEXTFIELD") || ell.getName().equals("TEXTFUNC") || ell.getName().equals("SELECTED")) {
                    if (rs.getString(ell.getValue()) == null) {
                        myln = myln + tag + tag;
                        continue;
                    }
                    myln = myln + tag + rs.getString(ell.getValue()) + tag;
                    continue;
                }
                if (ell.getName().equals("TEXTDATA")) {
                    String repeat = ell.getAttribute("repeat");
                    int rcount = 1;
                    if (repeat != null) {
                        rcount = Integer.valueOf(repeat);
                    }
                    for (int i = 0; i < rcount; ++i) {
                        if (i != 0) {
                            myln = myln + this.delimeter;
                        }
                        myln = myln + ell.getValue("");
                    }
                    continue;
                }
                if (ell.getName().equals("NEWLINE")) {
                    mydata = mydata + myln + "\n";
                    myln = "";
                    continue;
                }
                if (!ell.getName().equals("LINECOUNT")) continue;
                myln = myln + Integer.toString(linecount);
            }
            ++linecount;
            mydata = mydata + myln + "\n";
        }
        rs.close();
        if (!mydata.equals("")) {
            try {
                Date cdate = new Date();
                SimpleDateFormat dateformatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-");
                myfile = dateformatter.format(cdate) + el.getAttribute("exportpath");
                BufferedWriter output = new BufferedWriter(new FileWriter(myfile));
                String headerlines = el.getAttribute("pageheader");
                if (headerlines != null) {
                    File hlf = new File(headerlines);
                    BufferedReader input = new BufferedReader(new FileReader(hlf));
                    int len = (int)hlf.length();
                    char[] cbuf = new char[len];
                    input.read(cbuf, 0, len);
                    ((Writer)output).write(cbuf, 0, len);
                    input.close();
                }
                output.write(mydata);
                ((Writer)output).close();
            }
            catch (IOException ex) {
                this.log.severe("IO Error : " + ex);
            }
            String updfunct = el.getAttribute("updfunct");
            if (updfunct != null) {
                updfunct = "SELECT " + updfunct;
                this.db.executeQuery(updfunct);
            }
        }
        return myfile;
    }

    public int getDelay() {
        return this.delay;
    }

    public void close() {
        this.db.close();
    }
}

