/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.sms;

import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.server.sms.BSMSEng;
import org.baraza.server.sms.BSMSMessage;
import org.baraza.server.sms.BSMSend;
import org.baraza.utils.BLogHandle;

public class BSMSCommands {
    Logger log = Logger.getLogger(BSMSCommands.class.getName());
    BSMSEng smseng;
    BSMSend smsend;
    BSMSMessage smsmsg;
    BDB db;
    private final int OK = 1;
    private String typeStore = "SM";
    private int messages = 0;
    private int messageMAX = 0;

    public BSMSCommands(BSMSEng smseng, BSMSend smsend, BDB db, BLogHandle logHandle) {
        this.smseng = smseng;
        this.smsend = smsend;
        this.db = db;
        this.smsmsg = new BSMSMessage(logHandle);
        logHandle.config(this.log);
    }

    public boolean initPhone(String smsStore, String smsNMI) {
        this.smsend.sendMessage("AT\r");
        this.smseng.getMessage();
        this.log.info("SMS System started");
        this.smsend.sendMessage("AT+CGMI\r");
        this.log.info("Manufacturer : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CGMM\r");
        this.log.info("Model : " + this.smseng.getMessage());
        if (smsStore != null) {
            this.typeStore = smsStore;
        }
        this.smsend.sendMessage("AT+CPMS=\"" + this.typeStore + "\"\r");
        this.smseng.getMessage();
        this.smsend.sendMessage("AT+CNMI=?\r");
        String nmi = this.smseng.getMessage();
        this.log.info("NMI? : " + nmi);
        nmi = nmi.replace(")", ":").replace("(", "");
        String[] nmis = nmi.split(":");
        nmi = "";
        int i = 0;
        for (String nis : nmis) {
            if (i == 1) {
                nmi = nmi + nis.trim().substring(nis.trim().length() - 1);
            } else if (i > 1 && i < 6) {
                nmi = nmi + "," + nis.trim().substring(nis.trim().length() - 1);
            }
            ++i;
        }
        if (smsNMI != null) {
            nmi = smsNMI;
        }
        this.log.info("NMI : " + nmi);
        this.smsend.sendMessage("AT+CNMI=" + nmi + "\r");
        this.smseng.getMessage();
        this.smsend.sendMessage("AT+CMGF=0\r");
        this.smseng.getMessage();
        boolean phoneReady = false;
        if (this.smseng.getPortStatus() == 1) {
            phoneReady = true;
        }
        return phoneReady;
    }

    public boolean readSMS(int msgCount, int msgMAX) {
        String[] msgnos;
        boolean isreadsms = true;
        this.smsend.sendMessage("AT\r");
        this.smseng.getMessage();
        this.smseng.bufferReset();
        this.smsend.sendMessage("AT+CMGL=4\r");
        String msgList = this.smseng.getMessage();
        this.log.info("THE MSG LIST " + msgList);
        if (msgList.trim().length() == 0) {
            this.log.info("Message Read error.");
            isreadsms = false;
        }
        for (String msgno : msgnos = msgList.split("\n")) {
            if ((msgno = msgno.replace("+CMGL: ", "")).trim().length() <= 4) continue;
            msgno = msgno.substring(0, msgno.indexOf(",")).trim();
            this.log.info("Read message : " + msgno);
            this.readSMS(Integer.valueOf(msgno));
        }
        return isreadsms;
    }

    public void readSMS(int i) {
        this.smseng.bufferReset();
        this.smseng.setMessageNum(i);
        this.smsend.sendMessage("AT\r");
        this.smseng.getMessage();
        this.smsend.sendMessage("AT+CMGR=" + String.valueOf(i) + "\r");
        String msg = this.smseng.getSMSMessage();
        if (this.smseng.checkMessage() && this.smseng.getPortStatus() == 1) {
            this.smsmsg.readsms(this.db, i, msg);
        }
    }

    public void CheckStorage() {
        this.smsend.sendMessage("AT\r");
        this.smseng.getMessage();
        this.smsend.sendMessage("AT+CPMS=?\r");
        this.smseng.getMessage();
        this.smsend.sendMessage("AT+CPMS=\"" + this.typeStore + "\"\r");
        String mynum = this.smseng.getMessage();
        this.log.fine("MESSAGE : " + mynum);
        mynum = mynum.replaceAll("CPMS: ", ",");
        String[] val = mynum.split(",");
        if (val.length > 2) {
            try {
                this.messages = Integer.valueOf(val[1]);
                this.messageMAX = Integer.valueOf(val[2]);
            }
            catch (NumberFormatException ex) {
                this.log.severe("ERROR NumberFormatException : " + ex);
            }
            this.log.info("Messages in SIM : " + this.messages + ", Last Store Location : " + this.messageMAX);
        }
        this.smsend.sendMessage("AT+CMGF=0\r");
        this.smseng.getMessage();
    }

    public void delSMS(BDB db) {
        String mysql = "SELECT sms_id, sms_trans_id, sms_deleted FROM sms_trans ";
        mysql = mysql + "WHERE (sms_deleted = false)";
        this.log.fine(mysql);
        BQuery rs = new BQuery(db, mysql);
        while (rs.moveNext()) {
            this.smsend.sendMessage("AT\r");
            this.smsend.sendMessage("AT+CMGD=" + rs.getString("sms_id") + "\r");
            this.smseng.getMessage();
            rs.recEdit();
            rs.updateField("sms_deleted", "true");
            rs.recSave();
        }
        rs.close();
    }

    public int getMessagesList() {
        return this.messages;
    }

    public int getMessageMAX() {
        return this.messageMAX;
    }

    public void phoneCheck() {
        this.smsend.sendMessage("AT\r");
        this.log.info("AT : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CGMI\r");
        this.log.info("device manufacturer : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CGMM\r");
        this.log.info("model number : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CGSN\r");
        this.log.info("IMEI number : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CGMR\r");
        this.log.info("software version : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CPAS\r");
        this.log.info("phone activity status : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CREG\r");
        this.log.info("network registration status : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CSQ\r");
        this.log.info("radio signal strength : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CBC\r");
        this.log.info("battery charge level : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CSMS?\r");
        this.log.info("mobile-originated SMS messages : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CMGS=?\r");
        this.log.info("check whether Send Message : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CMSS=?\r");
        this.log.info("check whether Send Message from Storage : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CMGW=?\r");
        this.log.info("Write Message to Memory : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CMGD=?\r");
        this.log.info("Delete memory CMGD : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CMSS=?\r");
        this.log.info("Delete memory CMSS : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CSMS=?\r");
        this.log.info("mobile-terminated SMS messages : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CNMI?\r");
        this.log.info("New Message Indications : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CMGR=?\r");
        this.log.info("Read Message : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CMGF=?\r");
        this.log.info("Operational mode : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CPMS=?\r");
        this.log.info("available storage : " + this.smseng.getMessage());
        this.smsend.sendMessage("AT+CMGL=?\r");
        this.log.info("sms list : " + this.smseng.getMessage());
    }
}

