/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.sms;

import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import java.util.logging.Logger;
import org.baraza.utils.BLogHandle;

public class BSMSEng
extends Thread
implements SerialPortEventListener {
    Logger log = Logger.getLogger(BSMSEng.class.getName());
    InputStream inputStream = null;
    boolean DATA_BUFFER = false;
    int messageNum = 0;
    private byte[] readBuffer = new byte[65536];
    private int bufferOffset = 0;
    public final int OK = 1;
    public final int WAIT = 2;
    public final int ERROR = 3;
    public final int WMSG = 4;
    public final int RMSG = 5;
    public final int MSGL = 6;
    public final int PHOB = 7;
    public final int ECHO = 8;
    public final int TIMEOUT = 9;
    public final int CONNERR = 10;
    private boolean hasMessage = false;
    private int portStatus = 1;
    private String portStatusMsg = "";
    private String message = "";
    private String smspdu = "";
    BLogHandle logHandle;

    public BSMSEng(SerialPort port, BLogHandle logHandle) {
        this.logHandle = logHandle;
        logHandle.config(this.log);
        try {
            this.inputStream = port.getInputStream();
            port.addEventListener((SerialPortEventListener)this);
            port.notifyOnDataAvailable(true);
            port.notifyOnBreakInterrupt(true);
        }
        catch (TooManyListenersException ex) {
            this.log.severe("Too many listners : " + ex);
        }
        catch (IOException ex) {
            this.log.severe("Can't open input stream: write-only : " + ex);
        }
    }

    @Override
    public void run() {
        this.gotosleep(100);
    }

    public void gotosleep(int i) {
        try {
            BSMSEng.sleep(i);
        }
        catch (InterruptedException e) {
            this.log.severe("Sending sleep error");
        }
    }

    public void serialEvent(SerialPortEvent event) {
        if (this.portStatus == 10) {
            return;
        }
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.DATA_BUFFER = false;
                break;
            }
            case 10: {
                System.out.println("DEBUG: BREAK RECEIVED");
                this.DATA_BUFFER = false;
                break;
            }
            case 1: {
                this.DATA_BUFFER = true;
                int n = 0;
                try {
                    this.log.fine("DEBUG: Data Available : " + this.inputStream.available());
                    while ((n = this.inputStream.available()) > 0) {
                        n = this.inputStream.read(this.readBuffer, this.bufferOffset, n);
                        this.bufferOffset += n;
                    }
                    if (this.bufferOffset > 0) {
                        if (this.readBuffer[this.bufferOffset - 1] == 10) {
                            String sbuf = new String(this.readBuffer, 0, this.bufferOffset, "ISO-8859-1");
                            sbuf = sbuf.replace("\r", "");
                            this.lineReceived(sbuf);
                            this.bufferOffset = 0;
                        } else {
                            String sbuf = new String(this.readBuffer, 0, this.bufferOffset, "ISO-8859-1");
                            this.log.finer("DATA BUFF : " + sbuf);
                        }
                    }
                }
                catch (IOException ex) {
                    this.log.severe("IO Exception of data read : " + ex);
                    this.portStatus = 10;
                    this.interrupt();
                }
                this.gotosleep(50);
                break;
            }
        }
    }

    private void lineReceived(String buffer) {
        String response = "";
        String msg = null;
        StringTokenizer st = new StringTokenizer(buffer, "\n\n");
        while (st.hasMoreTokens()) {
            response = st.nextToken().trim();
            this.log.fine("RESP : " + response);
            if (response.startsWith("OK")) {
                if (this.portStatus == 5) {
                    this.log.fine("SMS Message " + msg);
                    this.smspdu = msg;
                    this.hasMessage = true;
                }
                this.portStatus = 1;
                continue;
            }
            if (response.startsWith(">")) {
                this.portStatus = 4;
                this.portStatusMsg = response;
                continue;
            }
            if (response.startsWith("ERROR")) {
                this.portStatus = 3;
                this.portStatusMsg = response;
                continue;
            }
            if (response.startsWith("+CME") || response.startsWith("+CMS")) {
                this.portStatus = 3;
                this.portStatusMsg = response;
                continue;
            }
            if (response.startsWith("07") || response.startsWith("00")) {
                if (this.portStatus != 5) continue;
                msg = response;
                continue;
            }
            if (response.startsWith("AT+CPMS")) continue;
            if (response.startsWith("+CPMS")) {
                this.portStatus = 6;
                this.portStatusMsg = response;
                this.message = this.message + response;
                continue;
            }
            if (response.startsWith("AT+CGMI") || response.startsWith("AT+CGMM") || response.startsWith("AT+CNMI") || response.startsWith("AT+CMGL")) continue;
            if (response.startsWith("+CMGL")) {
                this.message = this.message + "\n" + response;
                continue;
            }
            if (response.startsWith("+CMTI")) {
                this.log.info("Message received : " + response);
                this.portStatusMsg = response;
                this.portStatus = 1;
                continue;
            }
            if (response.startsWith("+CMGR")) {
                this.portStatus = 5;
                msg = "";
                this.portStatusMsg = response;
                continue;
            }
            if (response.startsWith("+CMGS")) {
                this.log.info("MESSAGE SENT");
                continue;
            }
            if (response.startsWith("+CPBR")) {
                this.portStatus = 7;
                this.portStatusMsg = response;
                continue;
            }
            if (response.startsWith("+CPBS")) {
                this.portStatus = 7;
                this.portStatusMsg = response;
                continue;
            }
            if (response.startsWith("+CPBF")) {
                this.portStatus = 7;
                this.portStatusMsg = response;
                continue;
            }
            if (response.startsWith("ATE0")) {
                this.portStatus = 8;
                this.portStatusMsg = response;
                continue;
            }
            if (this.portStatus == 5) {
                msg = msg + "\n" + response;
            }
            this.message = this.message + response;
        }
    }

    public void setMessageNum(int i) {
        this.messageNum = i;
    }

    public boolean checkMessage() {
        boolean hm = this.hasMessage;
        this.hasMessage = false;
        return hm;
    }

    public int getPortStatus() {
        return this.portStatus;
    }

    public void bufferReset() {
        this.bufferOffset = 0;
        this.portStatus = 2;
        this.portStatusMsg = "";
        this.message = "";
    }

    public String getMessage() {
        int i = 0;
        while (this.portStatus != 1) {
            this.gotosleep(250);
            if (++i > 50) {
                this.portStatus = 3;
                break;
            }
            if (this.portStatus != 3) continue;
        }
        if (this.portStatus == 3) {
            this.log.severe("SMS ERROR : " + this.portStatusMsg);
        }
        String nmsg = this.message;
        this.message = "";
        return nmsg;
    }

    public String getSMSMessage() {
        this.getMessage();
        return this.smspdu;
    }

    public void close() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException ex) {
            this.log.severe("IO Exception on stream close : " + ex);
        }
        this.interrupt();
    }
}

