/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.sms;

import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.server.sms.BPDUCode;
import org.baraza.utils.BAmountInWords;
import org.baraza.utils.BLogHandle;

public class BSMSMessage {
    Logger log = Logger.getLogger(BSMSMessage.class.getName());
    String senderAddress = "";
    Date smstime = null;
    String message = "";
    String msgNumber = "";
    String code;
    String amount;
    String clientid;
    int messageNum;
    BPDUCode pducode;

    public BSMSMessage(BLogHandle logHandle) {
        logHandle.config(this.log);
        this.pducode = new BPDUCode();
    }

    public void readsms(BDB db, int msgNum, String smspdu) {
        int subMsgLen;
        int senderAddressLength;
        int smsDeliverCode;
        String tmpstr;
        String sms_format = "";
        String smscAddress = "";
        this.messageNum = msgNum;
        String msg = "";
        this.clientid = null;
        this.amount = null;
        this.log.finer("BASE 100 : " + smspdu);
        int pdulen = smspdu.length();
        smspdu.toUpperCase();
        int i = 0;
        boolean hasSmscInfo = false;
        String octet1str = smspdu.substring(i, 2);
        int octet1 = Integer.parseInt(octet1str, 16);
        String octet2str = smspdu.substring(i += 2, i + 2);
        int octet2 = Integer.parseInt(octet2str, 16);
        i += 2;
        this.log.finer("BASE 200");
        if (octet1 > 0) {
            int smscAddressLength = octet1;
            int smscAddressType = octet2;
            int smsAddrLastIndex = i + smscAddressLength * 2 - 2;
            tmpstr = smspdu.substring(i, smsAddrLastIndex);
            smscAddress = this.pducode.swapDigits(tmpstr);
            if (smscAddress.indexOf(70) != -1) {
                smscAddress = smscAddress.substring(0, smscAddress.length() - 1);
            }
            if ((smscAddressType & 0xF0) == 144) {
                smscAddress = '+' + smscAddress;
            }
            i = i + smscAddressLength * 2 - 2;
            String smsDeliverStr = smspdu.substring(i, i + 2);
            smsDeliverCode = Integer.parseInt(smsDeliverStr, 16);
            i += 2;
            if (smsDeliverCode % 2 == 0) {
                sms_format = "incoming";
            } else {
                sms_format = "outgoing";
                i += 2;
            }
            String addressLenStr = smspdu.substring(i, i + 2);
            senderAddressLength = Integer.parseInt(addressLenStr, 16);
            i += 2;
        } else {
            smsDeliverCode = octet2;
            if (smsDeliverCode % 2 == 0) {
                sms_format = "incoming";
            } else {
                sms_format = "outgoing";
                i += 2;
            }
            String addressLenStr = smspdu.substring(i, i + 2);
            senderAddressLength = Integer.parseInt(addressLenStr, 16);
            i += 2;
        }
        String addressTypeStr = smspdu.substring(i, i + 2);
        int senderAddressType = Integer.parseInt(addressTypeStr, 16);
        int senderLastIndex = (i += 2) + senderAddressLength + senderAddressLength % 2;
        tmpstr = smspdu.substring(i, senderLastIndex);
        this.senderAddress = this.pducode.swapDigits(tmpstr);
        this.senderAddress = this.senderAddress.substring(0, senderAddressLength);
        if ((senderAddressType & 0xF0) == 144) {
            this.senderAddress = '+' + this.senderAddress;
        }
        i = i + senderAddressLength + senderAddressLength % 2;
        String protocolStr = smspdu.substring(i, i + 2);
        int tpPid = Integer.parseInt(protocolStr, 16);
        String dataEncStr = smspdu.substring(i += 2, i + 2);
        int tpDcs = Integer.parseInt(dataEncStr, 16);
        i += 2;
        if (sms_format.equals("incoming")) {
            String tpScts = smspdu.substring(i, i + 14);
            this.smstime = this.pducode.TimeStampDecode(tpScts);
            i += 14;
        }
        if (sms_format.equals("outgoing")) {
            if ((smsDeliverCode - 4) % 2 == 1) {
                i += 14;
            } else if ((smsDeliverCode - 8) % 2 == 1) {
                i += 2;
            }
        }
        String msgLenStr = smspdu.substring(i, i + 2);
        int tpUdl = Integer.parseInt(msgLenStr, 16);
        i += 2;
        int[] tpa = new int[7];
        for (int j = 0; j < 6; ++j) {
            tpa[j] = -1;
            if (pdulen - i <= 2 + j * 2) continue;
            tpa[j] = Integer.parseInt(smspdu.substring(i + j * 2, i + j * 2 + 2), 16);
        }
        int encMsgLen = tpUdl;
        if ((tpDcs & 4) == 0) {
            encMsgLen = tpUdl * 7 / 8;
            if (tpUdl * 7 % 8 != 0) {
                ++encMsgLen;
            }
        }
        if ((subMsgLen = i + encMsgLen * 2) > smspdu.length()) {
            subMsgLen = smspdu.length();
        }
        String tpUd = smspdu.substring(i, subMsgLen);
        msg = (tpDcs & 4) == 0 ? this.pducode.sevenBitDecode(tpUd, tpUdl) : this.pducode.eightBitDecode(tpUd);
        this.message = msg;
        if (tpa[1] == 0) {
            this.message = msg.substring(7, msg.length());
        }
        if (this.message.length() > 32) {
            int pos = 0;
            int epos = this.message.indexOf(" ");
            if (epos > 4 && epos < 16 && this.message.length() > epos) {
                this.code = this.message.substring(pos, epos).trim();
            }
            epos = (pos = this.message.toLowerCase().indexOf("ksh")) > 0 && pos + 4 < this.message.length() ? this.message.indexOf(" ", pos + 4) : this.message.length() - 1;
            if (pos > 0 && epos < 0) {
                epos = this.message.length() - 1;
            }
            if (pos > 4 && this.message.length() > epos) {
                this.amount = this.message.substring(pos, epos).trim();
            }
            pos = this.message.toLowerCase().indexOf("account number");
            epos = this.message.indexOf(" ", pos + 16);
            if (pos > 14 && this.message.length() > epos) {
                this.clientid = this.message.substring(pos + 14, epos).trim().toUpperCase();
            }
            pos = this.message.indexOf("2547");
            epos = pos + 12;
            if (pos > 14 && this.message.length() > epos) {
                this.msgNumber = "+" + this.message.substring(pos, epos).trim();
            }
        }
        if (this.amount != null) {
            this.amount = this.amount.toLowerCase().trim();
            this.amount = this.amount.startsWith("ksh") ? this.amount.replaceAll("ksh", "").replaceAll(",", "") : null;
            if (this.amount.endsWith(".")) {
                this.amount = this.amount.substring(0, this.amount.length() - 1);
            }
            this.amount = this.amount.trim();
            if ("".equals(this.amount)) {
                this.amount = null;
            }
        }
        try {
            String msgstr;
            byte[] utf8Bytes = this.message.getBytes("UTF8");
            this.message = msgstr = new String(utf8Bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            this.log.severe("UTF Encode error : " + ex);
        }
        this.message = this.message.replace('\u0000', '@');
        this.log.info("SMS Message : " + this.senderAddress + " : " + this.message);
        if (db != null) {
            this.addSMS(db, tpa[1], tpa[3], tpa[4], tpa[5]);
        }
    }

    public void addSMS(BDB db, int tpb, int tpd, int tpe, int tpf) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String stime = sdf.format(this.smstime);
        String mysql = "SELECT sms_trans_id, origin, sms_time, code, client_id, amount, sms_id, message, ";
        mysql = mysql + "in_words, sms_deleted, msg_number, part_id, part_no, part_message, part_count ";
        mysql = mysql + "FROM sms_trans ";
        mysql = mysql + "WHERE (origin = '" + this.senderAddress + "') AND (sms_time = '" + stime + "')";
        this.log.fine(mysql);
        BQuery rs = new BQuery(db, mysql);
        rs.setTableName("sms_trans");
        if (rs.moveNext()) {
            System.out.println("Data in the database.");
            rs.recEdit();
            rs.updateField("sms_id", Integer.toString(this.messageNum));
            rs.updateField("sms_deleted", "false");
            rs.recSave();
        } else {
            rs.recAdd();
            rs.updateField("origin", this.senderAddress);
            rs.updateField("sms_time", stime);
            rs.updateField("sms_id", Integer.toString(this.messageNum));
            rs.updateField("msg_number", this.msgNumber);
            if (this.code != null) {
                rs.updateField("code", this.code);
            }
            if (this.clientid != null) {
                rs.updateField("client_id", this.clientid);
            }
            if (this.amount != null) {
                try {
                    DecimalFormat df = new DecimalFormat();
                    Number d = df.parse(this.amount);
                    rs.updateField("amount", d.toString());
                    rs.updateField("in_words", BAmountInWords.convert(d.intValue()));
                }
                catch (NumberFormatException ex) {
                    this.log.severe("Number error : " + ex);
                }
                catch (ParseException ex) {
                    this.log.severe("Amount Conversion error : " + ex);
                }
            }
            if (this.message != null) {
                rs.updateField("message", this.message);
                if (tpb == 0) {
                    rs.updateField("part_message", this.message);
                }
            }
            if (tpb == 0) {
                rs.updateField("part_id", Integer.toString(tpd));
                rs.updateField("part_no", Integer.toString(tpf));
                rs.updateField("part_count", Integer.toString(tpe));
            } else {
                rs.updateField("part_no", "1");
                rs.updateField("part_count", "1");
            }
            rs.recSave();
        }
        rs.close();
    }

    public String getSenderAddress() {
        return this.senderAddress;
    }

    public Date getSMSTime() {
        return this.smstime;
    }

    public String getMessage() {
        return this.message;
    }
}

