/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.tomcat;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.AprLifecycleListener;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.Tomcat;
import org.baraza.DB.BDB;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BTomcat
extends Thread {
    Logger log = Logger.getLogger(BTomcat.class.getName());
    Tomcat tomcat = null;

    public BTomcat(BDB db, BElement root, BLogHandle logHandle, String projectDir) {
        String ps = System.getProperty("file.separator");
        String basePath = root.getAttribute("base.path", this.getCurrentDir());
        String baseDir = basePath + ps + root.getAttribute("base.dir") + ps;
        String appBase = baseDir + root.getAttribute("app.base") + ps;
        String repository = root.getAttribute("repository") + ps;
        String contextPath = root.getAttribute("contextPath");
        Integer port = new Integer(root.getAttribute("port", "9876"));
        try {
            this.tomcat = new Tomcat();
            this.tomcat.setPort(port.intValue());
            this.tomcat.setBaseDir(baseDir);
            this.tomcat.enableNaming();
            StandardServer server = (StandardServer)this.tomcat.getServer();
            AprLifecycleListener listener = new AprLifecycleListener();
            server.addLifecycleListener((LifecycleListener)listener);
            Context context = this.tomcat.addWebapp(contextPath, appBase);
            String contextFile = appBase + "META-INF" + ps + "context.xml";
            if (root.getAttribute("context") != null) {
                contextFile = projectDir + ps + "configs" + ps + root.getAttribute("context");
            }
            File configFile = new File(contextFile);
            context.setConfigFile(configFile.toURI().toURL());
            context.addParameter("projectDir", projectDir);
            if (root.getAttribute("init.xml") != null) {
                context.addParameter("init_xml", root.getAttribute("init.xml"));
            }
            if (repository != null) {
                Context rpContext = this.tomcat.addWebapp("/repository", baseDir + repository);
                File rpConfigFile = new File(baseDir + repository + "META-INF" + ps + "context.xml");
                rpContext.setConfigFile(rpConfigFile.toURI().toURL());
            }
            this.tomcat.start();
        }
        catch (ServletException ex) {
            this.log.severe("Tomcat startuo error : " + (Object)((Object)ex));
        }
        catch (MalformedURLException ex) {
            this.log.severe("Tomcat URL Malformation : " + ex);
        }
        catch (LifecycleException ex) {
            this.log.severe("Tomcat Life cycle error : " + (Object)((Object)ex));
        }
    }

    public BTomcat(BElement appEl, String projectDir, String appKey) {
        String ps = System.getProperty("file.separator");
        String basePath = this.getCurrentDir();
        String baseDir = basePath + ps + "build/webapps" + ps;
        String appBase = baseDir + "baraza" + ps;
        String repository = "repository" + ps;
        String contextPath = "/" + appKey;
        projectDir = projectDir + ps + appEl.getAttribute("path");
        Integer port = new Integer(appEl.getAttribute("port", "9090"));
        try {
            this.tomcat = new Tomcat();
            this.tomcat.setPort(port.intValue());
            this.tomcat.setBaseDir(baseDir);
            this.tomcat.enableNaming();
            StandardServer server = (StandardServer)this.tomcat.getServer();
            AprLifecycleListener listener = new AprLifecycleListener();
            server.addLifecycleListener((LifecycleListener)listener);
            Context context = this.tomcat.addWebapp(contextPath, appBase);
            String contextFile = projectDir + ps + "configs" + ps + "context.xml";
            File configFile = new File(contextFile);
            context.setConfigFile(configFile.toURI().toURL());
            context.addParameter("projectDir", projectDir);
            context.addParameter("init_xml", appEl.getAttribute("xmlfile"));
            if (repository != null) {
                Context rpContext = this.tomcat.addWebapp("/repository", baseDir + repository);
                File rpConfigFile = new File(baseDir + repository + "META-INF" + ps + "context.xml");
                rpContext.setConfigFile(rpConfigFile.toURI().toURL());
            }
            this.tomcat.start();
        }
        catch (ServletException ex) {
            this.log.severe("Tomcat startuo error : " + (Object)((Object)ex));
        }
        catch (MalformedURLException ex) {
            this.log.severe("Tomcat URL Malformation : " + ex);
        }
        catch (LifecycleException ex) {
            this.log.severe("Tomcat Life cycle error : " + (Object)((Object)ex));
        }
    }

    public String getCurrentDir() {
        File directory = new File(".");
        String dirName = null;
        try {
            dirName = directory.getCanonicalPath();
        }
        catch (IOException ex) {
            this.log.severe("Current directory get error : " + ex);
        }
        return dirName;
    }

    @Override
    public void run() {
        this.tomcat.getServer().await();
    }

    public void close() {
        try {
            this.tomcat.stop();
        }
        catch (LifecycleException ex) {
            this.log.severe("Tomcat Life cycle error : " + (Object)((Object)ex));
        }
    }
}

