/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class BFindReplaceDialog
extends JDialog {
    JPanel panel = new JPanel();
    JTextField txtFind;
    JTextField txtReplace;
    JButton btnFind;
    JButton btnReplace;
    JButton btnReplaceAll;
    JButton btnClose;
    JTextComponent pTextComponent;
    JLabel lblResults;
    String findtext;
    String replacetext;
    String fileStr;
    Highlighter.HighlightPainter myHighlightPainter;
    int lastSearch = 0;
    int pos;
    int matches = 0;
    Document doc;
    Highlighter highlighter;

    public BFindReplaceDialog(JTextComponent ptextComponent) {
        this.pTextComponent = ptextComponent;
        this.myHighlightPainter = new MyHighlightPainter(Color.CYAN);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BFindReplaceDialog.this.closeDialog();
            }
        });
        JPanel panel = new JPanel();
        this.txtFind = new JTextField(20);
        this.txtReplace = new JTextField(20);
        this.btnFind = new JButton("Find");
        this.btnReplace = new JButton("Replace");
        this.btnReplaceAll = new JButton("Replace All");
        this.btnClose = new JButton("Exit");
        this.lblResults = new JLabel();
        this.btnFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BFindReplaceDialog.this.findtext = BFindReplaceDialog.this.txtFind.getText().toString();
                if (BFindReplaceDialog.this.findtext.equals("") || BFindReplaceDialog.this.findtext == null) {
                    BFindReplaceDialog.this.lblResults.setText("Enter Text To Find.");
                    BFindReplaceDialog.this.txtFind.requestFocus();
                } else {
                    try {
                        BFindReplaceDialog.this.doc = BFindReplaceDialog.this.pTextComponent.getDocument();
                        BFindReplaceDialog.this.highlighter = BFindReplaceDialog.this.pTextComponent.getHighlighter();
                        BFindReplaceDialog.this.fileStr = BFindReplaceDialog.this.doc.getText(0, BFindReplaceDialog.this.doc.getLength());
                        Pattern p = Pattern.compile(BFindReplaceDialog.this.findtext.toUpperCase());
                        Matcher m = p.matcher(BFindReplaceDialog.this.fileStr.toUpperCase());
                        int count = 0;
                        while (m.find()) {
                            ++count;
                        }
                        BFindReplaceDialog.this.lblResults.setText(count + " Matches Found.");
                        BFindReplaceDialog.this.pos = BFindReplaceDialog.this.fileStr.toUpperCase().indexOf(BFindReplaceDialog.this.findtext.toUpperCase(), BFindReplaceDialog.this.lastSearch);
                        if (BFindReplaceDialog.this.pos >= 0) {
                            BFindReplaceDialog.this.lastSearch = BFindReplaceDialog.this.pos + BFindReplaceDialog.this.findtext.length();
                            try {
                                BFindReplaceDialog.this.highlighter.removeAllHighlights();
                                DefaultHighlighter.DefaultHighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
                                BFindReplaceDialog.this.highlighter.addHighlight(BFindReplaceDialog.this.pos, BFindReplaceDialog.this.pos + BFindReplaceDialog.this.findtext.length(), highlightPainter);
                                BFindReplaceDialog.this.pTextComponent.setCaretPosition(BFindReplaceDialog.this.pos);
                                BFindReplaceDialog.this.pTextComponent.requestFocus();
                            }
                            catch (BadLocationException ex) {
                                System.out.println("Highlighter error : " + ex);
                            }
                        } else {
                            BFindReplaceDialog.this.lastSearch = 0;
                            BFindReplaceDialog.this.lblResults.setText("No Match Found");
                        }
                    }
                    catch (BadLocationException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.btnReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BFindReplaceDialog.this.replacetext = BFindReplaceDialog.this.txtReplace.getText().toString();
                if (BFindReplaceDialog.this.findtext.equals("") || BFindReplaceDialog.this.findtext == null) {
                    BFindReplaceDialog.this.lblResults.setText("Enter Text To Find.");
                    BFindReplaceDialog.this.txtFind.requestFocus();
                } else if (BFindReplaceDialog.this.replacetext.equals("") || BFindReplaceDialog.this.replacetext == null) {
                    BFindReplaceDialog.this.lblResults.setText("Enter Text To Replace With.");
                    BFindReplaceDialog.this.txtFind.requestFocus();
                } else if (BFindReplaceDialog.this.pos == -1) {
                    BFindReplaceDialog.this.lblResults.setText("No Match Found");
                } else {
                    BFindReplaceDialog.this.pTextComponent.select(BFindReplaceDialog.this.pos, BFindReplaceDialog.this.pos + BFindReplaceDialog.this.findtext.length());
                    BFindReplaceDialog.this.pTextComponent.replaceSelection(BFindReplaceDialog.this.replacetext);
                    BFindReplaceDialog.this.lblResults.setText("Replace Successfull.");
                }
            }
        });
        this.btnReplaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block6: {
                    Document doc = BFindReplaceDialog.this.pTextComponent.getDocument();
                    BFindReplaceDialog.this.highlighter = BFindReplaceDialog.this.pTextComponent.getHighlighter();
                    BFindReplaceDialog.this.findtext = BFindReplaceDialog.this.txtFind.getText().toString();
                    BFindReplaceDialog.this.replacetext = BFindReplaceDialog.this.txtReplace.getText().toString();
                    if (!BFindReplaceDialog.this.findtext.equals("") && !BFindReplaceDialog.this.replacetext.equals("")) {
                        try {
                            BFindReplaceDialog.this.fileStr = doc.getText(0, doc.getLength());
                            if (BFindReplaceDialog.this.pos == -1) {
                                BFindReplaceDialog.this.lblResults.setText("No Match Found");
                                break block6;
                            }
                            int countReplaced = 0;
                            while (BFindReplaceDialog.this.pos >= 0) {
                                BFindReplaceDialog.this.pTextComponent.select(BFindReplaceDialog.this.pos, BFindReplaceDialog.this.pos + BFindReplaceDialog.this.findtext.length());
                                BFindReplaceDialog.this.pTextComponent.replaceSelection(BFindReplaceDialog.this.replacetext);
                                ++countReplaced;
                            }
                            BFindReplaceDialog.this.lblResults.setText(countReplaced + "Replaced");
                        }
                        catch (BadLocationException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        BFindReplaceDialog.this.lblResults.setText("Both Fields Required");
                    }
                }
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BFindReplaceDialog.this.closeDialog();
            }
        });
        panel.add(new JLabel("Find"));
        panel.add(this.txtFind);
        panel.add(new JLabel("Replace"));
        panel.add(this.txtReplace);
        panel.add(this.btnFind);
        panel.add(this.btnReplace);
        panel.add(this.btnReplaceAll);
        panel.add(this.btnClose);
        panel.add(this.lblResults);
        this.add(panel);
        this.pack();
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(2);
        this.setTitle("Find Replace");
        this.setLocation(20, 50);
        this.setSize(250, 230);
    }

    public void closeDialog() {
        this.removeHighlight(this.pTextComponent);
        this.dispose();
    }

    public void removeHighlight(JTextComponent textComponent) {
        try {
            Highlighter hilite = textComponent.getHighlighter();
            Highlighter.Highlight[] hilites = hilite.getHighlights();
            for (int i = 0; i < hilites.length; ++i) {
                if (!(hilites[i].getPainter() instanceof MyHighlightPainter)) continue;
                hilite.removeHighlight(hilites[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }
}

