/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.utils;

import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class BAuth
implements CallbackHandler {
    Logger log = Logger.getLogger(BAuth.class.getName());
    String username;
    char[] password;

    public boolean doLogin() {
        boolean mylogin = false;
        try {
            BAuth auth = new BAuth();
            auth.setAuth(this.username, this.password);
            LoginContext lc = new LoginContext("baraza", auth);
            lc.login();
            mylogin = true;
        }
        catch (LoginException ex) {
            this.log.severe("Login error : " + ex);
        }
        return mylogin;
    }

    public void setAuth(String uname, char[] passwd) {
        this.username = uname;
        this.password = passwd;
    }

    @Override
    public void handle(Callback[] callbacks) {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        this.log.severe(toc.getMessage());
                        break;
                    }
                    case 2: {
                        this.log.severe("ERROR: " + toc.getMessage());
                        break;
                    }
                    case 1: {
                        this.log.severe("WARNING: " + toc.getMessage());
                        break;
                    }
                    default: {
                        this.log.severe("Unsupported message type: " + toc.getMessageType());
                        break;
                    }
                }
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.username);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(this.password);
                continue;
            }
            this.log.severe("Unrecognized Callback" + callbacks[i]);
        }
    }
}

