/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.utils.BNumberFormat;
import org.baraza.xml.BElement;
import org.baraza.xml.BXML;

public class BForms {
    Logger log = Logger.getLogger(BForms.class.getName());
    Map<String, String> answers;
    Map<String, String> subanswers;
    String fhead;
    String ffoot;
    BDB db = null;
    String access_text = null;

    public BForms(String dbconfig) {
        this.db = new BDB(dbconfig);
    }

    public BForms(String dbconfig, String at) {
        this.db = new BDB(dbconfig);
        this.access_text = at;
    }

    public String getForm(String entryformid, Map<String, String[]> sParams) {
        String mystr = "";
        this.answers = new HashMap<String, String>();
        this.subanswers = new HashMap<String, String>();
        HashMap<String, String[]> params = new HashMap<String, String[]>(sParams);
        String action = this.getParameter(params, "action");
        String approveStatus = "Draft";
        String entityid = null;
        String formid = null;
        if (action == null) {
            action = "ENTRYFORM";
        }
        if (action.equals("ENTRYFORM")) {
            String[] actionArray = new String[]{action};
            params.put("action", actionArray);
            if (entryformid == null) {
                entryformid = this.getParameter(params, "actionvalue");
            } else {
                String[] actionValueArray = new String[]{entryformid};
                params.put("actionvalue", actionValueArray);
            }
            Map<String, String> formRS = this.db.readFields("form_id, entity_id, approve_status", "entry_forms WHERE entry_form_id = " + entryformid);
            formid = formRS.get("form_id");
            entityid = formRS.get("entity_id");
            approveStatus = formRS.get("approve_status");
        } else if (action.equals("FORM")) {
            formid = this.getParameter(params, "actionvalue");
        }
        String update = this.getParameter(params, "update");
        String submit = this.getParameter(params, "submit");
        String disabled = this.getParameter(params, "disabled");
        String nosave = this.getParameter(params, "nosave");
        String hidehead = this.getParameter(params, "hidehead");
        String upload = this.getParameter(params, "upload");
        if (!"Draft".equals(approveStatus)) {
            nosave = "true";
        }
        String fname = this.getFormType(formid);
        if (update != null) {
            this.saveForm(entryformid, params);
        }
        if (entryformid != null) {
            this.readClientData(entryformid);
        }
        if (entryformid != null && disabled == null) {
            mystr = mystr + "<form id='baraza' name='baraza' method='post' action='form.jsp'>\n";
            mystr = mystr + "<input type='hidden' name='action' value='ENTRYFORM'/>\n";
            mystr = mystr + "<input type='hidden' name='actionvalue' value='" + entryformid + "'/>\n";
        }
        if (!"Draft".equals(approveStatus)) {
            mystr = mystr + "<fieldset><label>FORM SUBMITTED AND CANNOT BE EDITED</label></fieldset>\n";
        }
        mystr = mystr + "<fieldset>\n";
        mystr = mystr + "<label>" + fname + "</label>\n";
        mystr = mystr + "</fieldset>\n";
        if (hidehead == null) {
            mystr = mystr + this.fhead;
        }
        if (submit != null) {
            mystr = mystr + "<section>" + this.submitForm(formid, entryformid) + "</section>\n";
        }
        mystr = mystr + "<fieldset>";
        mystr = mystr + this.printForm(formid, disabled, update, true);
        mystr = mystr + "</fieldset>";
        if (entryformid != null && disabled == null) {
            mystr = mystr + "<hr>\n";
            if (nosave == null) {
                mystr = mystr + "\n<section><input type='submit' name='update' value='Save' class='altProcessButtonFormat'/>";
                mystr = mystr + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                mystr = mystr + "<input type='submit' name='submit' value='Complete and Exit' class='altProcessButtonFormat'/>";
                mystr = mystr + "</section>\n";
            }
            String fileStr = this.printFileUpload(formid);
            if (nosave == null && !fileStr.equals("")) {
                mystr = mystr + "<form id='barazafile' name='barazafile' enctype='multipart/form-data' method='post' action='form.jsp'>\n";
                mystr = mystr + "<input type='hidden' name='action' value='ENTRYFORM'/>\n";
                mystr = mystr + "<input type='hidden' name='actionvalue' value='" + entryformid + "'/>\n";
                mystr = mystr + fileStr;
                mystr = mystr + "<section>Click <input type='submit' name='upload' value='Here'> to upload the files</section>\n";
                mystr = mystr + "</form>\n";
            }
        }
        mystr = mystr + "</form>\n";
        if (hidehead == null) {
            mystr = mystr + this.ffoot;
        }
        return mystr;
    }

    public String getParameter(Map<String, String[]> params, String paramName) {
        String paramValue = null;
        if (params.get(paramName) != null) {
            paramValue = params.get(paramName)[0];
        }
        return paramValue;
    }

    public String getFormType(String formid) {
        this.fhead = "";
        this.ffoot = "";
        String mystr = "";
        String mysql = "SELECT form_header, form_footer, form_name, form_number ";
        BQuery rs = new BQuery(this.db, mysql = mysql + "FROM forms WHERE form_id = " + formid);
        if (rs.moveNext()) {
            this.fhead = rs.getString("form_header");
            this.ffoot = rs.getString("form_footer");
            mystr = rs.getString("form_number") + " : " + rs.getString("form_name");
        }
        rs.close();
        this.fhead = this.fhead == null ? "" : "<section>\n" + this.fhead + "</section>\n";
        this.ffoot = this.ffoot == null ? "" : "<section>\n" + this.ffoot + "</section>\n";
        return mystr;
    }

    public void readClientData(String entryformid) {
        this.answers.clear();
        this.subanswers.clear();
        String mysql = "SELECT entity_id, form_id, approve_status, answer, sub_answer ";
        mysql = mysql + " FROM entry_forms WHERE entry_form_id = " + entryformid;
        BQuery rs = new BQuery(this.db, mysql);
        if (rs.moveNext()) {
            BElement xmlans = this.getXMLNode(rs.getString("answer"));
            BElement xmlsans = this.getXMLNode(rs.getString("sub_answer"));
            BNumberFormat bnf = new BNumberFormat();
            if (xmlans != null) {
                for (BElement el : xmlans.getElements()) {
                    this.answers.put(el.getName(), el.getValue());
                }
            }
            if (xmlsans != null) {
                for (BElement el : xmlsans.getElements()) {
                    this.subanswers.put(el.getName(), el.getValue());
                }
            }
        }
        rs.close();
    }

    public BElement getXMLNode(String xmlStr) {
        BElement node = null;
        if (xmlStr != null) {
            BXML xml = new BXML(xmlStr, true);
            if (xml.getDocument() == null) {
                this.log.severe("XML loading file error");
            } else {
                node = xml.getRoot();
            }
        }
        return node;
    }

    public String getAnswer(String fieldid) {
        String answer = this.answers.get("F" + fieldid);
        if (answer == null) {
            answer = "";
        } else if (answer.trim().equals("")) {
            answer = "";
        } else {
            answer = answer.replaceAll("&", "&amp;").replaceAll("\"", "&quot;");
            answer = " value=\"" + answer + "\" ";
        }
        return answer;
    }

    public String getAnswer(String subfieldid, int answerline) {
        String answer = null;
        String qst = "SF:" + subfieldid + ":" + Integer.toString(answerline);
        answer = this.subanswers.get(qst);
        if (answer == null) {
            answer = "";
        } else if (answer.trim().equals("")) {
            answer = "";
        } else {
            answer = answer.replaceAll("&", "&amp;").replaceAll("\"", "&quot;");
            answer = " value=\"" + answer + "\" ";
        }
        return answer;
    }

    public String printForm(String formid, String disabled, String process, boolean allowTabs) {
        String myhtml = "";
        int fieldOrder = 0;
        int shareLine = 0;
        int sl = -1;
        int cnt_title = 0;
        int size = 0;
        int table_count = 0;
        String label = "";
        String input = "";
        String fieldType = "TEXTFIELD";
        String fieldclass = "";
        String question = "";
        String details = "";
        String label_position = "";
        disabled = disabled == null ? "" : " disabled=\"true\" ";
        boolean isTabs = false;
        String tab = "";
        String tab_head = "";
        String tab_body = "";
        String mysql = "SELECT * FROM fields WHERE form_id = " + formid;
        mysql = mysql + " ORDER BY field_order, field_id;";
        BQuery rs = new BQuery(this.db, mysql);
        while (rs.moveNext()) {
            String lookups;
            fieldOrder = rs.getInt("field_order");
            shareLine = rs.getInt("share_line");
            fieldType = "TEXTFIELD";
            if (rs.getString("field_type") != null) {
                fieldType = rs.getString("field_type");
            }
            fieldclass = "";
            if (rs.getString("field_class") != null) {
                fieldclass = " class='" + rs.getString("field_class") + "' ";
            }
            question = rs.getString("question");
            if (rs.getString("question") == null) {
                question = "";
            }
            details = rs.getString("details");
            if (rs.getString("details") == null) {
                details = "";
            }
            label_position = rs.getString("label_position");
            if (rs.getString("label_position") == null) {
                label_position = "L";
            }
            size = 10;
            if (rs.getString("field_size") == null) {
                size = rs.getInt("field_size");
            }
            if (rs.getBoolean("field_bold").booleanValue()) {
                question = "<b>" + question + "</b>";
            }
            if (rs.getBoolean("field_italics").booleanValue()) {
                question = "<i>" + question + "</i>";
            }
            if (rs.getString("tab") != null) {
                if (tab.equals("")) {
                    tab_head = "<fieldset><div id=\"tab\" class=\"tabstrip k-widget k-header k-tabstrip\">";
                    tab_head = tab_head + "<ul class=\"k-tabstrip-items k-reset\">";
                    tab_head = tab_head + "<li class=\"k-item k-state-default k-first k-tab-on-top k-state-active\"><a classx=\"k-link\" hrefx=\"#" + rs.getString("tab").replace(" ", "_") + "\">" + rs.getString("tab") + "</a></li>";
                    tab_body = "<div class=\"k-content k-state-active\" id=\"" + rs.getString("tab").replace(" ", "_") + "\">";
                } else if (!tab.equals("") && !tab.equals(rs.getString("tab"))) {
                    tab_head = tab_head + "<li class=\"k-item k-state-default\"><a classx=\"k-link\" hrefx=\"#" + rs.getString("tab").replace(" ", "_") + "\">" + rs.getString("tab") + "</a></li>";
                    tab_body = tab_body + "</div><div class=\"k-content\" id=\"" + rs.getString("tab").replace(" ", "_") + "\">";
                } else if (tab.equals(rs.getString("tab"))) {
                    // empty if block
                }
                tab = rs.getString("tab");
                isTabs = true;
            } else if (rs.getString("tab") == null && !tab.equals("")) {
                this.log.info("Last Item in tab");
                tab_head = tab_head + "</ul>";
                tab_body = tab_body + "</div></div>";
                tab = "";
                myhtml = myhtml + tab_head;
                myhtml = myhtml + tab_body;
                isTabs = false;
            }
            label = "<label for='F" + rs.getString("field_id") + "'> " + question + "</label>";
            if (fieldType.equals("TEXTFIELD")) {
                input = "<input " + disabled + " type='text' ";
                input = input + " style='width:" + rs.getString("field_size") + "0px' ";
                input = input + " name='F" + rs.getString("field_id") + "'";
                input = input + " id ='F" + rs.getString("field_id") + "'";
                input = input + this.getAnswer(rs.getString("field_id"));
                input = input + " placeholder=\"" + details + "\"";
                input = input + " class='placeholder fillout' />";
            } else if (fieldType.equals("DATE")) {
                input = "<input " + disabled + " type='text' ";
                input = input + " style='width:" + rs.getString("field_size") + "0px' ";
                input = input + " name='F" + rs.getString("field_id") + "'";
                input = input + " id ='F" + rs.getString("field_id") + "'";
                input = input + this.getAnswer(rs.getString("field_id"));
                input = input + " class='datepicker' />";
            } else if (fieldType.equals("TIME")) {
                input = "<input " + disabled + " type='text' ";
                input = input + " style='width:" + rs.getString("field_size") + "0px' ";
                input = input + " name='F" + rs.getString("field_id") + "'";
                input = input + " id ='F" + rs.getString("field_id") + "'";
                input = input + this.getAnswer(rs.getString("field_id"));
                input = input + " class='timepicker' />";
            } else if (fieldType.equals("LIST")) {
                input = "<select class='formcombobox' ";
                input = input + " name='F" + rs.getString("field_id") + "'";
                input = input + " id='F" + rs.getString("field_id") + "'";
                input = input + ">\n";
                lookups = rs.getString("field_lookup");
                String listVal = this.answers.get("F" + rs.getString("field_id"));
                listVal = listVal == null ? "" : listVal.replace("\"", "").trim();
                if (lookups != null) {
                    String[] lookup;
                    for (String lps : lookup = lookups.split("#")) {
                        input = lps.compareToIgnoreCase(listVal) == 0 ? input + "<option selected='selected'>" + lps + "</option>\n" : input + "<option>" + lps + "</option>\n";
                    }
                }
                input = input + "</select>";
                input = input + "<span  id='list" + rs.getString("field_id") + "' " + this.getAnswer(rs.getString("field_id")) + " class='noscreen'>" + listVal + "</span>";
            } else if (fieldType.equals("SELECT")) {
                input = "<select class='formcombobox' ";
                input = input + " name='F" + rs.getString("field_id") + "'";
                input = input + " id='F" + rs.getString("field_id") + "'";
                input = input + ">\n";
                lookups = rs.getString("field_lookup");
                String selectVal = this.answers.get("F" + rs.getString("field_id"));
                selectVal = selectVal == null ? "" : selectVal.replace("\"", "").trim();
                String spanVal = "";
                if (lookups != null) {
                    BQuery lprs = new BQuery(this.db, lookups);
                    int cols = lprs.getColnum();
                    while (lprs.moveNext()) {
                        if (cols == 1) {
                            if (lprs.readField(1).trim().compareToIgnoreCase(selectVal) == 0) {
                                spanVal = lprs.readField(1);
                                input = input + "<option value='" + lprs.readField(1) + "' selected='selected'>" + lprs.readField(1) + "</option>\n";
                                continue;
                            }
                            input = input + "<option value='" + lprs.readField(1) + "'>" + lprs.readField(1) + "</option>\n";
                            continue;
                        }
                        if (lprs.readField(1).trim().compareToIgnoreCase(selectVal) == 0) {
                            spanVal = lprs.readField(2);
                            input = input + "<option value='" + lprs.readField(1) + "' selected='selected'>" + lprs.readField(2) + "</option>\n";
                            continue;
                        }
                        input = input + "<option value='" + lprs.readField(1) + "'>" + lprs.readField(2) + "</option>\n";
                    }
                    lprs.close();
                }
                input = input + "</select>";
                input = input + "<span  id='select" + rs.getString("field_id") + "' " + this.getAnswer(rs.getString("field_id")) + " class='noscreen'> " + spanVal + "</span>";
            } else if (fieldType.equals("TITLE")) {
                ++cnt_title;
                input = "";
                myhtml = myhtml + "\n<fieldset><label><strong>" + question + "</strong></label></fieldset>";
            } else if (fieldType.equals("SUBGRID")) {
                input = "";
                myhtml = myhtml + this.printSubForm(rs.getString("field_id"), disabled);
            } else if (fieldType.equals("TABLE")) {
                input = "";
                myhtml = myhtml + this.printSubTable(rs.getString("field_id"), disabled, question, ++table_count);
            }
            if (input.equals("")) {
                input = "";
            } else if (label_position.equals("L")) {
                input = question + " " + input + "\n";
            } else if (label_position.equals("T")) {
                input = "<label>" + question + "<br>" + input + "</label>\n";
            } else if (label_position.equals("B")) {
                input = "<label>" + input + "<br>" + question + "</label>\n";
            } else if (label_position.equals("R")) {
                input = input + " " + question + "\n";
            }
            if (input.equals("")) {
                input = "";
                continue;
            }
            if (fieldOrder == shareLine) {
                if (!isTabs) {
                    myhtml = sl == -1 ? myhtml + "<section>" + input : myhtml + "</section><section>" + input;
                } else {
                    tab_body = tab_body + input;
                }
                sl = shareLine;
                continue;
            }
            if (sl == shareLine) {
                if (!isTabs) {
                    myhtml = myhtml + input;
                    continue;
                }
                tab_body = tab_body + input;
                continue;
            }
            if (shareLine != 0) continue;
            if (!isTabs) {
                myhtml = sl == -1 ? myhtml + "<section>" + input + "</section>\n" : myhtml + "</section><section>" + input + "</section>\n";
            } else {
                tab_body = tab_body + "<section>" + input + "</section>";
            }
            sl = -1;
        }
        if (isTabs) {
            myhtml = myhtml + "</fieldset>\n";
        }
        rs.close();
        return myhtml;
    }

    public String printSubTable(String fieldid, String disabled, String caption, int num) {
        String myhtml = "";
        String mysql = "SELECT sub_field_id, sub_field_type, sub_field_size, sub_field_lookup, question ";
        mysql = mysql + " FROM vw_sub_fields WHERE field_id = " + fieldid;
        mysql = mysql + " ORDER BY sub_field_order";
        BQuery rs = new BQuery(this.db, mysql);
        String mytitle = "";
        String titleshare = "";
        String sharetitle = "";
        HashMap<String, String> subFields = new HashMap<String, String>();
        HashMap<String, String> subFieldLookups = new HashMap<String, String>();
        HashMap<String, String> subFieldSize = new HashMap<String, String>();
        ArrayList<String> subFieldOrder = new ArrayList<String>();
        String filltb = "";
        String tableRows = "";
        String ans = "";
        String sub_field_type = "TEXTFIELD";
        String sub_field_size = "";
        while (rs.moveNext()) {
            subFieldOrder.add(rs.getString("sub_field_id"));
            subFields.put(rs.getString("sub_field_id"), rs.getString("sub_field_type"));
            subFieldSize.put(rs.getString("sub_field_id"), rs.getString("sub_field_size"));
            subFieldLookups.put(rs.getString("sub_field_id"), rs.getString("sub_field_lookup"));
            mytitle = mytitle + "<td>" + rs.getString("question") + "</td>";
        }
        int j = 1;
        boolean printRow = true;
        while (printRow) {
            filltb = "<tr>";
            boolean hasData = false;
            for (String subFieldID : subFieldOrder) {
                String lookups;
                ans = this.getAnswer(subFieldID, j);
                String answer = this.subanswers.get("SF:" + subFieldID + ":" + Integer.toString(j));
                if (answer == null) {
                    answer = "";
                } else {
                    hasData = true;
                }
                sub_field_type = (String)subFields.get(subFieldID);
                sub_field_size = (String)subFieldSize.get(subFieldID);
                if (sub_field_type.equals("TEXTFIELD")) {
                    filltb = filltb + "<td><input" + disabled + " class='mytableinput' type='text' size='25'";
                    filltb = filltb + " style='width:" + sub_field_size + "0px' ";
                    filltb = filltb + " id='SF:" + subFieldID + "'";
                    filltb = filltb + " name='SF:" + subFieldID + "'";
                    filltb = filltb + ans + "/></td>\n";
                    continue;
                }
                if (sub_field_type.equals("LIST")) {
                    filltb = filltb + "<td><select classx='formcombobox'";
                    filltb = filltb + " id='SF:" + subFieldID + "'";
                    filltb = filltb + " name='SF:" + subFieldID + "'";
                    filltb = filltb + ">\n";
                    lookups = (String)subFieldLookups.get(subFieldID);
                    if (lookups != null) {
                        String[] lookup;
                        for (String lps : lookup = lookups.split("#")) {
                            filltb = lps.equals(answer) ? filltb + "<option selected='selected'>" + lps + "</option>\n" : filltb + "<option>" + lps + "</option>\n";
                        }
                    }
                    filltb = filltb + "</select></td>\n";
                    continue;
                }
                if (!sub_field_type.equals("SELECT")) continue;
                filltb = filltb + "<td><select classx='formcombobox' ";
                filltb = filltb + " id='SF:" + subFieldID + "'";
                filltb = filltb + " name='SF:" + subFieldID + "'";
                filltb = filltb + ">\n";
                lookups = (String)subFieldLookups.get(subFieldID);
                String spn = "";
                if (lookups != null) {
                    BQuery lprs = new BQuery(this.db, lookups);
                    int cols = lprs.getColnum();
                    while (lprs.moveNext()) {
                        if (cols == 1) {
                            if (lprs.readField(1).equals(answer)) {
                                spn = lprs.readField(1);
                                filltb = filltb + "<option value='" + lprs.readField(1) + "' selected='selected'>" + lprs.readField(1) + "</option>\n";
                                continue;
                            }
                            filltb = filltb + "<option value='" + lprs.readField(1) + "'>" + lprs.readField(1) + "</option>\n";
                            continue;
                        }
                        if (lprs.readField(1).equals(answer)) {
                            spn = lprs.readField(2);
                            filltb = filltb + "<option value='" + lprs.readField(1) + "' selected='selected'>" + lprs.readField(2) + "</option>\n";
                            continue;
                        }
                        filltb = filltb + "<option value='" + lprs.readField(1) + "'>" + lprs.readField(2) + "</option>\n";
                    }
                    lprs.close();
                }
                filltb = filltb + "</select>";
                filltb = filltb + "<span  id='tableselect" + subFieldID + "'  class='noscreen'> " + spn + "</span></td>\n";
            }
            if (hasData) {
                filltb = filltb + "<td><input type='button' class='deleteThisRow' name='" + num + "' value='Delete'/></td>";
            }
            filltb = filltb + "</tr>\n";
            if (hasData) {
                tableRows = tableRows + filltb;
            } else {
                printRow = false;
            }
            ++j;
        }
        if (j == 2) {
            tableRows = tableRows + filltb;
        }
        myhtml = myhtml + "<fieldset>\n";
        myhtml = myhtml + "<div class='subTable" + num + " g8' id='subTable" + num + "'>\n";
        myhtml = myhtml + "<table class='innerTable'>\n";
        myhtml = myhtml + "<tr>" + mytitle + "<td></td></tr>\n";
        myhtml = myhtml + tableRows;
        myhtml = myhtml + "</table>\n";
        myhtml = myhtml + "<input type='button' class='btnAddMore' value='Add Row' name='" + num + "'/>\n";
        myhtml = myhtml + "</div>\n";
        myhtml = myhtml + "</fieldset>";
        rs.close();
        return myhtml;
    }

    public String printSubForm(String fieldid, String disabled) {
        String myhtml = "";
        String mysql = "SELECT * FROM vw_sub_fields WHERE field_id = " + fieldid;
        mysql = mysql + " ORDER BY sub_field_order";
        BQuery rs = new BQuery(this.db, mysql);
        String mytitle = "";
        String titleshare = "";
        String sharetitle = "";
        HashMap<String, String> subFields = new HashMap<String, String>();
        HashMap<String, String> subFieldLookups = new HashMap<String, String>();
        ArrayList<String> subFieldOrder = new ArrayList<String>();
        while (rs.moveNext()) {
            if (rs.getString("sub_title_share") != null) {
                if (!sharetitle.equals(rs.getString("sub_title_share"))) {
                    titleshare = titleshare + "<td colspan=" + rs.getString("sub_col_spans") + ">" + rs.getString("sub_title_share") + "</td>";
                }
                mytitle = mytitle + "<td>" + rs.getString("question") + "</td>";
                sharetitle = rs.getString("sub_title_share");
            } else {
                titleshare = titleshare + "<td rowspan=\"2\">" + rs.getString("question") + "</td>";
            }
            subFieldOrder.add(rs.getString("sub_field_id"));
            subFields.put(rs.getString("sub_field_id"), rs.getString("sub_field_type"));
            subFieldLookups.put(rs.getString("sub_field_id"), rs.getString("sub_field_lookup"));
        }
        String filltb = "";
        String ans = "";
        int j = 1;
        boolean printRow = true;
        while (printRow) {
            filltb = filltb + "<tr>";
            boolean hasData = false;
            for (String subFieldID : subFieldOrder) {
                ans = this.getAnswer(subFieldID, j);
                if (!ans.equals("")) {
                    hasData = true;
                }
                String sub_field_type = (String)subFields.get(subFieldID);
                this.log.info("SUB FIELD TYPE = " + sub_field_type);
                if (sub_field_type.equals("TEXTFIELD")) {
                    this.log.info("BUILDING textfield");
                    filltb = filltb + "<td><input" + disabled + " class=\"mytableinput\" type=\"text\" size=\"25\" ";
                    filltb = filltb + "name=\"SF:" + subFieldID + ":" + Integer.toString(j) + "\"";
                    filltb = filltb + ans + "/></td>";
                    continue;
                }
                if (sub_field_type.equals("TITLE")) {
                    this.log.info("BUILDING title");
                    filltb = "<td></td>";
                    continue;
                }
                this.log.info("UNKNOWN TYPE");
                filltb = filltb + "<td><input" + disabled + " class=\"mytableinput\" type=\"text\" size=\"25\" ";
                filltb = filltb + "name=\"SF:" + subFieldID + ":" + Integer.toString(j) + "\"";
                filltb = filltb + ans + "/></td>";
            }
            filltb = filltb + "</tr>\n";
            if (!hasData) {
                printRow = false;
            }
            ++j;
        }
        myhtml = "<tr><td><table width=\"790\" border=\"5\">";
        myhtml = myhtml + "<tr>" + titleshare + "</tr>\n";
        myhtml = myhtml + "<tr>" + mytitle + "</tr>\n";
        myhtml = myhtml + filltb;
        myhtml = myhtml + "</table></td></tr>\n";
        rs.close();
        return myhtml;
    }

    public String printFileUpload(String formid) {
        String responce = "";
        String mysql = "SELECT * FROM fields WHERE (field_type = 'SUBGRID') AND (form_id = " + formid + ") ";
        mysql = mysql + "ORDER BY field_order, field_id";
        BQuery rs = new BQuery(this.db, mysql);
        while (rs.moveNext()) {
            String q = " the file ";
            if (rs.getString("question") != null) {
                q = rs.getString("question");
            }
            responce = responce + "<tr><td>Upload: " + q + "<input type='file' name='" + rs.getString("field_id") + "'></td></tr>\n";
        }
        return responce;
    }

    public void saveForm(String entryformid, Map<String, String[]> webparams) {
        HashMap<String, String[]> params = new HashMap<String, String[]>(webparams);
        params.remove("action");
        params.remove("actionvalue");
        params.remove("update");
        params.remove("submit");
        params.remove("hidehead");
        params.remove("blankpage");
        String ans = "";
        this.readClientData(entryformid);
        String mkey = "";
        String formXML = "<FORM>";
        String subFormXML = "<SUBFORM>";
        String subTableXML = "<TABLE>";
        for (String key : params.keySet()) {
            ans = ((String[])params.get(key))[0];
            ans = ans.replace("&", "and");
            ans = ans.replace("'", "\\\\'").replaceAll("<", "&lt;");
            if (key.startsWith("F")) {
                formXML = formXML + "<" + key + ">" + ans + "</" + key + ">";
                continue;
            }
            if (key.startsWith("SF")) {
                Integer i = 1;
                for (String subans : (String[])params.get(key)) {
                    mkey = key + ":" + i.toString();
                    subFormXML = subFormXML + "<" + mkey + ">" + subans + "</" + mkey + ">";
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
                continue;
            }
            if (!key.startsWith("T")) continue;
            subTableXML = subTableXML + "<" + key + ">" + ans + "</" + key + ">";
        }
        formXML = formXML + "</FORM>";
        subFormXML = subFormXML + "</SUBFORM>";
        subTableXML = subTableXML + "</TABLE>";
        this.log.info("subFormXML = " + subFormXML);
        String mysql = "UPDATE entry_forms SET answer = '" + formXML + "', ";
        mysql = mysql + "sub_answer = '" + subFormXML + "' ";
        mysql = mysql + "WHERE entry_form_id = " + entryformid;
        this.db.executeQuery(mysql);
    }

    public String submitForm(String formid, String entryformid) {
        String myhtml = "<table width='790' border='1'>";
        String mysql = "SELECT * FROM fields WHERE (form_id = " + formid;
        mysql = mysql + ") AND (manditory = '1') ";
        mysql = mysql + "ORDER BY field_order, field_id;";
        BQuery rs = new BQuery(this.db, mysql);
        String ans = "";
        boolean verified = true;
        while (rs.moveNext()) {
            String fieldType = "TEXTFIELD";
            if (rs.getString("field_type") != null) {
                fieldType = rs.getString("field_type");
            }
            String question = rs.getString("question");
            if (rs.getString("question") == null) {
                question = "";
            }
            if (!fieldType.equals("TEXTFIELD") && !fieldType.equals("DATE") && !fieldType.equals("TIME") || !(ans = this.getAnswer(rs.getString("field_id"))).trim().equals("")) continue;
            verified = false;
            myhtml = myhtml + "<tr><td><div style='color:#FF0000; font-weight:bold;'>* You need to answer : " + question + "</div></td></tr>";
        }
        rs.close();
        if (verified && this.saveTable(formid, entryformid) != null) {
            verified = false;
            myhtml = myhtml + "<tr><td><b>You need to ensure you have made the selection properly</b></td></tr>";
        }
        if (verified) {
            mysql = "UPDATE entry_forms SET approve_status = 'Completed', completion_date = now() WHERE (entry_form_id = ";
            mysql = mysql + entryformid + ")";
            this.db.executeQuery(mysql);
            myhtml = myhtml + "<tr><td><b>The form has been submitted successfully</b></td></tr>";
        }
        myhtml = myhtml + "</table>\n";
        myhtml = verified ? myhtml + "<script>window.close();</script>\n" : "<div style='color:#FF0000; font-weight:bold;'>\n" + myhtml + "\n</div>";
        return myhtml;
    }

    public String uploadFile(HttpServletRequest request) {
        FileItem item;
        int i;
        List items;
        String response = "";
        int MaxMemorySize = 2048576;
        File TempDirectory2 = new File("/opt/tomcat/temp/baraza.tmp");
        DiskFileItemFactory factory = new DiskFileItemFactory(MaxMemorySize, TempDirectory2);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            items = upload.parseRequest(request);
        }
        catch (FileUploadException ex) {
            this.log.severe("File upload exception");
            return "File Upload error, ensure you have a correct excel format 97 version.";
        }
        String entryformid = "";
        for (i = 0; i < items.size(); ++i) {
            item = (FileItem)items.get(i);
            if (!item.isFormField()) continue;
            String name = item.getFieldName();
            String value = item.getString();
            if (name.equals("actionvalue")) {
                entryformid = value;
            }
            System.out.println(name + " = " + value);
        }
        for (i = 0; i < items.size(); ++i) {
            long maxfs;
            item = (FileItem)items.get(i);
            if (item.isFormField()) continue;
            String contentType = item.getContentType();
            String fieldName = item.getFieldName();
            String fileName = item.getName();
            long fs = item.getSize();
            if (fs > (maxfs = (long)MaxMemorySize)) {
                response = "<div class=\"style33\">The file is too big<br/>";
                response = response + "maximum size allowed is " + String.valueOf(maxfs) + " bytes</div>";
            } else if (fs > 0L) {
                this.getExcelData(fieldName, entryformid, item);
            }
            System.out.println(contentType + " : " + fieldName + " = " + fileName);
        }
        return entryformid;
    }

    public void getExcelData(String fieldid, String entryformid, FileItem item) {
        POIFSFileSystem fs = null;
        HSSFWorkbook wb = null;
        DirectoryNode rootdir = null;
        ArrayList<String> sub_fields = new ArrayList<String>();
        String mysql = "SELECT sub_field_id FROM sub_fields WHERE field_id = " + fieldid;
        BQuery rs = new BQuery(this.db, mysql);
        while (rs.moveNext()) {
            sub_fields.add(rs.getString("sub_field_id"));
        }
        rs.close();
        try {
            fs = new POIFSFileSystem(item.getInputStream());
            rootdir = fs.getRoot();
            wb = new HSSFWorkbook(fs);
        }
        catch (IOException e) {
            this.log.severe("an I/O error occurred, or the InputStream did not provide a compatible POIFS data structure");
            return;
        }
        HSSFSheet sheet = wb.getSheetAt(0);
        HSSFRow row = null;
        int i = 0;
        for (i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
            row = sheet.getRow(i);
            if (row == null) continue;
            mysql = "INSERT INTO entry_sub_fields(entry_form_id, sub_field_id, answer_line, answer) VALUES ";
            for (int j = 0; j < sub_fields.size(); ++j) {
                if (j != 0) {
                    mysql = mysql + ",";
                }
                mysql = mysql + "\n(" + entryformid + ", " + (String)sub_fields.get(j) + ", " + Integer.toString(i + 1) + ", '";
                mysql = mysql + this.getCellValue(row, j) + "')";
            }
        }
    }

    public String getCellValue(HSSFRow row, int column) {
        String mystr = "";
        HSSFCell cell = row.getCell(column);
        if (cell == null) {
            cell = row.createCell(column);
        }
        if (cell.getCellType() == 1) {
            if (cell.getStringCellValue() != null) {
                mystr = mystr + cell.getStringCellValue().trim();
            }
        } else if (cell.getCellType() == 0) {
            mystr = mystr + cell.getNumericCellValue();
        }
        mystr = mystr.replaceAll("\"", "").replaceAll("'", "").trim();
        return mystr;
    }

    public String getFormField(String formid) {
        String ans = null;
        String mysql = "SELECT field_id, question FROM fields WHERE (field_type = 'SUBGRID')";
        mysql = mysql + " AND (form_id = " + formid + ")";
        BQuery rs = new BQuery(this.db, mysql);
        while (rs.moveNext()) {
            if (ans == null) {
                ans = "";
            }
            ans = ans + "<option value='" + rs.readField(1) + "'>" + rs.readField(2) + "</option>\n";
        }
        rs.close();
        ans = ans == null ? "" : "<td>Field : <select name='reportfield'>" + ans + "</select></td>";
        return ans;
    }

    public String getFormReportSQL(String formid, String startDate, String endDate, String reportLevel) {
        String mysql = "SELECT vw_entry_forms.entry_form_id, vw_entry_forms.form_name, vw_entry_forms.entity_name, ";
        mysql = mysql + "vw_entry_forms.application_date, vw_entry_forms.completion_date, vw_entry_forms.narrative, ";
        mysql = mysql + "vw_entry_forms.action_date, vw_entry_forms.answer ";
        mysql = mysql + "FROM vw_entry_forms ";
        mysql = mysql + "WHERE (vw_entry_forms.approve_status='Approved') ";
        mysql = mysql + "AND (vw_entry_forms.form_id = " + formid + ")";
        if ((startDate = this.getConvDate(startDate)) != null) {
            mysql = mysql + " AND (vw_entry_forms.completion_date >= '" + startDate + "')";
        }
        if ((endDate = this.getConvDate(endDate)) != null) {
            mysql = mysql + " AND (vw_entry_forms.completion_date <= '" + endDate + "')";
        }
        return mysql;
    }

    public String getFormReport(String formid, String startDate, String endDate, String reportLevel, String reportField) {
        StringBuffer myhtml = new StringBuffer();
        ArrayList<String> lstq = new ArrayList<String>();
        String mysql = "";
        if (reportLevel == null) {
            reportLevel = "Basic";
        }
        if (reportLevel.equals("Sub Field")) {
            mysql = "SELECT sub_field_id, question FROM sub_fields WHERE (show = '1') AND (field_id = " + reportField + ")\n";
            mysql = mysql + "ORDER BY sub_field_order";
            BQuery fldrs = new BQuery(this.db, mysql);
            myhtml.append("<table cellpadding='0' cellspacing='0' border='0' class='display' id='thetable'>\n");
            myhtml.append("<thead><tr>\n");
            myhtml.append("<th>Client</th>");
            while (fldrs.moveNext()) {
                myhtml.append("<th>" + fldrs.getString("question") + "</th>");
                lstq.add(fldrs.getString("sub_field_id"));
            }
            myhtml.append("\n</tr></thead>\n");
            fldrs.close();
            myhtml.append("<tbody>\n");
            mysql = "SELECT entry_form_id, entity_name FROM vw_entry_forms WHERE form_id = " + formid;
            mysql = mysql + " AND (approve_status = 'Completed') ";
            startDate = this.getConvDate(startDate);
            if (startDate != null) {
                mysql = mysql + " AND (completion_date >= '" + startDate + "')";
            }
            if ((endDate = this.getConvDate(endDate)) != null) {
                mysql = mysql + " AND (completion_date <= '" + endDate + "')";
            }
            mysql = mysql + " ORDER BY completion_date";
            BQuery rsa = new BQuery(this.db, mysql);
            while (rsa.moveNext()) {
                int i = 1;
                if (lstq.size() == 0) {
                    i = -1;
                }
                while (i > 0) {
                    boolean fd = true;
                    for (String stq : lstq) {
                        mysql = "SELECT entry_sub_fields.answer FROM entry_sub_fields INNER JOIN sub_fields ";
                        mysql = mysql + "ON entry_sub_fields.sub_field_id = sub_fields.sub_field_id";
                        mysql = mysql + " WHERE (sub_fields.field_id = " + reportField + ") ";
                        mysql = mysql + " AND (entry_sub_fields.entry_form_id = " + rsa.getString("entry_form_id") + ") ";
                        mysql = mysql + " AND (entry_sub_fields.sub_field_id = " + stq + ") ";
                        String ans = this.db.executeFunction(mysql = mysql + " AND (entry_sub_fields.answer_line = " + Integer.toString(i) + ")");
                        if (ans == null) {
                            i = -1;
                            ans = "";
                            continue;
                        }
                        if (fd) {
                            myhtml.append("<tr><td>" + rsa.getString("entity_name") + "</td>");
                            fd = false;
                        }
                        myhtml.append("<td>" + ans + "</td>");
                    }
                    if (i <= 0) continue;
                    myhtml.append("</tr>\n");
                    ++i;
                }
            }
        } else {
            return this.getFormReport(formid, startDate, endDate, reportLevel);
        }
        myhtml.append("</tbody>\n");
        myhtml.append("</table>\n");
        return myhtml.toString();
    }

    public String getFormReport(String formid, String startDate, String endDate, String reportLevel) {
        StringBuffer myhtml = new StringBuffer();
        ArrayList<String> lstq = new ArrayList<String>();
        if (reportLevel == null) {
            reportLevel = "Basic";
        }
        String mysql = this.getFormReportSQL(formid, startDate, endDate, reportLevel);
        BQuery rs = new BQuery(this.db, mysql);
        int cols = rs.getColumnCount();
        int col = 0;
        String ans = "";
        myhtml.append("<table cellpadding='0' cellspacing='0' border='0' class='display' id='thetable'>\n");
        myhtml.append("<thead><tr>\n");
        for (col = 1; col < cols - 1; ++col) {
            myhtml.append("<th>" + rs.initCap(rs.getColumnName(col)) + "</th>");
        }
        if (reportLevel.equals("Detailed")) {
            mysql = "SELECT field_id, question";
            mysql = mysql + " FROM fields";
            mysql = mysql + " WHERE (show = '1') AND (field_type != 'TITLE') AND (field_type != 'SUBGRID') ";
            mysql = mysql + " AND (form_id = " + formid + ")";
            mysql = mysql + " ORDER BY field_order";
            BQuery fldrs = new BQuery(this.db, mysql);
            while (fldrs.moveNext()) {
                myhtml.append("<th>" + fldrs.getString("question") + "</th>");
                lstq.add(fldrs.getString("field_id"));
            }
            fldrs.close();
        }
        myhtml.append("</tr></thead>\n");
        myhtml.append("<tbody>\n");
        rs.beforeFirst();
        while (rs.moveNext()) {
            myhtml.append("<tr>");
            for (col = 1; col < cols; ++col) {
                myhtml.append("<td>" + rs.getFormatField(col) + "</td>");
            }
            myhtml.append("</tr>\n");
        }
        myhtml.append("</tbody>\n");
        myhtml.append("</table>\n");
        rs.close();
        return myhtml.toString();
    }

    public void getReport(HttpServletRequest request, HttpServletResponse response) {
        String formid = request.getParameter("formid");
        String startDate = request.getParameter("startdate");
        String endDate = request.getParameter("enddate");
        String reportLevel = request.getParameter("reportlevel");
        String reportField = request.getParameter("reportfield");
        if (reportLevel == null) {
            reportLevel = "Basic";
        }
        ArrayList<String> lstq = new ArrayList<String>();
        StringBuffer csvhtml = new StringBuffer();
        String ans = "";
        String mysql = "";
        if (reportLevel.equals("Basic") || reportLevel.equals("Detailed")) {
            mysql = this.getFormReportSQL(formid, startDate, endDate, reportLevel);
            BQuery rs = new BQuery(this.db, mysql);
            int cols = rs.getColumnCount();
            int col = 0;
            csvhtml.append("Form ID");
            for (col = 1; col < cols; ++col) {
                csvhtml.append("," + rs.initCap(rs.getColumnName(col)));
            }
            if (reportLevel.equals("Detailed")) {
                mysql = "SELECT field_id, question FROM fields";
                mysql = mysql + " WHERE (show = '1') AND (field_type = 'TEXTFIELD') ";
                mysql = mysql + " AND (form_id = " + formid + ")";
                mysql = mysql + " ORDER BY field_order";
                BQuery fldrs = new BQuery(this.db, mysql);
                while (fldrs.moveNext()) {
                    String question = fldrs.getString("question");
                    if (question == null) continue;
                    if (question.indexOf(",") > 0) {
                        csvhtml.append(",\"" + question + "\"");
                    } else {
                        csvhtml.append("," + question);
                    }
                    lstq.add(fldrs.getString("field_id"));
                }
                fldrs.close();
            }
            csvhtml.append("\n");
            rs.beforeFirst();
            while (rs.moveNext()) {
                csvhtml.append(rs.getString("entry_form_id"));
                for (col = 1; col < cols - 1; ++col) {
                    csvhtml.append("," + rs.getFormatField(col));
                }
                for (String string : lstq) {
                }
                csvhtml.append("\n");
            }
            rs.close();
        } else if (reportLevel.equals("Sub Field")) {
            mysql = "SELECT sub_field_id, question FROM sub_fields WHERE (show = '1') AND (field_id = " + reportField + ")\n";
            mysql = mysql + "ORDER BY sub_field_order";
            BQuery fldrs = new BQuery(this.db, mysql);
            csvhtml.append("Form ID, Client");
            while (fldrs.moveNext()) {
                ans = fldrs.getString("question");
                csvhtml.append("," + this.csvFormat(fldrs.getString("question")));
                lstq.add(fldrs.getString("sub_field_id"));
            }
            csvhtml.append("\n");
            fldrs.close();
            mysql = "SELECT entry_form_id, entity_name FROM vw_entry_forms WHERE form_id = " + formid;
            mysql = mysql + " AND (approve_status = 'Completed') ";
            startDate = this.getConvDate(startDate);
            if (startDate != null) {
                mysql = mysql + " AND (completion_date >= '" + startDate + "')";
            }
            if ((endDate = this.getConvDate(endDate)) != null) {
                mysql = mysql + " AND (completion_date <= '" + endDate + "')";
            }
            mysql = mysql + " ORDER BY completion_date";
            BQuery rsa = new BQuery(this.db, mysql);
            while (rsa.moveNext()) {
                int i = 1;
                while (i > 0) {
                    boolean fd = true;
                    for (String stq : lstq) {
                        mysql = "SELECT entry_sub_fields.answer FROM entry_sub_fields INNER JOIN sub_fields ";
                        mysql = mysql + "ON entry_sub_fields.sub_field_id = sub_fields.sub_field_id";
                        mysql = mysql + " WHERE (sub_fields.field_id = " + reportField + ") ";
                        mysql = mysql + " AND (entry_sub_fields.entry_form_id = " + rsa.getString("entry_form_id") + ") ";
                        mysql = mysql + " AND (entry_sub_fields.sub_field_id = " + stq + ") ";
                        ans = this.db.executeFunction(mysql = mysql + " AND (entry_sub_fields.answer_line = " + Integer.toString(i) + ")");
                        if (ans == null) {
                            i = -1;
                            ans = "";
                            continue;
                        }
                        if (fd) {
                            csvhtml.append(this.csvFormat(rsa.getString("entry_form_id")));
                            csvhtml.append("," + this.csvFormat(rsa.getString("entity_name")));
                            fd = false;
                        }
                        csvhtml.append("," + this.csvFormat(ans));
                    }
                    if (i <= 0) continue;
                    csvhtml.append("\n");
                    ++i;
                }
            }
        }
        response.setContentType("text/x-csv");
        response.setHeader("Content-Disposition", "attachment; filename=report.csv");
        try {
            PrintWriter hpw = response.getWriter();
            hpw.println(csvhtml.toString());
            hpw.close();
        }
        catch (IOException ex) {
            this.log.severe("IO Error : " + ex);
        }
    }

    public String csvFormat(String lans) {
        String ans = "";
        if (lans != null) {
            ans = lans.indexOf(",") >= 0 ? "\"" + lans + "\"" : lans;
        }
        return ans;
    }

    public String getConvDate(String mydate) {
        String ans = null;
        if (mydate != null && mydate.length() > 7) {
            try {
                SimpleDateFormat dp1 = new SimpleDateFormat("dd/MM/yyyy");
                SimpleDateFormat dp2 = new SimpleDateFormat("yyyy-MM-dd");
                ans = dp2.format(dp1.parse(mydate));
            }
            catch (ParseException ex) {
                this.log.severe("Date format error");
            }
        }
        return ans;
    }

    public String saveTable(String formid, String entryformid) {
        String dbErr = null;
        String mysql = "SELECT table_name FROM forms WHERE form_id = " + formid;
        String tableName = this.db.executeFunction(mysql);
        if (tableName != null) {
            mysql = "SELECT field_name, field_id, field_fnct FROM fields WHERE form_id = " + formid;
            mysql = mysql + " ORDER BY field_order, field_id;";
            BQuery rs = new BQuery(this.db, mysql);
            mysql = "INSERT INTO " + tableName + " (entry_form_id";
            String values = ") VALUES (" + entryformid;
            while (rs.moveNext()) {
                String fieldName = rs.getString("field_name");
                String fieldFnct = rs.getString("field_fnct");
                String ans = this.answers.get("F" + rs.getString("field_id"));
                String ansa = "'" + ans + "'";
                if (ans == null) {
                    ansa = "null";
                    ans = "";
                }
                if (fieldFnct != null && ans != null) {
                    ansa = fieldFnct.replace("#", ans);
                }
                if (fieldName == null || ans.equals("")) continue;
                mysql = mysql + ", " + fieldName;
                values = values + ", " + ansa;
            }
            mysql = mysql + values + ")";
            dbErr = this.db.executeQuery(mysql);
            System.out.println("\n\nBASE 1010 : " + mysql);
        }
        return dbErr;
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
        }
    }
}

