/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.baraza.DB.BJSONQuery;
import org.baraza.web.BWeb;
import org.baraza.xml.BElement;

public class BJSONData
extends HttpServlet {
    Logger log = Logger.getLogger(BJSONData.class.getName());

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String pageNum;
        ServletContext context = this.getServletContext();
        HttpSession webSession = request.getSession(true);
        String xmlCnf = request.getParameter("xml");
        if (xmlCnf == null) {
            xmlCnf = (String)webSession.getAttribute("xmlcnf");
        }
        String ps = System.getProperty("file.separator");
        String xmlfile = context.getRealPath("WEB-INF") + ps + "configs" + ps + xmlCnf;
        String dbconfig = "java:/comp/env/jdbc/database";
        String projectDir = context.getInitParameter("projectDir");
        if (projectDir != null) {
            xmlfile = projectDir + ps + "configs" + ps + xmlCnf;
        }
        BWeb web = new BWeb(dbconfig, xmlfile, context);
        web.init(request);
        BElement view = web.getView();
        String sortSN = "S" + web.getViewKey();
        String sortBy = request.getParameter("sidx");
        if (sortBy != null && sortBy.trim().equals("")) {
            sortBy = null;
        }
        if (sortBy != null) {
            sortBy = sortBy.equals("CL") ? view.getAttribute("keyfield") + "  " + request.getParameter("sord") : sortBy + "  " + request.getParameter("sord");
            webSession.setAttribute(sortSN, (Object)sortBy);
        } else if (webSession.getAttribute(sortSN) != null) {
            sortBy = (String)webSession.getAttribute(sortSN);
        }
        Map<String, String> whereParams = web.getWhere(request);
        String whereSql = whereParams.get("wheresql");
        String linkData = request.getParameter("linkdata");
        if (view.getAttribute("linkfield") != null && linkData != null) {
            whereSql = whereSql == null ? "(" + view.getAttribute("linkfield") + " = '" + linkData + "')" : whereSql + " AND (" + view.getAttribute("linkfield") + " = '" + linkData + "')";
        }
        if ((pageNum = request.getParameter("page")) == null) {
            pageNum = "0";
        }
        Integer pageStart = new Integer(0);
        Integer pageSize = new Integer(0);
        try {
            pageSize = request.getParameter("rows") == null ? new Integer(30) : new Integer(request.getParameter("rows"));
            pageStart = new Integer(pageNum) * pageSize;
        }
        catch (NumberFormatException ex) {
            this.log.severe("Page size error " + ex);
        }
        if (view.getAttribute("superuser", "false").equals("true") && !web.getUser().getSuperUser()) {
            return;
        }
        boolean secured = true;
        String rUrl = request.getRequestURI();
        if (rUrl == null) {
            rUrl = "";
        }
        if (rUrl.contains("jsongeneral")) {
            String gWhere;
            if (!view.getAttribute("secured", "false").equals("true")) {
                secured = false;
            }
            if ((gWhere = request.getParameter("where")) != null) {
                whereSql = whereSql == null ? gWhere : whereSql + " AND " + gWhere;
            }
        }
        BJSONQuery JSONQuery = new BJSONQuery(web.getDB(), view, whereSql, sortBy, pageStart, pageSize);
        String JSONStr = "";
        if (secured) {
            JSONStr = JSONQuery.getJSONData(web.getViewKey(), false);
        }
        try {
            PrintWriter out = response.getWriter();
            response.setContentType("application/json;charset=\"utf-8\"");
            out.print(JSONStr);
        }
        catch (IOException ex) {
            System.out.println("ERROR : Cannot get writer from response : " + ex);
        }
        web.close();
    }
}

