/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.baraza.DB.BDB;
import org.baraza.utils.BWebdav;

public class BWebPictures
extends HttpServlet {
    BDB db = null;
    BWebdav webdav = null;
    String photo_access;

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String dbconfig = "java:/comp/env/jdbc/database";
        this.db = new BDB(dbconfig);
        ServletContext config = this.getServletContext();
        this.photo_access = config.getInitParameter("photo_access");
        if (this.photo_access == null) {
            this.photo_access = "";
        }
        String repository = config.getInitParameter("repository_url");
        String username = config.getInitParameter("rep_username");
        String password = config.getInitParameter("rep_password");
        System.out.println("repository : " + repository);
        this.webdav = new BWebdav(repository, username, password);
        String sp = request.getServletPath();
        if (sp.equals("/barazapictures")) {
            this.showPhoto(request, response);
        }
        if (sp.equals("/delbarazapictures")) {
            this.delPhoto(request, response);
        }
        this.db.close();
    }

    public void showPhoto(HttpServletRequest request, HttpServletResponse response) {
        String pictureFile = request.getParameter("picture");
        String access = request.getParameter("access");
        InputStream in = this.webdav.getFile(pictureFile);
        int dot = pictureFile.lastIndexOf(".");
        String ext = pictureFile.substring(dot + 1);
        if (this.photo_access.equals(access) && in != null) {
            try {
                response.setContentType("image/" + ext);
                ServletOutputStream out = response.getOutputStream();
                int bufferSize = 1024;
                byte[] buffer = new byte[bufferSize];
                int c = 0;
                while ((c = in.read(buffer)) != -1) {
                    out.write(buffer, 0, c);
                }
                in.close();
                out.flush();
            }
            catch (IOException ex) {
                System.out.println("IO Error : " + ex);
            }
        }
    }

    public void delPhoto(HttpServletRequest request, HttpServletResponse response) {
        String pictureFile = request.getParameter("picture");
        String access = request.getParameter("access");
        if (this.photo_access.equals(access)) {
            this.webdav.delFile(pictureFile);
        }
    }
}

