/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BElement {
    Map<String, String> attributes;
    List<BElement> elements;
    String[] deskTypes = new String[]{"ACCORDION", "CROSSTAB", "DASHBOARD", "DIARY", "FILES", "FILTER", "FORM", "FORMVIEW", "GRID", "JASPER", "TABLEVIEW"};
    int type = 0;
    String name = "";
    String value = "";

    public BElement(String nodeName) {
        this.type = 1;
        this.name = nodeName;
        this.attributes = new HashMap<String, String>();
        this.elements = new ArrayList<BElement>();
    }

    public BElement(Node node) {
        this.type = node.getNodeType();
        this.name = node.getNodeName();
        this.attributes = new HashMap<String, String>();
        if (node.hasAttributes()) {
            this.setAttibutes(node);
        }
        this.elements = new ArrayList<BElement>();
        if (node.hasChildNodes()) {
            this.setNodes(node.getChildNodes());
        }
    }

    public void setNodes(NodeList elementlist) {
        block4: for (int i = 0; i < elementlist.getLength(); ++i) {
            switch (elementlist.item(i).getNodeType()) {
                case 3: {
                    if (elementlist.item(i).getNodeValue() == null) continue block4;
                    this.value = this.value + elementlist.item(i).getNodeValue().trim();
                    continue block4;
                }
                case 4: {
                    if (elementlist.item(i).getNodeValue() == null) continue block4;
                    this.value = this.value + elementlist.item(i).getNodeValue().trim();
                    continue block4;
                }
                default: {
                    this.elements.add(new BElement(elementlist.item(i)));
                }
            }
        }
    }

    public void setAttibutes(Node node) {
        NamedNodeMap attmap = node.getAttributes();
        for (int i = 0; i < attmap.getLength(); ++i) {
            this.attributes.put(attmap.item(i).getNodeName(), attmap.item(i).getNodeValue());
        }
    }

    public BElement getElement(int index) {
        if (this.elements.size() > index) {
            return this.elements.get(index);
        }
        return null;
    }

    public BElement getElement(String nodeValue) {
        for (BElement el : this.elements) {
            if (!el.getValue().equals(nodeValue)) continue;
            return el;
        }
        return null;
    }

    public BElement getElementByName(String nodeName) {
        for (BElement el : this.elements) {
            if (!el.getName().equals(nodeName)) continue;
            return el;
        }
        return null;
    }

    public BElement getElementByKey(String keyValue) {
        for (BElement el : this.elements) {
            if (!el.getAttribute("key", "").equals(keyValue)) continue;
            return el;
        }
        return null;
    }

    public BElement getSub(int subNo) {
        Object subel = null;
        int i = 0;
        for (BElement sub : this.elements) {
            if (Arrays.binarySearch(this.deskTypes, sub.getName()) < 0) continue;
            if (i == subNo) {
                return sub;
            }
            ++i;
        }
        return null;
    }

    public int elementIndex(BElement element) {
        return this.elements.indexOf(element);
    }

    public BElement getFirst() {
        return this.getElement(0);
    }

    public List<BElement> getElements() {
        return this.elements;
    }

    public int getNodeNumber() {
        return this.elements.size();
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nodeName) {
        this.name = nodeName;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String nval) {
        if (this.value != null) {
            nval = this.value;
        }
        return nval;
    }

    public void setValue(String nodeValue) {
        this.value = nodeValue;
    }

    public int getSize() {
        return this.attributes.size();
    }

    public int getNodeSize() {
        return this.elements.size();
    }

    public boolean isLeaf() {
        boolean isl = true;
        if (this.elements.size() > 0) {
            isl = false;
        }
        return isl;
    }

    public String getValueAt(int aRow, int aCol) {
        String mystr = "";
        if (aRow == 0) {
            mystr = aCol == 0 ? this.name : this.value;
        } else {
            ArrayList<String> ml = new ArrayList<String>(this.attributes.keySet());
            mystr = (String)ml.get(aRow - 1);
            if (aCol == 1) {
                mystr = this.attributes.get(mystr);
            }
        }
        return mystr;
    }

    public void setValueAt(String cellValue, int aRow, int aCol) {
        if (aRow == 0) {
            if (aCol == 0) {
                this.name = cellValue;
            } else {
                this.value = cellValue;
            }
        } else {
            ArrayList<String> ml = new ArrayList<String>(this.attributes.keySet());
            String ky = (String)ml.get(aRow - 1);
            if (aCol == 0) {
                String kvl = this.attributes.get(ky);
                this.attributes.remove(ky);
                this.attributes.put(cellValue, kvl);
            } else {
                this.attributes.put(ky, cellValue);
            }
        }
    }

    public void insertAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String attributeName) {
        return this.attributes.get(attributeName);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        String mystr = this.attributes.get(attributeName);
        if (mystr == null) {
            mystr = defaultValue;
        }
        return mystr;
    }

    public void replaceAttribute(String oldAttribute, String newAttribute) {
        if (this.getAttribute(oldAttribute) != null) {
            this.setAttribute(newAttribute, this.getAttribute(oldAttribute));
            this.delAttribute(oldAttribute);
        }
    }

    public void setAttribute(String attributeName, String attributeValue) {
        if (attributeName != null) {
            if (attributeValue != null) {
                this.attributes.put(attributeName, attributeValue);
            } else {
                this.attributes.remove(attributeName);
            }
        }
    }

    public void delAttribute(String attributeName) {
        if (attributeName != null) {
            this.attributes.remove(attributeName);
        }
    }

    public void addNode(BElement newNode) {
        this.elements.add(newNode);
    }

    public void addNode(BElement newNode, int nodePos) {
        this.elements.add(nodePos, newNode);
    }

    public void delNode(BElement oldNode) {
        this.elements.remove(oldNode);
    }

    public void clearNodes() {
        this.elements.clear();
    }

    public void delNode(int nodePos) {
        this.elements.remove(nodePos);
    }

    public String getString() {
        String mystr = "<" + this.name;
        for (String key : this.attributes.keySet()) {
            mystr = mystr + " " + key + "=\"" + this.attributes.get(key).replaceAll("<", "&lt;") + "\"";
        }
        mystr = mystr + ">" + this.value;
        if (this.elements.size() > 0) {
            mystr = mystr + "\n";
        }
        for (BElement element : this.elements) {
            mystr = mystr + this.indentStr(element.getString());
        }
        mystr = mystr + "</" + this.name + ">\n";
        return mystr;
    }

    public String toString() {
        return this.getString();
    }

    public String indentStr(String mystr) {
        String[] mylines = mystr.split("\n");
        mystr = "";
        for (String myline : mylines) {
            mystr = mystr + "\t" + myline + "\n";
        }
        return mystr;
    }

    public BElement copy() {
        BElement newEl = new BElement(new String(this.name));
        newEl.setValue(new String(this.value));
        newEl.setType(this.type);
        for (String key : this.attributes.keySet()) {
            newEl.setAttribute(new String(key), new String(this.attributes.get(key)));
        }
        for (BElement element : this.elements) {
            newEl.addNode(element.copy());
        }
        return newEl;
    }
}

