/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class BCrossSet {
    Map<String, Integer> columns = new HashMap<String, Integer>();
    Map<String, Integer> rows = new HashMap<String, Integer>();
    Map<Integer, Object> setTable = new HashMap<Integer, Object>();

    public BCrossSet(Vector<Vector<Object>> dataTable) {
        int j = 0;
        for (Vector<Object> data : dataTable) {
            String col0 = "";
            if (data.get(0) != null) {
                col0 = data.get(0).toString();
            }
            String col1 = "";
            if (data.get(1) != null) {
                col1 = data.get(1).toString();
            }
            String col2 = "";
            if (data.get(2) != null) {
                col2 = data.get(2).toString();
            }
            ++j;
            Integer column = this.columns.size();
            if (!this.columns.containsKey(col0)) {
                this.columns.put(col0, column);
            }
            column = this.columns.get(col0);
            Integer row = this.rows.size();
            if (!this.rows.containsKey(col1)) {
                this.rows.put(col1, row);
            }
            row = this.rows.get(col1);
            this.setTable.put(row * 64 + column, col2);
        }
    }

    public Vector<Object> getRowData(String key) {
        Vector<Object> data = new Vector<Object>();
        Integer row = this.rows.get(key);
        if (row == null) {
            for (String colKey : this.columns.keySet()) {
                data.add(null);
            }
        } else {
            for (String colKey : this.columns.keySet()) {
                Integer column = this.columns.get(colKey);
                Object cellData = this.setTable.get(row * 64 + column);
                data.add(cellData);
            }
        }
        return data;
    }

    public String getColTitles() {
        StringBuffer myhtml = new StringBuffer();
        for (String colKey : this.columns.keySet()) {
            myhtml.append("<th>" + colKey + "</th>");
        }
        return myhtml.toString();
    }

    public String getRowHtml(Object key) {
        Integer row;
        StringBuffer myhtml = new StringBuffer();
        String sKey = "";
        if (key != null) {
            sKey = key.toString();
        }
        if ((row = this.rows.get(key)) == null) {
            for (String colKey : this.columns.keySet()) {
                myhtml.append("<td></td>");
            }
        } else {
            for (String colKey : this.columns.keySet()) {
                Integer column = this.columns.get(colKey);
                Object cellData = this.setTable.get(row * 64 + column);
                if (cellData == null) {
                    myhtml.append("<td></td>");
                    continue;
                }
                myhtml.append("<td>" + cellData.toString() + "</td>");
            }
        }
        return myhtml.toString();
    }

    public String getCsvTitles() {
        StringBuffer myCsv = new StringBuffer();
        for (String colKey : this.columns.keySet()) {
            myCsv.append("," + this.getCsvValue(colKey));
        }
        return myCsv.toString();
    }

    public String getRowCsv(Object key) {
        Integer row;
        StringBuffer myCsv = new StringBuffer();
        String sKey = "";
        if (key != null) {
            sKey = key.toString();
        }
        if ((row = this.rows.get(key)) == null) {
            for (String colKey : this.columns.keySet()) {
                myCsv.append(",");
            }
        } else {
            for (String colKey : this.columns.keySet()) {
                Integer column = this.columns.get(colKey);
                myCsv.append("," + this.getCsvValue(this.setTable.get(row * 64 + column)));
            }
        }
        return myCsv.toString();
    }

    public Map<String, Integer> getColumns() {
        return this.columns;
    }

    public Map<String, Integer> getRows() {
        return this.rows;
    }

    public String getCsvValue(Object cellVal) {
        String mystr = "";
        if (cellVal != null) {
            mystr = cellVal.toString().startsWith("0") ? "\"'" + cellVal.toString() + "\"" : "\"" + cellVal.toString() + "\"";
        }
        return mystr;
    }
}

