/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.DB.BTableLinks;
import org.baraza.xml.BElement;

public class BTableModel
extends AbstractTableModel {
    BQuery query;
    boolean editCell = false;

    public BTableModel() {
        this.query = new BQuery();
        this.editCell = true;
    }

    public BTableModel(String[] titleArray) {
        this.query = new BQuery(titleArray);
        this.refresh();
        this.editCell = true;
    }

    public BTableModel(BDB db, BElement desk) {
        this.query = new BQuery(db, desk, null, null);
    }

    public BTableModel(BDB db, BElement desk, String wherefilter) {
        this.query = new BQuery(db, desk, wherefilter, null);
    }

    public BTableModel(BDB db, String mysql, int limit) {
        this.query = new BQuery(db, mysql, limit);
        this.query.readData(limit);
    }

    public BTableModel(BDB db, String myfields, String tablename, int limit) {
        this.query = new BQuery(db, myfields, tablename, limit);
        this.query.readData(limit);
    }

    public void setQuery(BQuery query) {
        this.query = query;
        this.fireTableChanged(null);
    }

    @Override
    public boolean isCellEditable(int aRow, int aCol) {
        this.editCell = false;
        if (this.query.getColumnEdits().size() > aCol) {
            this.editCell = this.query.getColumnEdits().get(aCol);
        }
        return this.editCell;
    }

    @Override
    public void setValueAt(Object value, int aRow, int aCol) {
        this.query.setValueAt(value, aRow, aCol);
        this.fireTableCellUpdated(aRow, aCol);
    }

    public void removeRow(int aRow) {
        this.query.removeRow(aRow);
        this.refresh();
    }

    public void refresh() {
        this.fireTableChanged(null);
    }

    public void requery() {
        this.query.refresh();
        this.query.readData();
        this.refresh();
    }

    public void filter(String wheresql, String orderby) {
        this.query.filter(wheresql, orderby);
        this.query.readData();
        this.refresh();
    }

    public void clear() {
        this.query.clear();
        this.refresh();
    }

    @Override
    public int getColumnCount() {
        return this.query.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.query.getRowCount();
    }

    @Override
    public String getColumnName(int aCol) {
        return this.query.getColumnName(aCol);
    }

    public String getFieldName(int aCol) {
        return this.query.getFieldName(aCol);
    }

    public Vector<String> getColumnNames() {
        return this.query.getColumnNames();
    }

    @Override
    public Object getValueAt(int aRow, int aCol) {
        return this.query.getValueAt(aRow, aCol);
    }

    public Class getColumnClass(int aCol) {
        return this.query.getColumnClass(aCol);
    }

    public Vector<String> getKeyFieldData() {
        return this.query.getKeyFieldData();
    }

    public boolean movePos(int pos) {
        return this.query.movePos(pos);
    }

    public String getKeyField() {
        return this.query.getKeyField();
    }

    public String getKeyFieldName() {
        return this.query.getKeyFieldName();
    }

    public String readField(String fieldName) {
        return this.query.readField(fieldName);
    }

    public int insertRow() {
        return this.query.insertRow();
    }

    public int insertRow(Vector<Object> dataRow) {
        return this.query.insertRow(dataRow);
    }

    public List<String> getFields() {
        return this.query.getFields();
    }

    public String getViewSQL() {
        return this.query.getViewSQL();
    }

    public BElement getDeskConfig(int cfg) {
        return this.query.getDeskConfig(cfg);
    }

    public BElement getGridConfig() {
        return this.query.getGridConfig();
    }

    public BElement getTableConfig() {
        return this.query.getTableConfig();
    }

    public List<BTableLinks> getLinks() {
        return this.query.getLinks();
    }

    public List<BTableLinks> getLinks(List<String> linkTables) {
        return this.query.getLinks(linkTables);
    }

    public void importData(Vector<Vector<Object>> newData) {
        this.query.importData(newData);
    }

    public String readDocument(boolean heading, boolean trim) {
        return this.query.readDocument(heading, trim);
    }

    public void recDelete() {
        this.query.recDelete();
    }

    public void recAudit(String changetype, String recordid) {
        this.query.recAudit(changetype, recordid);
    }

    public String getTableName() {
        return this.query.getTableName();
    }

    public void setTitles(String[] titleArray) {
        this.query.setTitles(titleArray);
    }

    public void savecvs(String filename) {
        this.query.savecvs(filename);
    }

    public Map<String, String> getParams() {
        return this.query.getParams();
    }

    public BQuery getQuery() {
        return this.query;
    }
}

