/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import org.baraza.DB.BDB;
import org.baraza.app.BAbout;
import org.baraza.app.BDesk;
import org.baraza.app.BPasswordChange;
import org.baraza.swing.BCellRenderer;
import org.baraza.swing.BImageDesktop;
import org.baraza.swing.BImagePanel;
import org.baraza.swing.BImageTree;
import org.baraza.utils.BDesEncrypter;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;
import org.baraza.xml.BTreeNode;
import org.baraza.xml.BXML;

public class BApp
extends JPanel
implements ActionListener,
TreeSelectionListener {
    Logger log = Logger.getLogger(BApp.class.getName());
    BLogHandle logHandle;
    BDB db;
    BElement projectsList;
    BElement root;
    BElement dKey = null;
    BImageTree tree;
    BAbout about;
    BPasswordChange passwordChange;
    BTreeNode top = null;
    BImagePanel imagePanel;
    JPanel loginPanel;
    JDesktopPane desktop;
    JSplitPane splitPane;
    Map<BElement, BDesk> desks;
    DefaultTreeModel treemodel;
    String reportDir;
    String configDir;
    String configFile;
    String dbpath;
    List<Integer> elementList;
    JMenuBar menuBar;
    JMenu fileMenu;
    JMenuItem menuItem;
    JLabel lPrograms;
    JLabel lUserName;
    JLabel lPassword;
    JLabel clearStatus;
    JLabel loginStatus;
    JComboBox<String> cmbPrograms;
    JTextField tfUserName;
    JPasswordField pwPassword;
    JButton btClear;
    JButton btOkay;
    JScrollPane treeScroll;

    public BApp(String configDir, String configXmlFile, String dbpath, String encryptionKey) {
        super(new BorderLayout());
        super.setOpaque(false);
        this.dbpath = dbpath;
        this.configDir = configDir;
        BXML xml = null;
        if (encryptionKey == null) {
            xml = new BXML(configDir + configXmlFile, false);
        } else {
            configXmlFile = configXmlFile.substring(0, configXmlFile.length() - 3) + "cph";
            BDesEncrypter decrypter = new BDesEncrypter(encryptionKey);
            InputStream inXml = decrypter.decrypt(configDir + configXmlFile);
            xml = new BXML(inXml);
        }
        this.projectsList = xml.getRoot();
        this.logHandle = new BLogHandle();
        this.logHandle.setLogLevel(this.projectsList);
        this.logHandle.config(this.log);
        this.imagePanel = new BImagePanel("/org/baraza/resources/background.jpg");
        this.loginPanel = new JPanel(new GridLayout(0, 2, 2, 2));
        this.loginPanel.setOpaque(false);
        this.imagePanel.add(this.loginPanel);
        this.loginPanel.setLocation(250, 200);
        this.loginPanel.setSize(400, 120);
        this.lPrograms = new JLabel("Project : ");
        this.cmbPrograms = new JComboBox();
        this.loginPanel.add(this.lPrograms);
        this.loginPanel.add(this.cmbPrograms);
        this.lUserName = new JLabel("User Name : ");
        this.tfUserName = new JTextField(25);
        this.loginPanel.add(this.lUserName);
        this.loginPanel.add(this.tfUserName);
        this.lPassword = new JLabel("Password : ");
        this.pwPassword = new JPasswordField();
        this.pwPassword.setActionCommand("Login");
        this.pwPassword.addActionListener(this);
        this.loginPanel.add(this.lPassword);
        this.loginPanel.add(this.pwPassword);
        this.btClear = new JButton("Clear");
        this.btClear.addActionListener(this);
        this.btOkay = new JButton("Login");
        this.btOkay.addActionListener(this);
        this.loginPanel.add(this.btClear);
        this.loginPanel.add(this.btOkay);
        this.clearStatus = new JLabel();
        this.loginStatus = new JLabel();
        this.loginPanel.add(this.clearStatus);
        this.loginPanel.add(this.loginStatus);
        this.elementList = new ArrayList<Integer>();
        int i = 0;
        for (BElement el : this.projectsList.getElements()) {
            if (el.getName().equals("APP")) {
                this.cmbPrograms.addItem(el.getValue());
                this.elementList.add(i);
            }
            ++i;
        }
        super.add((Component)this.imagePanel, "Center");
        this.log.info("INFO DESK : SYSTEM STARTED");
    }

    public void login() {
        this.desks = new HashMap<BElement, BDesk>();
        BElement el = this.root.getFirst();
        this.top = this.makeMenu(el);
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        if (this.root.getAttribute("password") != null) {
            this.passwordChange = new BPasswordChange(this.db, this.root);
            this.menuItem = new JMenuItem("Change Password");
            this.menuItem.addActionListener(this);
            this.fileMenu.add(this.menuItem);
        }
        this.about = new BAbout("Open Baraza");
        this.menuItem = new JMenuItem("About ...");
        this.menuItem.addActionListener(this);
        this.fileMenu.add(this.menuItem);
        this.menuBar.add(this.fileMenu);
        super.add((Component)this.menuBar, "First");
        this.treemodel = new DefaultTreeModel(this.top);
        this.tree = new BImageTree("/org/baraza/resources/leftpanel.jpg", this.treemodel, false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new BCellRenderer());
        this.tree.addTreeSelectionListener(this);
        this.treeScroll = new JScrollPane(this.tree);
        this.desktop = new BImageDesktop("/org/baraza/resources/background.jpg");
        this.splitPane = new JSplitPane(1, this.treeScroll, this.desktop);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(200);
        this.imagePanel.setVisible(false);
        super.remove(this.imagePanel);
        super.add((Component)this.splitPane, "Center");
        super.add((Component)this.logHandle.getStatusBar(), "Last");
        super.repaint();
    }

    public BTreeNode makeMenu(BElement sbn) {
        BTreeNode firstNode = new BTreeNode(this.root.getElementByKey(sbn.getValue()), sbn.getAttribute("name"));
        for (BElement el : sbn.getElements()) {
            boolean access = false;
            if (el.getAttribute("role") == null) {
                access = true;
            } else {
                String[] mRoles;
                for (String mRole : mRoles = el.getAttribute("role").split(",")) {
                    if (this.db.getGroupRoles().contains(mRole.trim())) {
                        access = true;
                    }
                    if (this.db.getUserRoles().contains(mRole.trim())) {
                        access = true;
                    }
                    if (!this.db.getSuperUser()) continue;
                    access = true;
                }
            }
            if (el.getAttribute("xml") != null) {
                access = false;
            }
            if (!access) continue;
            firstNode.add(this.makeMenu(el));
        }
        return firstNode;
    }

    @Override
    public void valueChanged(TreeSelectionEvent ev) {
        BTreeNode node = (BTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            this.dKey = node.getKey();
            if (node.isLeaf() && this.dKey != null) {
                if (this.desks.get(this.dKey) == null) {
                    this.desks.put(this.dKey, new BDesk(this.logHandle, this.db, this.dKey, this.reportDir));
                }
                if (!this.desks.get(this.dKey).isVisible()) {
                    this.desks.get(this.dKey).setVisible(true);
                    this.desktop.add(this.desks.get(this.dKey));
                    try {
                        this.desks.get(this.dKey).setSelected(true);
                    }
                    catch (PropertyVetoException ex) {
                        System.out.println("Desktop show error : " + ex);
                    }
                } else {
                    try {
                        this.desks.get(this.dKey).setSelected(true);
                        if (this.desks.get(this.dKey).isIcon()) {
                            this.desks.get(this.dKey).setIcon(false);
                        }
                    }
                    catch (PropertyVetoException ex) {
                        System.out.println("Desktop show error : " + ex);
                    }
                }
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if ("Clear".equals(aKey)) {
            this.tfUserName.setText("");
            this.pwPassword.setText("");
        } else if ("Login".equals(aKey)) {
            int elemenrtPos = this.elementList.get(this.cmbPrograms.getSelectedIndex());
            BElement prog = this.projectsList.getElement(elemenrtPos);
            String ps = System.getProperty("file.separator");
            if (this.configDir.startsWith("http")) {
                ps = "/";
            }
            this.configFile = this.configDir + prog.getAttribute("path") + ps + "configs" + ps + prog.getAttribute("xmlfile");
            this.reportDir = prog.getAttribute("reports");
            if (this.reportDir == null) {
                this.reportDir = this.configDir + prog.getAttribute("path") + ps + "reports" + ps;
            }
            BXML xml = new BXML(this.configFile, false);
            boolean noauth = false;
            String auth = prog.getAttribute("auth", "db");
            String mypassword = new String(this.pwPassword.getPassword());
            if (this.dbpath != null && prog.getAttribute("fixed") == null) {
                prog.setAttribute("dbpath", this.dbpath);
            }
            if (auth.equals("db")) {
                this.db = new BDB(prog, this.tfUserName.getText(), mypassword);
                if (this.db.getDB() == null) {
                    noauth = true;
                }
            }
            if (auth.equals("entity")) {
                this.db = new BDB(prog);
                String mysql = "SELECT entity_id FROM entitys WHERE (User_name = '" + this.tfUserName.getText() + "')";
                mysql = mysql + " AND (Entity_password = md5('" + mypassword + "'))";
                mysql = mysql + " AND (is_active = true)";
                if (this.db.getDB() == null) {
                    noauth = true;
                } else if (this.db.executeFunction(mysql) == null) {
                    noauth = true;
                }
            }
            if (noauth) {
                this.clearStatus.setText("Login error");
                this.loginStatus.setText("Invalid credentials");
            } else if (xml.getDocument() == null) {
                this.loginStatus.setText("XML loading file error");
            } else {
                BElement audit;
                this.root = xml.getRoot();
                String ipaddress = "";
                try {
                    InetAddress i = InetAddress.getLocalHost();
                    ipaddress = i.toString();
                }
                catch (UnknownHostException i) {
                    // empty catch block
                }
                this.db.setUser(ipaddress, this.tfUserName.getText(), "App");
                BElement configs = this.root.getElementByName("CONFIGS");
                if (configs != null && (audit = configs.getElementByName("AUDIT")) != null) {
                    this.db.setFullAudit(audit);
                }
                this.login();
            }
        } else if ("About ...".equals(aKey)) {
            if (!this.about.isVisible()) {
                this.about.setVisible(true);
                this.desktop.add(this.about);
                try {
                    this.about.setSelected(true);
                }
                catch (PropertyVetoException ex) {
                    System.out.println("Desktop show error : " + ex);
                }
            }
        } else if ("Change Password".equals(aKey) && !this.passwordChange.isVisible()) {
            this.passwordChange.setVisible(true);
            this.desktop.add(this.passwordChange);
            try {
                this.passwordChange.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                System.out.println("Desktop show error : " + ex);
            }
        }
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
        }
    }
}

