/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.JTabbedPane;
import org.baraza.DB.BDB;
import org.baraza.app.BFilter;
import org.baraza.app.BForm;
import org.baraza.app.BGrids;
import org.baraza.app.BTabs;
import org.baraza.reports.BReport;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BDesk
extends JInternalFrame
implements MouseListener {
    Logger log = Logger.getLogger(BDesk.class.getName());
    BLogHandle logHandle;
    String name;
    String key;
    int w;
    int h;
    List<BGrids> grids;
    List<BReport> reports;
    List<BForm> forms;
    List<BFilter> filters;
    List<BTabs> tabs;
    JTabbedPane tabbedPane;

    public BDesk(BLogHandle logHandle, BDB db, BElement desk, String reportDir) {
        super(desk.getAttribute("name"), true, true, true, true);
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.name = desk.getAttribute("name");
        this.key = desk.getAttribute("key");
        this.w = Integer.valueOf(desk.getAttribute("w"));
        this.h = Integer.valueOf(desk.getAttribute("h"));
        this.tabbedPane = new JTabbedPane();
        this.grids = new ArrayList<BGrids>();
        this.reports = new ArrayList<BReport>();
        this.forms = new ArrayList<BForm>();
        this.filters = new ArrayList<BFilter>();
        this.tabs = new ArrayList<BTabs>();
        for (BElement el : desk.getElements()) {
            if (el.getName().equals("FORM")) {
                this.forms.add(new BForm(logHandle, db, el));
                this.forms.get(this.forms.size() - 1).moveFirst();
                this.tabbedPane.addTab(el.getAttribute("name"), this.forms.get(this.forms.size() - 1));
                this.tabs.add(new BTabs(1, this.forms.size() - 1));
                continue;
            }
            if (el.getName().equals("GRID") || el.getName().equals("FORMVIEW")) {
                this.grids.add(new BGrids(logHandle, db, el, reportDir, false));
                this.tabbedPane.addTab(el.getAttribute("name"), this.grids.get(this.grids.size() - 1));
                this.tabs.add(new BTabs(2, this.grids.size() - 1));
                continue;
            }
            if (el.getName().equals("JASPER")) {
                this.reports.add(new BReport(logHandle, db, el, reportDir));
                this.tabbedPane.addTab(el.getAttribute("name"), this.reports.get(this.reports.size() - 1));
                this.reports.get(this.reports.size() - 1).showReport();
                this.tabs.add(new BTabs(3, this.reports.size() - 1));
                continue;
            }
            if (!el.getName().equals("FILTER")) continue;
            this.filters.add(new BFilter(logHandle, db, el, reportDir));
            this.tabbedPane.addTab(el.getAttribute("name"), this.filters.get(this.filters.size() - 1));
            this.tabs.add(new BTabs(4, this.filters.size() - 1));
        }
        this.add(this.tabbedPane);
        this.tabbedPane.addMouseListener(this);
        this.setSize();
    }

    public void setSize() {
        super.setLocation(10, 10);
        super.setSize(this.w, this.h);
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        int i = this.tabbedPane.getSelectedIndex();
        if (this.tabs.get(i).getType() == 2) {
            i = this.tabs.get(i).getIndex();
            this.grids.get(i).hideForms();
            this.grids.get(i).refresh();
        }
        if (this.tabs.get(i).getType() == 3) {
            int j = this.tabs.get(i).getIndex();
            this.reports.get(j).drillReport();
        }
    }
}

