/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.com;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Map;
import java.util.UUID;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.com.BLicense;
import org.baraza.utils.BNetwork;

public class BLicenseRegister
extends HttpServlet {
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter out = null;
        try {
            out = response.getWriter();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String resp = "";
        String dbconfig = "java:/comp/env/jdbc/database";
        BDB db = new BDB(dbconfig);
        if (db == null) {
            resp = "DB access error";
            out.println(resp);
            return;
        }
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String ce = (String)e.nextElement();
            System.out.println(ce + ":" + request.getParameter(ce));
        }
        String systemKey = request.getParameter("system_key");
        String orgName = request.getParameter("org_name");
        String sysKey = request.getParameter("sys_key");
        if (systemKey == null) {
            response.setContentType("application/json;charset=\"utf-8\"");
            resp = this.getLicense(db, request.getRemoteAddr(), request.getRemoteUser(), orgName, sysKey);
        } else {
            response.setContentType("text/html");
            resp = this.setLicense(db, systemKey, request);
        }
        out.println(resp);
        db.close();
    }

    private String setLicense(BDB db, String sysKey, HttpServletRequest request) {
        String resp = "";
        String holder = request.getParameter("org_name");
        String productKey = request.getParameter("system_identifier");
        String MachineID = request.getParameter("mac_address");
        String databaseID = request.getParameter("database_identifier");
        String mysql = "SELECT subscription_id, system_key, subscribed, subscribed_date FROM subscriptions WHERE (approve_status = 'Approved') AND (subscribed = false) AND (system_key = '" + sysKey + "')";
        BQuery rs = new BQuery(db, mysql);
        if (rs.moveFirst()) {
            BLicense license = new BLicense();
            resp = license.createLicense(holder, productKey, MachineID, databaseID);
            db.executeQuery("UPDATE subscriptions SET subscribed = true, subscribed_date = current_timestamp WHERE (system_key = '" + sysKey + "')");
        } else {
            resp = "ERROR";
        }
        rs.close();
        return resp;
    }

    private String getLicense(BDB db, String remoteAddr, String remoteUser, String orgName, String sysKey) {
        JsonObjectBuilder jshd = Json.createObjectBuilder();
        jshd.add("error", true);
        jshd.add("msg", "License regitration failed");
        if (orgName == null || sysKey == null || orgName.trim().length() < 2 || sysKey.trim().length() < 32) {
            jshd.add("error", true);
            jshd.add("msg", "You must enter a valid organization name and system key");
            JsonObject jsObj = jshd.build();
            return jsObj.toString();
        }
        try {
            db.executeQuery("UPDATE orgs SET system_key = '" + sysKey + "' WHERE org_id = 0");
            db.executeQuery("UPDATE orgs SET org_name = '" + orgName + "' WHERE org_id = 0");
            Map<String, String> params = db.readFields("org_name, system_key, system_identifier", "orgs WHERE org_id = 0");
            String sysID = params.get("system_identifier");
            if (sysID == null) {
                sysID = UUID.randomUUID().toString();
                db.executeQuery("UPDATE orgs SET system_identifier = '" + sysID + "' WHERE org_id = 0");
                params.put("system_identifier", sysID);
            }
            String dbName = db.getCatalogName();
            String dbID = db.executeFunction("SELECT datid FROM pg_stat_database WHERE datname = '" + dbName + "'");
            params.put("database_identifier", dbID);
            URL myURL = new URL("http://hcm.openbaraza.org/innerkonsult/registerlicense");
            InetAddress hostAddress = InetAddress.getByName(myURL.getHost());
            Socket soc = new Socket(hostAddress, 80);
            System.out.println("Connecting IP : " + soc.getLocalAddress().getHostAddress());
            BNetwork net = new BNetwork();
            String macAddr = net.getMACAddress(soc.getLocalAddress().getHostAddress());
            soc.close();
            if (macAddr == null) {
                return null;
            }
            db.executeQuery("UPDATE orgs SET mac_address = '" + macAddr + "' WHERE org_id = 0");
            params.put("mac_address", macAddr);
            String licStr = net.sendPost(myURL, params);
            if (licStr != null && this.saveLicense(db, licStr)) {
                jshd.add("error", false);
                jshd.add("msg", "Registred okay, refresh page");
            }
        }
        catch (MalformedURLException ex) {
            System.out.println("License Registration : " + ex);
        }
        catch (UnknownHostException ex) {
            System.out.println("License Registration : " + ex);
        }
        catch (IOException ex) {
            System.out.println("License Registration : " + ex);
        }
        JsonObject jsObj = jshd.build();
        return jsObj.toString();
    }

    private boolean saveLicense(BDB db, String licStr) {
        boolean isOkay = false;
        String[] lics = licStr.split("===================");
        if (lics.length == 2) {
            Base64 decd = new Base64();
            BQuery rs = new BQuery(db, "SELECT org_id, public_key, license FROM orgs WHERE org_id = 0");
            rs.moveFirst();
            rs.recEdit();
            rs.updateBytes("license", Base64.decodeBase64((String)lics[0]));
            rs.updateBytes("public_key", Base64.decodeBase64((String)lics[1]));
            rs.recSave();
            rs.close();
            isOkay = true;
        }
        return isOkay;
    }
}

