/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.ide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.baraza.DB.BDB;
import org.baraza.ide.BFileEdit;
import org.baraza.utils.BLogHandle;

public class BEdit
implements ActionListener {
    Logger log = Logger.getLogger(BEdit.class.getName());
    public JPanel panel;
    JPanel controls;
    JButton[] button;
    JTabbedPane tabFileView;
    List<BFileEdit> fileEdit;
    String dbDirName;
    BDB db;
    BLogHandle logHandle;

    public BEdit(String dbDirName, BDB db, BLogHandle logHandle) {
        this.db = db;
        this.dbDirName = dbDirName;
        this.panel = new JPanel(new BorderLayout());
        this.tabFileView = new JTabbedPane();
        this.panel.add((Component)this.tabFileView, "Center");
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.controls = new JPanel();
        String[] btArray = new String[]{"New", "Open", "Save", "Save As", "Close", "Execute", "Batch Execute", "Execute All", "Views", "Tables"};
        this.button = new JButton[btArray.length];
        for (int i = 0; i < btArray.length; ++i) {
            this.button[i] = new JButton(btArray[i]);
            this.button[i].addActionListener(this);
            this.controls.add(this.button[i]);
        }
        this.panel.add((Component)this.controls, "First");
        File dbDir = null;
        if (!dbDirName.startsWith("http")) {
            dbDir = new File(dbDirName);
        }
        if (dbDir != null && dbDir.exists()) {
            Object[] dbFiles = dbDir.listFiles();
            Arrays.sort(dbFiles);
            this.fileEdit = new ArrayList<BFileEdit>();
            for (int i = 0; i < dbFiles.length; ++i) {
                if (!((File)dbFiles[i]).isFile() || ((File)dbFiles[i]).getName().startsWith(".")) continue;
                this.fileEdit.add(new BFileEdit((File)dbFiles[i], logHandle));
                this.tabFileView.add(((File)dbFiles[i]).getName(), this.fileEdit.get((int)(this.fileEdit.size() - 1)).scrollPanes);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        int i = this.tabFileView.getSelectedIndex();
        if ("New".equals(aKey)) {
            this.fileEdit.add(new BFileEdit(this.dbDirName, this.logHandle));
            this.tabFileView.add("new.sql", this.fileEdit.get((int)(this.fileEdit.size() - 1)).scrollPanes);
        } else if ("Open".equals(aKey)) {
            JFileChooser fc = new JFileChooser(this.dbDirName);
            int j = fc.showOpenDialog(this.panel);
            if (j == 0) {
                this.fileEdit.add(new BFileEdit(fc.getSelectedFile(), this.logHandle));
                this.tabFileView.add(fc.getSelectedFile().getName(), this.fileEdit.get((int)(this.fileEdit.size() - 1)).scrollPanes);
            }
        } else if ("Save As".equals(aKey)) {
            this.fileEdit.get(i).saveAsFile();
            this.tabFileView.setTitleAt(i, this.fileEdit.get(i).getName());
        } else if ("Save".equals(aKey)) {
            this.fileEdit.get(i).saveFile();
            this.tabFileView.setTitleAt(i, this.fileEdit.get(i).getName());
        } else if ("Close".equals(aKey)) {
            this.tabFileView.remove(i);
            this.fileEdit.remove(i);
        } else if ("Execute".equals(aKey)) {
            this.log.info("Preparing Excecution...");
            String err = this.db.executeQuery(this.fileEdit.get(i).getText());
            if (err == null) {
                this.log.info("Excecuted Successfully");
            }
        } else if ("Batch Execute".equals(aKey)) {
            this.log.info("Preparing Excecution...");
            String err = this.db.executeBatch(this.fileEdit.get(i).getText());
            if (err == null) {
                this.log.info("Excecuted Successfully");
            }
        } else if ("Execute All".equals(aKey)) {
            this.executeAll();
            this.panel.revalidate();
            this.panel.repaint();
        } else if ("Views".equals(aKey)) {
            this.fileEdit.get(i).appendText(this.db.getViewSQL());
        } else if ("Tables".equals(aKey)) {
            this.fileEdit.get(i).appendText(this.getTables());
        }
    }

    public void executeAll() {
        String err = null;
        int i = 0;
        this.log.info("Preparing Excecution...");
        for (BFileEdit fe : this.fileEdit) {
            if (err == null) {
                err = this.db.executeQuery(fe.getText());
                this.tabFileView.setSelectedIndex(i);
                ++i;
            }
            if (err != null) continue;
            this.log.info("Excecuted Successfully");
        }
    }

    public String getTables() {
        String[] tbs;
        String tbn = "";
        int i = this.tabFileView.getSelectedIndex();
        for (String tb : tbs = this.fileEdit.get(i).getText().split("\n")) {
            if (!tb.trim().toUpperCase().startsWith("CREATE TABLE")) continue;
            tbn = tbn + "\n" + tb.replace("CREATE TABLE", "").replace("(", "").trim();
        }
        return tbn;
    }
}

