/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.ide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.baraza.DB.BDB;
import org.baraza.DB.BTableLinks;
import org.baraza.DB.BTableModel;
import org.baraza.ide.BTableViewer;
import org.baraza.reports.BCompileReport;
import org.baraza.reports.BReportMaker;
import org.baraza.swing.BImageDesktop;
import org.baraza.utils.BLogHandle;
import org.baraza.utils.Bio;

public class BQBuilder
extends JPanel
implements ActionListener,
MouseListener {
    Logger log = Logger.getLogger(BQBuilder.class.getName());
    BLogHandle logHandle;
    BDB db;
    JPanel controls;
    JPanel reportPanel;
    JPanel reportControls;
    JButton[] button;
    JSplitPane splitPane;
    JSplitPane mainPane;
    DefaultListModel<String> listModel;
    JList<String> tableList;
    BImageDesktop desktop;
    JTable table;
    JTable defTable;
    JTable joinTable;
    JTextArea sqlText;
    JTextArea xmlText;
    JTextArea reportText;
    JScrollPane scrollPane;
    JScrollPane defPane;
    JScrollPane joinPane;
    JScrollPane tablesPane;
    JScrollPane sqlPane;
    JScrollPane xmlPane;
    JScrollPane reportPane;
    JTabbedPane tabbedPane;
    Map<String, BTableViewer> tableViews;
    BTableModel tableModel = null;
    BTableModel defModel = null;
    BTableModel joinModel = null;
    String activeTable = null;
    String reportDir = null;
    JTextField txtReportName;

    public BQBuilder(BLogHandle logHandle, BDB db, String reportDir) {
        super(new BorderLayout());
        int i;
        this.db = db;
        this.reportDir = reportDir;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.tableViews = new HashMap<String, BTableViewer>();
        this.controls = new JPanel();
        super.add((Component)this.controls, "First");
        String[] btArray = new String[]{"New", "Delete Field", "Reload", "Refresh", "View", "Execute", "Export", "Linked XML", "Portrait Report", "Landscape Report", "Sub Report", "Save Report"};
        this.button = new JButton[btArray.length];
        for (i = 0; i < 8; ++i) {
            this.button[i] = new JButton(btArray[i]);
            this.button[i].addActionListener(this);
            this.controls.add(this.button[i]);
        }
        this.listModel = new DefaultListModel();
        this.listTables();
        this.tableList = new JList<String>(this.listModel);
        this.tableList.addMouseListener(this);
        this.tablesPane = new JScrollPane(this.tableList);
        this.desktop = new BImageDesktop("/org/baraza/resources/bg_small.png");
        this.splitPane = new JSplitPane(1, this.tablesPane, this.desktop);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(150);
        this.defModel = new BTableModel(new String[]{"Table Name", "Field Name", "Filter Type", "Filter Value", "Visible", "Group Function"});
        this.defTable = new JTable(this.defModel);
        this.defPane = new JScrollPane(this.defTable);
        this.joinModel = new BTableModel(new String[]{"Table Name", "Field Name", "Link", "Foreign Table", "Foreign Field"});
        this.joinTable = new JTable(this.joinModel);
        this.joinPane = new JScrollPane(this.joinTable);
        this.table = new JTable();
        this.scrollPane = new JScrollPane(this.table);
        this.sqlText = new JTextArea();
        this.sqlPane = new JScrollPane(this.sqlText);
        this.xmlText = new JTextArea();
        this.xmlPane = new JScrollPane(this.xmlText);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add("Columns", this.defPane);
        this.tabbedPane.add("Join", this.joinPane);
        this.tabbedPane.add("SQL", this.sqlPane);
        this.tabbedPane.add("Results", this.scrollPane);
        this.tabbedPane.add("XML", this.xmlPane);
        this.reportText = new JTextArea();
        this.reportPane = new JScrollPane(this.reportText);
        this.reportPanel = new JPanel(new BorderLayout());
        this.reportControls = new JPanel();
        this.reportPanel.add((Component)this.reportControls, "First");
        this.reportPanel.add((Component)this.reportPane, "Center");
        this.tabbedPane.add("Report Maker", this.reportPanel);
        this.txtReportName = new JTextField(15);
        this.reportControls.add(new JLabel("Report Name : "));
        this.reportControls.add(this.txtReportName);
        for (i = 8; i < 12; ++i) {
            this.button[i] = new JButton(btArray[i]);
            this.button[i].addActionListener(this);
            this.reportControls.add(this.button[i]);
        }
        this.mainPane = new JSplitPane(0, this.splitPane, this.tabbedPane);
        this.mainPane.setOneTouchExpandable(true);
        this.mainPane.setDividerLocation(250);
        super.add((Component)this.mainPane, "Center");
    }

    public void showTable() {
        String dKey;
        this.activeTable = dKey = this.tableList.getSelectedValue();
        if (this.tableViews.get(dKey) == null) {
            this.tableViews.put(dKey, new BTableViewer(this.db, dKey));
            this.tableViews.get((Object)dKey).list.addMouseListener(this);
        }
        if (!this.tableViews.get(dKey).isVisible()) {
            this.tableViews.get(dKey).setVisible(true);
            this.desktop.add(this.tableViews.get(dKey));
            try {
                this.tableViews.get(dKey).setSelected(true);
            }
            catch (PropertyVetoException ex) {
                this.log.severe("Desktop show error : " + ex);
            }
        } else {
            try {
                this.tableViews.get(dKey).setSelected(true);
                if (this.tableViews.get(dKey).isIcon()) {
                    this.tableViews.get(dKey).setIcon(false);
                }
            }
            catch (PropertyVetoException ex) {
                this.log.severe("Desktop show error : " + ex);
            }
        }
        this.table.setModel(this.tableViews.get(dKey).getTableModel());
        this.table.setFillsViewportHeight(true);
        this.table.setAutoCreateRowSorter(true);
        this.xmlText.setText(this.tableViews.get(dKey).getDeskConfig(0).getString());
        this.txtReportName.setText(this.activeTable);
    }

    public void addFields() {
        BTableViewer tv = (BTableViewer)this.desktop.getSelectedFrame();
        if (tv != null) {
            this.activeTable = tv.getName();
        }
        if (this.activeTable != null) {
            String dKey = this.tableViews.get(this.activeTable).getFieldName();
            int i = this.defModel.insertRow() - 1;
            this.defModel.setValueAt(this.activeTable, i, 0);
            this.defModel.setValueAt(dKey, i, 1);
            this.defModel.setValueAt("=", i, 2);
            this.defModel.setValueAt("Y", i, 4);
            this.defModel.refresh();
            this.buildQuery();
        }
    }

    public void buildQuery() {
        String selectSQL = null;
        String whereSQL = null;
        HashMap<String, Boolean> tblst = new HashMap<String, Boolean>();
        for (int i = 0; i < this.defModel.getRowCount(); ++i) {
            String tbName = this.defModel.getValueAt(i, 0).toString();
            Iterator fldName = this.defModel.getValueAt(i, 1).toString();
            String filterType = this.defModel.getValueAt(i, 2).toString();
            Iterator filterValue = this.defModel.getValueAt(i, 3).toString();
            String visible = this.defModel.getValueAt(i, 4).toString();
            if ("Y".equals(visible)) {
                selectSQL = selectSQL == null ? "SELECT " : selectSQL + ", ";
                selectSQL = selectSQL + tbName + "." + fldName;
            }
            if (!"".equals(filterValue)) {
                whereSQL = whereSQL == null ? "WHERE (" : whereSQL + " AND (" + tbName + "." + fldName;
                whereSQL = whereSQL + tbName + "." + fldName + filterType + "'" + filterValue + "')";
            }
            tblst.put(tbName, true);
        }
        ArrayList<String> tbList = new ArrayList<String>(tblst.keySet());
        ArrayList<BTableLinks> tableLinks = new ArrayList<BTableLinks>();
        for (String tb : tblst.keySet()) {
            for (BTableLinks tl : this.tableViews.get(tb).getLinks(tbList)) {
                if (!tl.isActive()) continue;
                tableLinks.add(tl);
            }
        }
        for (String tb : tblst.keySet()) {
            for (BTableLinks tl : tableLinks) {
                if (tb.equals(tl.getKeyTable())) {
                    tblst.put(tb, false);
                }
                if (!tb.equals(tl.getForeignTable())) continue;
                tblst.put(tb, false);
            }
        }
        String fromSQL = null;
        for (String tb : tblst.keySet()) {
            if (!((Boolean)tblst.get(tb)).booleanValue()) continue;
            if (fromSQL == null) {
                fromSQL = "\nFROM " + tb;
                continue;
            }
            fromSQL = fromSQL + ", " + tb;
        }
        tbList = new ArrayList();
        this.joinModel.clear();
        for (BTableLinks tl : tableLinks) {
            tl.setLinked(tbList);
            fromSQL = fromSQL == null ? "\nFROM " + tl.toString() : fromSQL + "\n " + tl.toString();
            this.joinModel.insertRow(tl.getData());
            tbList.add(tl.getKeyTable());
            tbList.add(tl.getForeignTable());
        }
        selectSQL = selectSQL + fromSQL;
        if (whereSQL != null) {
            selectSQL = selectSQL + "\n" + whereSQL;
        }
        this.sqlText.setText(selectSQL);
    }

    public void executeQuery() {
        String mysql = this.sqlText.getText().trim();
        if (mysql.toUpperCase().startsWith("SELECT")) {
            this.tableModel = new BTableModel(this.db, mysql, -1);
            this.table.setModel(this.tableModel);
            this.table.setFillsViewportHeight(true);
            this.table.setAutoCreateRowSorter(true);
            this.xmlText.setText(this.tableModel.getTableConfig().toString());
        }
    }

    public void listTables() {
        List<String> tblist = this.db.getTables();
        List<String> vwlist = this.db.getViews();
        this.listModel.clear();
        for (String lst : tblist) {
            this.listModel.addElement(lst);
        }
        for (String lst : vwlist) {
            this.listModel.addElement(lst);
        }
    }

    public void exportData() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this);
        if (this.tableModel != null && returnVal == 0) {
            String filename = fc.getSelectedFile().getAbsolutePath() + ".csv";
            this.tableModel.savecvs(filename);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if ("Execute".equals(aKey)) {
            this.executeQuery();
        } else if ("Export".equals(aKey)) {
            this.exportData();
        } else if ("New".equals(aKey)) {
            this.defModel.clear();
        } else if ("Delete Field".equals(aKey)) {
            this.defModel.removeRow(this.defTable.getSelectedRow());
        } else if ("Refresh".equals(aKey)) {
            this.buildQuery();
        } else if ("Reload".equals(aKey)) {
            this.listTables();
        } else if ("View".equals(aKey)) {
            BTableViewer tv = (BTableViewer)this.desktop.getSelectedFrame();
            this.sqlText.setText(tv.getViewSQL());
        } else if ("Linked XML".equals(aKey)) {
            this.xmlText.setText(this.tableViews.get(this.activeTable).getDeskConfig(1).getString());
        } else if ("Portrait Report".equals(aKey)) {
            this.executeQuery();
            BReportMaker reportMaker = new BReportMaker();
            this.reportText.setText(reportMaker.makeReport(this.txtReportName.getText(), this.sqlText.getText(), this.tableModel.getQuery()));
            this.reportText.setCaretPosition(0);
        } else if ("Landscape Report".equals(aKey)) {
            this.executeQuery();
            BReportMaker reportMaker = new BReportMaker();
            this.reportText.setText(reportMaker.makeLandscapeReport(this.txtReportName.getText(), this.sqlText.getText(), this.tableModel.getQuery()));
            this.reportText.setCaretPosition(0);
        } else if ("Sub Report".equals(aKey)) {
            this.executeQuery();
            BReportMaker reportMaker = new BReportMaker();
            this.reportText.setText(reportMaker.makeSubReport(this.txtReportName.getText(), this.sqlText.getText(), this.tableModel.getQuery()));
            this.reportText.setCaretPosition(0);
        } else if ("Save Report".equals(aKey)) {
            String reportName = this.reportDir + this.txtReportName.getText() + ".jrxml";
            Bio io = new Bio();
            int n = 0;
            if (io.FileExists(reportName)) {
                n = JOptionPane.showConfirmDialog(this, "You will overwrite and extisting report?", "Report overwrite", 0);
            }
            if (n == 0) {
                io.saveFile(reportName, this.reportText.getText());
                BCompileReport bCompileReport = new BCompileReport(reportName);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (ev.getClickCount() == 2) {
            if (ev.getComponent() == this.tableList) {
                this.showTable();
            } else {
                this.addFields();
            }
        }
    }
}

