/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.ide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.app.BDesk;
import org.baraza.swing.BCellRenderer;
import org.baraza.swing.BImageDesktop;
import org.baraza.swing.BImageTree;
import org.baraza.swing.BTextArea;
import org.baraza.utils.BLogHandle;
import org.baraza.utils.Bio;
import org.baraza.xml.BElement;
import org.baraza.xml.BTreeNode;
import org.baraza.xml.BXML;
import org.baraza.xml.BXMLTable;

public class BxmlViewer
extends JTabbedPane
implements ActionListener,
TreeSelectionListener {
    Logger log = Logger.getLogger(BxmlViewer.class.getName());
    BLogHandle logHandle;
    JPanel controls;
    JPanel nodeControls;
    JTable table;
    JScrollPane scrollPane;
    JScrollPane textScroll;
    JScrollPane xmlScroll;
    BTextArea textArea;
    JButton[] button;
    JButton btNewDesk;
    JButton btNewLink;
    JButton btNewNode;
    JButton btMoveUp;
    JButton btMoveDown;
    JButton btRefresh;
    JPanel xmlpanel;
    JLabel lblTableList;
    JLabel lblComponent;
    JLabel lblNewDesk;
    JLabel lblNewReport;
    JTextField txtNewDesk;
    JTextField txtNewReport;
    JTabbedPane nodePane;
    JComboBox<String> tableList;
    JComboBox<String> componentList;
    BImageDesktop desktop;
    JSplitPane splitPane;
    JTree tree;
    DefaultTreeModel treemodel;
    BXMLTable xmlTable;
    BTreeNode top = null;
    BElement root;
    BDB db;
    String xmlFile;
    String projectName;

    public BxmlViewer(BLogHandle logHandle, BDB db, String myFile, String projectName) {
        this.db = db;
        this.projectName = projectName;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.xmlFile = myFile;
        BXML xml = new BXML(this.xmlFile, false);
        this.root = xml.getDocument() == null ? new BElement("APP") : xml.getRoot();
        this.controls = new JPanel(new GridLayout(2, 0));
        String[] btArray = new String[]{"Save", "Reload", "Find", "Add Attribute", "Delete Attribute", "Web Migration", "App Migration", "Web Cleanup", "Preview", "New XML"};
        this.button = new JButton[btArray.length];
        for (int i = 0; i < btArray.length; ++i) {
            this.button[i] = new JButton(btArray[i]);
            this.button[i].addActionListener(this);
            this.controls.add(this.button[i]);
        }
        this.top = this.makeNode(this.root);
        this.treemodel = new DefaultTreeModel(this.top);
        this.tree = new BImageTree("/org/baraza/resources/leftpanel.jpg", this.treemodel, true);
        this.tree.setCellRenderer(new BCellRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.xmlScroll = new JScrollPane(this.tree);
        this.nodePane = new JTabbedPane();
        this.textArea = new BTextArea(logHandle);
        this.textArea.setTabSize(4);
        this.textScroll = new JScrollPane(this.textArea);
        this.nodePane.add((Component)this.textScroll, "XML");
        this.table = new JTable();
        this.scrollPane = new JScrollPane(this.table);
        this.nodePane.add((Component)this.scrollPane, "Attributes");
        this.nodeControls = new JPanel(null);
        this.nodePane.add((Component)this.nodeControls, "New Components");
        this.lblTableList = new JLabel("Table : ");
        this.nodeControls.add(this.lblTableList);
        this.lblTableList.setBounds(10, 5, 100, 25);
        this.tableList = new JComboBox();
        this.nodeControls.add(this.tableList);
        this.tableList.setBounds(110, 5, 250, 25);
        for (String tn : db.getTables()) {
            if (tn.startsWith("sys_")) continue;
            this.tableList.addItem(tn);
        }
        this.btNewDesk = new JButton("New Desk");
        this.nodeControls.add(this.btNewDesk);
        this.btNewDesk.setBounds(360, 5, 100, 25);
        this.btNewDesk.addActionListener(this);
        this.btNewLink = new JButton("New Link");
        this.nodeControls.add(this.btNewLink);
        this.btNewLink.setBounds(470, 5, 100, 25);
        this.btNewLink.addActionListener(this);
        this.lblComponent = new JLabel("Component : ");
        this.nodeControls.add(this.lblComponent);
        this.lblComponent.setBounds(10, 30, 100, 25);
        String[] componentNames = new String[]{"DESK", "GRID", "REPORT DESK"};
        this.componentList = new JComboBox<String>(componentNames);
        this.nodeControls.add(this.componentList);
        this.componentList.setBounds(110, 30, 250, 25);
        this.btNewNode = new JButton("New Node");
        this.nodeControls.add(this.btNewNode);
        this.btNewNode.setBounds(360, 30, 100, 25);
        this.btNewNode.addActionListener(this);
        this.lblNewDesk = new JLabel("Name : ");
        this.txtNewDesk = new JTextField(50);
        this.nodeControls.add(this.lblNewDesk);
        this.lblNewDesk.setBounds(10, 55, 100, 25);
        this.nodeControls.add(this.txtNewDesk);
        this.txtNewDesk.setBounds(110, 55, 250, 25);
        this.lblNewReport = new JLabel("Report Name : ");
        this.txtNewReport = new JTextField(50);
        this.nodeControls.add(this.lblNewReport);
        this.lblNewReport.setBounds(10, 80, 100, 25);
        this.nodeControls.add(this.txtNewReport);
        this.txtNewReport.setBounds(110, 80, 250, 25);
        this.btMoveUp = new JButton("Move Up");
        this.nodeControls.add(this.btMoveUp);
        this.btMoveUp.setBounds(10, 105, 100, 25);
        this.btMoveUp.addActionListener(this);
        this.btMoveDown = new JButton("Move Down");
        this.nodeControls.add(this.btMoveDown);
        this.btMoveDown.setBounds(110, 105, 100, 25);
        this.btMoveDown.addActionListener(this);
        this.btRefresh = new JButton("Refresh");
        this.nodeControls.add(this.btRefresh);
        this.btRefresh.setBounds(210, 105, 100, 25);
        this.btRefresh.addActionListener(this);
        this.splitPane = new JSplitPane(1, this.xmlScroll, this.nodePane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(200);
        this.desktop = new BImageDesktop("/org/baraza/resources/bg_small.png");
        this.xmlpanel = new JPanel(new BorderLayout());
        this.xmlpanel.add((Component)this.controls, "First");
        this.xmlpanel.add((Component)this.splitPane, "Center");
        super.addTab("XML", this.xmlpanel);
        super.addTab("Preview", this.desktop);
    }

    public BTreeNode makeNode(BElement sbn) {
        String title = sbn.getName() + " : ";
        if (sbn.getAttribute("title") != null) {
            title = title + sbn.getAttribute("title");
        } else if (sbn.getAttribute("name") != null) {
            title = title + sbn.getAttribute("name");
        }
        BTreeNode firstNode = new BTreeNode(sbn, title);
        for (BElement el : sbn.getElements()) {
            firstNode.add(this.makeNode(el));
        }
        return firstNode;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if ("New XML".equals(aKey)) {
            this.root = new BElement("APP");
            this.root.setAttribute("name", this.projectName);
            this.root = this.db.getAppConfig(this.root);
            this.top = this.makeNode(this.root);
            this.treemodel.setRoot(this.top);
        } else if ("Save".equals(aKey)) {
            Bio io = new Bio();
            io.saveFile(this.xmlFile, this.root.toString());
        } else if ("Reload".equals(aKey)) {
            String xmltext = this.textArea.getText();
            BXML xmlNode = new BXML(xmltext, true);
            BTreeNode node = (BTreeNode)this.tree.getLastSelectedPathComponent();
            if (xmlNode.getDocument() != null && node != null) {
                BTreeNode parentNode = (BTreeNode)node.getParent();
                if (parentNode == null) {
                    this.root = xmlNode.getRoot();
                    this.top = this.makeNode(this.root);
                    this.treemodel.setRoot(this.top);
                } else {
                    BTreeNode newNode = this.makeNode(xmlNode.getRoot());
                    int i = parentNode.getIndex(node);
                    parentNode.getKey().addNode(newNode.getKey(), i);
                    parentNode.getKey().delNode(node.getKey());
                    parentNode.insert(newNode, i);
                    parentNode.remove(node);
                    this.treemodel.reload(parentNode);
                }
            }
        } else if ("Find".equals(aKey)) {
            BElement menu;
            BTreeNode node = (BTreeNode)this.tree.getLastSelectedPathComponent();
            if (node != null && (menu = node.getKey()) != null) {
                String menuKey = menu.getAttribute("key");
                if (menuKey == null) {
                    menuKey = menu.getValue();
                }
                int i = this.root.elementIndex(this.root.getElementByKey(menuKey));
                this.tree.collapseRow(1);
                this.tree.setSelectionRow(i + 1);
            }
        } else if ("Add Attribute".equals(aKey)) {
            this.xmlTable.insertRow();
        } else if ("Delete Attribute".equals(aKey)) {
            int i = this.table.getSelectedRow();
            if (i > 0) {
                this.xmlTable.removeRow(i);
            }
        } else if ("Web Migration".equals(aKey)) {
            this.migrateWeb();
        } else if ("App Migration".equals(aKey)) {
            this.migrateApp();
        } else if ("Web Cleanup".equals(aKey)) {
            this.webCleanUp();
        } else if ("Preview".equals(aKey)) {
            this.showPreview();
        } else if ("New Desk".equals(aKey)) {
            this.newDesk();
        } else if ("New Link".equals(aKey)) {
            this.newLink();
        } else if ("New Node".equals(aKey)) {
            this.newNode();
        } else if ("Move Up".equals(aKey)) {
            this.moveNode(true);
        } else if ("Move Down".equals(aKey)) {
            this.moveNode(false);
        } else if ("Refresh".equals(aKey)) {
            this.refreshTable();
        }
    }

    public void showPreview() {
        BTreeNode node = (BTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            BElement dKey = node.getKey();
            String reportDir = "";
            if (dKey.getName().equals("DESK")) {
                BDesk desk = new BDesk(this.logHandle, this.db, dKey, reportDir);
                desk.setVisible(true);
                this.desktop.add(desk);
                try {
                    desk.setSelected(true);
                }
                catch (PropertyVetoException ex) {
                    System.out.println("Desktop show error : " + ex);
                }
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent ev) {
        BTreeNode node = (BTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            this.xmlTable = new BXMLTable(node, this.treemodel);
            this.table.setModel(this.xmlTable);
            this.table.setFillsViewportHeight(true);
            this.textArea.setText(node.getKey().toString());
            this.textArea.setCaretPosition(0);
        }
    }

    public void migrateWeb() {
        BElement menu = this.root.getElement(0).copy();
        for (BElement subMenu : menu.getElements()) {
            subMenu.setName("MENU");
            if (subMenu.isLeaf()) continue;
            subMenu.delAttribute("key");
            for (BElement itemMenu : subMenu.getElements()) {
                itemMenu.setName("MENU");
                itemMenu.setValue(itemMenu.getAttribute("key"));
                itemMenu.delAttribute("key");
            }
        }
        BElement app = new BElement("APP");
        app.addNode(menu);
        BElement desks = this.root.getElement(1).copy();
        for (BElement desk : desks.getElements()) {
            BElement node = new BElement("DESK");
            node.setAttribute("h", "500");
            node.setAttribute("w", "700");
            node.setAttribute("key", desk.getAttribute("key"));
            node.setAttribute("name", desk.getAttribute("name"));
            desk.delAttribute("key");
            if (desk.getName().equals("REPORT")) {
                desk.setName("GRID");
            }
            if (desk.getAttribute("ordersql") != null) {
                desk.setAttribute("orderby", desk.getAttribute("ordersql"));
                desk.delAttribute("ordersql");
            }
            if (desk.getAttribute("wheresql") != null) {
                desk.setAttribute("where", desk.getAttribute("wheresql"));
                desk.delAttribute("wheresql");
            }
            if (desk.getAttribute("primaryfield") != null) {
                desk.replaceAttribute("primaryfield", "keyfield");
            }
            if (desk.getAttribute("approvals") != null) {
                BElement actions = new BElement("ACTIONS");
                String[] approvals = desk.getAttribute("approvals").split(":");
                for (String approval : approvals) {
                    BElement action = new BElement("ACTION");
                    action.setValue(approval);
                    action.setAttribute("fnct", desk.getAttribute("functioncheck"));
                    action.setAttribute("approval", approval);
                    if (desk.getAttribute("phase") == null) {
                        action.setAttribute("phase", "1");
                    } else {
                        action.setAttribute("phase", desk.getAttribute("phase"));
                    }
                    action.setAttribute("from", "from dual");
                    actions.addNode(action);
                }
                desk.addNode(actions);
            }
            for (BElement field : desk.getElements()) {
                if (field.getName().equals("FIELD")) {
                    field.setName("TEXTFIELD");
                }
                field.replaceAttribute("type", "format");
                field.replaceAttribute("defaultvalue", "default");
                field.replaceAttribute("lookupfield", "lpfield");
                field.replaceAttribute("lookupkey", "lpkey");
                field.replaceAttribute("lookuptable", "lptable");
                field.replaceAttribute("wheresql", "where");
                if (field.getAttribute("typeid") != null) {
                    int typeid = Integer.valueOf(field.getAttribute("typeid"));
                    switch (typeid) {
                        case 1: {
                            field.setName("TEXTFIELD");
                            break;
                        }
                        case 2: {
                            field.setName("TEXTAREA");
                            break;
                        }
                        case 3: {
                            field.setName("PASSWORD");
                            break;
                        }
                        case 4: {
                            field.setName("COMBOBOX");
                            break;
                        }
                        case 5: {
                            field.setName("CHECKBOX");
                            break;
                        }
                        case 6: {
                            field.setName("COMBOLIST");
                            break;
                        }
                        case 8: {
                            field.setName("FILE");
                            break;
                        }
                        case 9: {
                            field.setName("TEXTDATE");
                            break;
                        }
                        case 10: {
                            field.setName("DEFAULT");
                            break;
                        }
                        case 15: {
                            field.setName("CHECKBOX");
                            field.setAttribute("ischar", "true");
                        }
                    }
                    field.delAttribute("typeid");
                }
                if (field.getAttribute("editkey") == null) continue;
                field.setName("EDITFIELD");
            }
            BElement tmpdesk = desk.copy();
            int i = 0;
            for (BElement field : tmpdesk.getElements()) {
                if (field.getAttribute("subreport") != null) {
                    BElement subreport = desks.getElementByKey(field.getAttribute("subreport"));
                    if (subreport != null) {
                        subreport.replaceAttribute("filterkey", "linkfield");
                        desk.addNode(subreport);
                        desk.setAttribute("keyfield", field.getValue().toLowerCase());
                        desk.delNode(i);
                        --i;
                    }
                } else if (field.getAttribute("entrylink") != null) {
                    BElement subreport = desks.getElementByKey(field.getAttribute("entrylink"));
                    if (subreport != null) {
                        subreport.replaceAttribute("filterfield", "linkfield");
                        subreport.replaceAttribute("primaryfield", "keyfield");
                        if (subreport.getAttribute("user") != null) {
                            BElement user = new BElement("USERFIELD");
                            user.setValue(subreport.getAttribute("user"));
                            subreport.addNode(user);
                            subreport.delAttribute("user");
                        }
                        desk.addNode(subreport);
                        desk.setAttribute("keyfield", field.getValue().toLowerCase());
                        desk.delNode(i);
                        --i;
                    }
                } else if (field.getAttribute("selectrow") != null) {
                    desk.setAttribute("keyfield", field.getValue().toLowerCase());
                    desk.delNode(i);
                    --i;
                }
                ++i;
            }
            node.addNode(desk);
            app.addNode(node);
        }
        Bio io = new Bio();
        io.saveFile(this.xmlFile + ".new", app.toString());
    }

    public void migrateApp() {
        BElement app = new BElement("APP");
        boolean first = true;
        for (BElement node : this.root.getElements()) {
            if (first) {
                app.addNode(this.migrateMenu(node));
                first = false;
                continue;
            }
            app.addNode(this.migrateDesk(node));
        }
        Bio io = new Bio();
        io.saveFile(this.xmlFile + ".new", app.toString());
        System.out.println(app.toString());
    }

    public BElement migrateMenu(BElement menu) {
        BElement newMenu = new BElement("MENU");
        newMenu.setAttribute("name", menu.getAttribute("name"));
        if (menu.getAttribute("key") != null) {
            newMenu.setValue(menu.getAttribute("key"));
        }
        if (menu.getAttribute("role") != null) {
            newMenu.setAttribute("role", menu.getAttribute("role"));
        }
        for (BElement itemMenu : menu.getElements()) {
            newMenu.addNode(this.migrateMenu(itemMenu));
        }
        return newMenu;
    }

    public BElement migrateDesk(BElement oldDesk) {
        BElement desk = new BElement("DESK");
        boolean hasFilters = false;
        desk.setAttribute("h", oldDesk.getAttribute("h"));
        desk.setAttribute("w", oldDesk.getAttribute("w"));
        desk.setAttribute("key", oldDesk.getAttribute("key"));
        desk.setAttribute("name", oldDesk.getAttribute("name"));
        desk.setAttribute("type", oldDesk.getAttribute("splittype"));
        for (BElement view : oldDesk.getElements()) {
            if (view.getAttribute("linkkey") == null) {
                desk.addNode(view);
            } else {
                BElement linkView = oldDesk.getElementByKey(view.getAttribute("linkkey"));
                if (linkView == null) {
                    desk.addNode(view);
                } else {
                    linkView.addNode(view);
                }
            }
            view.replaceAttribute("jasperfile", "reportfile");
            view.replaceAttribute("wheresql", "where");
            view.replaceAttribute("ordersql", "orderby");
            view.replaceAttribute("sortfield", "orderby");
            if (view.getAttribute("keyfield") == null) {
                view.replaceAttribute("autofield", "keyfield");
            }
            if (view.getAttribute("keyfield") == null && view.getAttribute("keyfield") == null) {
                view.replaceAttribute("linkfield", "keyfield");
            }
            if (view.getAttribute("inputfield") != null) {
                view.replaceAttribute("inputfield", "linkfield");
            }
            if (view.getAttribute("keyfield", "").equals(view.getAttribute("linkfield"))) {
                view.delAttribute("linkfield");
            }
            if (view.getName().equals("REPORT")) {
                view.setName("JASPER");
            }
            view.delAttribute("gridfilter");
            view.delAttribute("linkkey");
            view.delAttribute("pos");
            for (BElement field : view.getElements()) {
                if (field.getName().equals("TEXTLOOKUP")) {
                    field.setName("GRIDBOX");
                }
                field.replaceAttribute("sortfield", "orderby");
                for (BElement subfield : field.getElements()) {
                    subfield.replaceAttribute("sortfield", "orderby");
                }
            }
            if (view.getName().equals("DRILLDOWN")) {
                hasFilters = true;
            }
            if (!view.getName().equals("CALENDAR")) continue;
            hasFilters = true;
        }
        if (hasFilters) {
            BElement filter = new BElement("FILTER");
            filter.setAttribute("name", desk.getAttribute("name"));
            filter.setAttribute("location", "250");
            filter.setAttribute("type", "horl");
            for (BElement view : desk.getElements()) {
                filter.addNode(view);
            }
            desk.clearNodes();
            desk.addNode(filter);
        }
        return desk;
    }

    public void webCleanUp() {
        for (BElement node : this.root.getElements()) {
            this.webCleanUp(node);
        }
        Bio io = new Bio();
        io.saveFile(this.xmlFile + ".new", this.root.toString());
    }

    public void webCleanUp(BElement node) {
        for (BElement el : node.getElements()) {
            String format = el.getAttribute("format", "");
            if (format.equals("boolean")) {
                el.insertAttribute("ischar", "true");
                el.setName("CHECKBOX");
            }
            if (!el.getName().equals("DESK")) {
                el.delAttribute("key");
            }
            if (el.getAttribute("form") != null) {
                el.setAttribute("display", "form");
                el.delAttribute("form");
            }
            if (el.getAttribute("editor") != null) {
                el.delAttribute("editor");
                el.setName("EDITOR");
            }
            if (el.getAttribute("keyfield") == null & el.getAttribute("autofield") != null) {
                el.replaceAttribute("autofield", "keyfield");
            }
            el.replaceAttribute("selectvalue", "action");
            if (el.getAttribute("action") != null) {
                if (node.getAttribute("keyfield") == null) {
                    node.setAttribute("keyfield", el.getValue());
                }
                BElement action = new BElement("ACTION");
                action.setAttribute("fnct", el.getAttribute("action"));
                action.setValue(el.getAttribute("title"));
                el.addNode(action);
                el.setName("ACTIONS");
                el.setValue("");
                el.delAttribute("action");
                el.delAttribute("title");
                el.delAttribute("w");
            }
            this.webCleanUp(el);
        }
    }

    public void newDesk() {
        int ik = 5;
        for (BElement nel : this.root.getElements()) {
            String iks = nel.getAttribute("key");
            int i = 0;
            if (iks != null) {
                i = Integer.valueOf(iks);
            }
            if (i < ik) continue;
            ik = i + 5;
        }
        String tableName = this.tableList.getSelectedItem().toString();
        BElement mel = new BElement("MENU");
        mel.setAttribute("name", this.db.initCap(tableName));
        mel.setValue(String.valueOf(ik));
        BTreeNode mnNode = this.makeNode(mel);
        this.top.add(mnNode);
        this.root.addNode(mel);
        BQuery query = new BQuery(this.db, "*", tableName, 2);
        BElement del = new BElement("DESK");
        del.setAttribute("h", "550");
        del.setAttribute("w", "700");
        del.setAttribute("name", this.db.initCap(tableName));
        del.setAttribute("key", String.valueOf(ik));
        del.addNode(query.getDeskConfig(0));
        BTreeNode deskNode = this.makeNode(del);
        this.top.add(deskNode);
        this.root.addNode(del);
        this.treemodel.reload(this.top);
        query.close();
    }

    public void newReportDesk() {
        int ik = 5;
        for (BElement nel : this.root.getElements()) {
            String iks = nel.getAttribute("key");
            int i = 0;
            if (iks != null) {
                i = Integer.valueOf(iks);
            }
            if (i < ik) continue;
            ik = i + 5;
        }
        BElement mel = new BElement("MENU");
        mel.setAttribute("name", this.db.initCap(this.txtNewDesk.getText()));
        mel.setValue(String.valueOf(ik));
        BTreeNode mnNode = this.makeNode(mel);
        this.top.add(mnNode);
        this.root.addNode(mel);
        BElement jsr = new BElement("JASPER");
        jsr.setAttribute("name", this.txtNewDesk.getText());
        jsr.setAttribute("reportfile", this.txtNewReport.getText() + ".jasper");
        BElement del = new BElement("DESK");
        del.setAttribute("h", "550");
        del.setAttribute("w", "700");
        del.setAttribute("name", this.txtNewDesk.getText());
        del.setAttribute("key", String.valueOf(ik));
        del.addNode(jsr);
        BTreeNode deskNode = this.makeNode(del);
        this.top.add(deskNode);
        this.root.addNode(del);
        this.treemodel.reload(this.top);
    }

    public void newLink() {
        String tableName = this.tableList.getSelectedItem().toString();
        BTreeNode node = (BTreeNode)this.tree.getLastSelectedPathComponent();
        BQuery query = new BQuery(this.db, "*", tableName, 2);
        BElement del = query.getDeskConfig(1);
        node.getKey().addNode(del);
        BTreeNode deskNode = this.makeNode(del);
        node.add(deskNode);
        this.treemodel.reload(node);
        query.close();
    }

    public void newNode() {
        String cmpName = this.componentList.getSelectedItem().toString();
        if ("REPORT DESK".equals(cmpName)) {
            this.newReportDesk();
        }
    }

    public void moveNode(boolean direction) {
        BTreeNode node;
        TreePath currentSelection = this.tree.getSelectionPath();
        if (currentSelection != null && (node = (BTreeNode)currentSelection.getLastPathComponent()) != null) {
            int x;
            BTreeNode parent = (BTreeNode)node.getParent();
            int y = x = parent.getIndex(node);
            if (direction && x > 0) {
                y = x - 1;
            }
            if (!direction && x < parent.getChildCount() - 1) {
                y = x + 1;
            }
            if (x != y) {
                parent.insert(node, y);
                parent.getKey().addNode(node.getKey(), y);
                if (direction) {
                    ++x;
                }
                parent.getKey().delNode(x);
                this.treemodel.reload(parent);
                this.tree.setSelectionPath(currentSelection);
            }
        }
    }

    public void refreshTable() {
        this.tableList.removeAllItems();
        for (String tn : this.db.getTables()) {
            if (tn.startsWith("sys_")) continue;
            this.tableList.addItem(tn);
        }
    }
}

