/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.escalation;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.reports.BReportFile;
import org.baraza.server.mail.BMail;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BEscalation {
    Logger log = Logger.getLogger(BEscalation.class.getName());
    BDB db;
    BElement root;
    BLogHandle logHandle;
    String testemail;
    String title = "";
    boolean executing = false;
    boolean runserver = true;
    int processdelay = 10000;

    public BEscalation(BDB db, BElement root, BLogHandle logHandle) {
        this.db = db;
        this.root = root;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.testemail = root.getAttribute("testemail");
        this.title = root.getAttribute("title", "");
        this.processdelay = Integer.valueOf(root.getAttribute("processdelay", "2")) * 60 * 1000;
    }

    public int getDelay() {
        return this.processdelay;
    }

    public int process() {
        BMail mail = new BMail(this.root, this.logHandle);
        if (mail.getActive()) {
            this.task(mail);
        }
        mail.close();
        return this.processdelay;
    }

    public void task(BMail mail) {
        this.log.info("---------- Escalation Client Run for : " + this.title);
        this.executing = true;
        for (BElement ell : this.root.getElements()) {
            String keyfield;
            String colNames = keyfield = ell.getAttribute("keyfield");
            for (BElement el : ell.getElements()) {
                String basetable = el.getAttribute("basetable");
                String function = el.getAttribute("function");
                if (function == null) {
                    function = el.getAttribute("fnct");
                }
                colNames = colNames + ", ";
                colNames = basetable != null ? colNames + basetable + "." + el.getValue() : (function != null ? colNames + "(" + function + ")" : colNames + el.getValue());
                if (el.getName().equals("ADDRESS")) {
                    colNames = colNames + " as emailaddress";
                    continue;
                }
                if (el.getName().equals("SUBJECT")) {
                    colNames = colNames + " as emailsubject";
                    continue;
                }
                if (function == null) continue;
                colNames = colNames + " as " + el.getValue();
            }
            String mysql = "SELECT " + colNames + " FROM " + ell.getAttribute("table") + " ";
            if (ell.getAttribute("where") != null) {
                mysql = mysql + " WHERE " + ell.getAttribute("where");
            }
            this.log.info(mysql);
            String replyTo = null;
            String oeSql = "";
            BQuery rs = new BQuery(this.db, mysql);
            while (rs.moveNext()) {
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> rptParams = new HashMap<String, String>();
                HashMap<String, String> headers = new HashMap<String, String>();
                HashMap<String, String> reports = new HashMap<String, String>();
                HashMap<String, String> files = new HashMap<String, String>();
                String ccto = null;
                String subject = rs.getString("emailsubject");
                String msg = "<HTML>\n<HEAD></HEAD>\n<BODY>\n";
                if (ell.getAttribute("reply.to") != null) {
                    oeSql = "SELECT email_from FROM orgs WHERE org_id = " + rs.getString("org_id");
                    replyTo = this.db.executeFunction(oeSql);
                }
                for (BElement el : ell.getElements()) {
                    String reference;
                    if (el.getName().equals("FIELD")) {
                        if (rs.getString(el.getValue()) == null) continue;
                        msg = msg + "<p>" + rs.getString(el.getValue()) + "</p>\n";
                        continue;
                    }
                    if (el.getName().equals("BODYFIELD")) {
                        reference = el.getAttribute("reference");
                        if (rs.getString(el.getValue()) != null) {
                            params.put(reference, rs.getString(el.getValue()));
                            continue;
                        }
                        params.put(reference, "");
                        continue;
                    }
                    if (el.getName().equals("HEADER")) {
                        reference = el.getAttribute("reference");
                        if (rs.getString(el.getValue()) == null) continue;
                        headers.put(reference, rs.getString(el.getValue()));
                        continue;
                    }
                    if (el.getName().equals("PARAM")) {
                        if (rs.getString(el.getValue()) == null) continue;
                        rptParams.put(el.getValue(), rs.getString(el.getValue()));
                        continue;
                    }
                    if (el.getName().equals("CCTO")) {
                        if (rs.getString(el.getValue()) == null) continue;
                        ccto = rs.getString(el.getValue());
                        continue;
                    }
                    if (el.getName().equals("REPORT")) {
                        if (rs.getString(el.getValue()) == null) continue;
                        reports.put(el.getValue(), rs.getString(el.getValue()));
                        continue;
                    }
                    if (!el.getName().equals("FILE")) continue;
                    String fileName = rs.getString(el.getValue());
                    String pathName = el.getAttribute("path");
                    if (fileName == null) continue;
                    files.put(fileName, pathName + fileName);
                }
                msg = msg + "\n</BODY>\n</HTML>\n";
                for (String key : params.keySet()) {
                    this.log.finest(key + " : " + (String)params.get(key));
                    msg = msg.replace(key, (CharSequence)params.get(key));
                    subject = subject.replace(key, (CharSequence)params.get(key));
                }
                String emailaddress = rs.getString("emailaddress");
                this.log.info("To : " + emailaddress + "\nSubject : " + subject);
                if (this.testemail != null) {
                    emailaddress = this.testemail;
                }
                boolean gotreport = false;
                if (ell.getAttribute("attachment") != null) {
                    BReportFile rf = new BReportFile(this.db, this.logHandle);
                    gotreport = rf.getReport(this.root.getAttribute("reportpath"), ell.getAttribute("attachment"), rs.getString(keyfield), rptParams);
                }
                for (String report : reports.keySet()) {
                    String reportFile = (String)reports.get(report);
                    BReportFile rf = new BReportFile(this.db, this.logHandle);
                    rf.setOutput(report);
                    rf.getReport(this.root.getAttribute("reportpath"), reportFile, rs.getString(keyfield), rptParams);
                }
                if (emailaddress != null && emailaddress.indexOf("@") > 1) {
                    mail.sendMail(emailaddress, ccto, replyTo, subject, msg, gotreport, headers, reports, files);
                }
                String functable = this.root.getAttribute("functable");
                String actioncount = ell.getAttribute("actioncount");
                if (actioncount == null) {
                    mysql = "SELECT " + ell.getAttribute("action") + " ('" + rs.getString(keyfield) + "')";
                } else {
                    mysql = "SELECT " + ell.getAttribute("action") + " ('" + actioncount;
                    mysql = mysql + "', '" + rs.getString(keyfield) + "')";
                }
                if (functable != null) {
                    mysql = mysql + " FROM " + functable;
                }
                this.db.executeQuery(mysql);
                if (this.db.getDBType() != 2) continue;
                this.db.executeQuery("COMMIT");
            }
            rs.close();
        }
        this.executing = false;
    }

    public String fmtdate(Date dt) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMMM yyyy, hh:mm a");
        return sdf.format(dt);
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void close() {
        this.db.close();
    }
}

