/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.sms;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.server.comm.BComm;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BKannel {
    Logger log = Logger.getLogger(BKannel.class.getName());
    BLogHandle logHandle;
    List<BComm> qcomms;
    String url;
    String username;
    String password;
    BDB db = null;
    BElement root = null;
    int processdelay = 10000;
    boolean executing = false;

    public BKannel(BDB db, BElement root, BLogHandle logHandle) {
        this.db = db;
        this.root = root;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.qcomms = new ArrayList<BComm>();
        for (BElement node : root.getElements()) {
            if (!node.getName().equals("COMM")) continue;
            this.qcomms.add(new BComm(db, node, logHandle));
        }
        this.processdelay = Integer.valueOf(root.getAttribute("duration", "10000"));
        this.url = root.getAttribute("url", "http://localhost/kannel/");
        this.username = root.getAttribute("username", "root");
        this.password = root.getAttribute("password", "invent");
        this.log.info("Starting Kannel SMS Server.");
    }

    public int getDelay() {
        return this.processdelay;
    }

    public int process() {
        this.log.info("Kannel SMS Processing...");
        this.executing = true;
        boolean dbValid = this.db.isValid();
        if (dbValid) {
            for (BComm qcomm : this.qcomms) {
                qcomm.process();
            }
            this.sendMessage();
        } else {
            this.db.reconnect();
        }
        this.executing = false;
        return this.processdelay;
    }

    public void sendMessage() {
        String mysql = "SELECT sms_id, sms_number, message, folder_id, sent FROM sms ";
        mysql = mysql + "WHERE (folder_id = 0) AND (message_ready = true) AND (sent = false)";
        BQuery rs = new BQuery(this.db, mysql);
        while (rs.moveNext()) {
            boolean isSent = true;
            String number = rs.getString("sms_number");
            if (number == null) {
                number = "";
            }
            if (number.length() > 2) {
                isSent = this.sendMessage(number.trim(), rs.getString("message"));
            }
            mysql = "SELECT sms_address.sms_address_id, address.mobile ";
            mysql = mysql + "FROM address INNER JOIN sms_address ON address.address_id = sms_address.address_id ";
            mysql = mysql + "WHERE (sms_address.sms_id\t= " + rs.getString("sms_id") + ")";
            BQuery rsa = new BQuery(this.db, mysql);
            while (rsa.moveNext()) {
                number = rsa.getString("mobile");
                if (number == null) {
                    number = "";
                }
                if (number.length() <= 2) continue;
                isSent = this.sendMessage(number.trim(), rs.getString("message"));
            }
            rsa.close();
            mysql = "SELECT sms_groups.sms_groups_id, address.mobile ";
            mysql = mysql + "FROM address INNER JOIN entity_subscriptions ON address.table_id = entity_subscriptions.entity_id ";
            mysql = mysql + "INNER JOIN sms_groups ON sms_groups.entity_type_id = entity_subscriptions.entity_type_id ";
            mysql = mysql + "WHERE (address.table_name = 'entitys') AND (sms_groups.sms_id = " + rs.getString("sms_id") + ") ";
            BQuery rsg = new BQuery(this.db, mysql);
            while (rsg.moveNext()) {
                number = rsg.getString("mobile");
                if (number == null) {
                    number = "";
                }
                if (number.length() <= 2) continue;
                isSent = this.sendMessage(number.trim(), rs.getString("message"));
            }
            rsg.close();
            if (!isSent) continue;
            rs.recEdit();
            rs.updateField("sent", "true");
            rs.updateField("folder_id", "2");
            rs.recSave();
        }
        rs.close();
    }

    public boolean sendMessage(String number, String message) {
        this.log.info(number + " : " + message);
        if (message == null) {
            return true;
        }
        if (message.equals("null")) {
            return true;
        }
        if (number == null) {
            return true;
        }
        if (number.equals("null")) {
            return true;
        }
        boolean msgsent = false;
        message = message.replace("%", "%25");
        message = message.replace("&", "%26");
        message = message.replace("+", "%2B");
        message = message.replace("#", "%23");
        message = message.replace("=", "%3D");
        message = message.replace("^", "%5E");
        message = message.replace("~", "%7E");
        message = message.replace(" ", "+");
        message = message.replace('@', '\u00a1');
        String murl = this.url + "?username=" + this.username + "&password=" + this.password + "&to=" + number;
        murl = murl + "&text=" + message;
        System.out.println(murl);
        try {
            String inputLine;
            URL kurl = new URL(murl);
            BufferedReader in = new BufferedReader(new InputStreamReader(kurl.openStream()));
            while ((inputLine = in.readLine()) != null) {
                if (inputLine.trim().equals("0: Accepted for delivery")) {
                    msgsent = true;
                } else if (inputLine.trim().equals("3: Queued for later delivery")) {
                    msgsent = true;
                }
                System.out.println(inputLine);
            }
        }
        catch (MalformedURLException ex) {
            this.log.severe("URL Malformed Exception : " + ex);
        }
        catch (IOException ex) {
            this.log.severe("IO Error : " + ex);
        }
        if (msgsent) {
            System.out.println("Message sent");
        } else {
            System.out.println("Message not sent");
        }
        return msgsent;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void close() {
        this.log.info("Closing Kannel SMS Server.");
    }
}

