/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.sms;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class BPDUCode {
    private final char EMPTYCHAR = (char)256;
    private final char EXTTABLEESCAPE = (char)27;
    private char[] gsmToIsoMap;
    private char[] gsmToIsoExtMap;
    private char[] isoToGsmMap;
    private char[] isoToGsmExtMap;
    private char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public BPDUCode() {
        int i;
        char[] gsmiso = new char[]{'\u0000', '@', '\u0002', '$', '\u0011', '_', '\"', '\"'};
        char[] gsmisoext = new char[]{'\u0014', '^', '(', '{', ')', '}', '/', '\\', '<', '[', '=', '~', '>', ']', '@', '|'};
        int lastindex = 255;
        this.gsmToIsoMap = new char[256];
        this.gsmToIsoExtMap = new char[256];
        this.isoToGsmMap = new char[256];
        this.isoToGsmExtMap = new char[256];
        for (i = 0; i <= 255; ++i) {
            this.gsmToIsoExtMap[i] = this.isoToGsmMap[i] = (char)i;
            this.gsmToIsoMap[i] = this.isoToGsmMap[i];
        }
        int gsmisolen = gsmiso.length;
        i = 0;
        while (i + 1 < gsmisolen) {
            this.gsmToIsoMap[gsmiso[i]] = gsmiso[i + 1];
            this.isoToGsmMap[gsmiso[i + 1]] = gsmiso[i];
            i += 2;
        }
        int gsmisoextlen = gsmisoext.length;
        i = 0;
        while (i + 1 < gsmisoextlen) {
            this.gsmToIsoExtMap[gsmisoext[i]] = gsmisoext[i + 1];
            i += 2;
        }
    }

    public String displayTimeDate(Calendar cal) {
        String out = "";
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int zone = cal.get(15) / 3600000 * 4;
        String year_str = String.valueOf(year);
        String month_str = String.valueOf(month);
        String day_str = String.valueOf(day);
        String hour_str = String.valueOf(hour);
        String minute_str = String.valueOf(minute);
        String second_str = String.valueOf(second);
        String zone_str = String.valueOf(zone);
        if (year_str.length() < 2) {
            year_str = "0" + year_str;
        }
        if (month_str.length() < 2) {
            month_str = "0" + month_str;
        }
        if (day_str.length() < 2) {
            day_str = "0" + day_str;
        }
        if (hour_str.length() < 2) {
            hour_str = "0" + hour_str;
        }
        if (minute_str.length() < 2) {
            minute_str = "0" + minute_str;
        }
        if (second_str.length() < 2) {
            second_str = "0" + second_str;
        }
        out = hour_str + ":" + minute_str + ":" + second_str + "  ";
        out = out + day_str + "-" + month_str + "-" + year_str;
        return out;
    }

    public String swapDigits(String str) {
        if (str == null) {
            return str;
        }
        int strlen = str.length();
        StringBuffer sb = new StringBuffer(strlen);
        int i = 0;
        while (i + 1 < strlen) {
            sb.append(str.charAt(i + 1));
            sb.append(str.charAt(i));
            i += 2;
        }
        return new String(sb);
    }

    public String toHexString(int b) {
        char[] digits = new char[]{this.hexDigits[(b &= 0xFF) / 16], this.hexDigits[b % 16]};
        return new String(digits);
    }

    public String sevenBitEncode(String message) {
        if (message == null) {
            return message;
        }
        StringBuffer msg = new StringBuffer(message);
        StringBuffer encmsg = new StringBuffer(320);
        int bb = 0;
        int bblen = 0;
        char o = '\u0000';
        char c = '\u0000';
        for (int i = 0; i < msg.length() || bblen >= 8; ++i) {
            if (i < msg.length()) {
                char tc;
                c = msg.charAt(i);
                c = tc = this.isoToGsmMap[c];
                c = (char)(c & 0xFFFFFF7F);
                bb |= c << bblen;
                bblen += 7;
            }
            while (bblen >= 8) {
                o = (char)(bb & 0xFF);
                encmsg.append(this.toHexString(o));
                bb >>>= 8;
                bblen -= 8;
            }
        }
        if (bblen > 0) {
            encmsg.append(this.toHexString(bb));
        }
        return encmsg.toString();
    }

    public String sevenBitDecode(String encmsg) {
        return this.sevenBitDecode(encmsg, encmsg.length());
    }

    public String sevenBitDecode(String encmsg, int msglen) {
        int r = 0;
        int rlen = 0;
        int olen = 0;
        int charcnt = 0;
        StringBuffer msg = new StringBuffer(160);
        int encmsglen = encmsg.length();
        boolean exttableescape = false;
        int i = 0;
        while (i + 1 < encmsglen && charcnt < msglen) {
            char c;
            String ostr = encmsg.substring(i, i + 2);
            int o = Integer.parseInt(ostr, 16);
            olen = 8;
            if (rlen >= 7) {
                c = (char)(r & 0x7F);
                r >>>= 7;
                rlen -= 7;
                msg.append(c);
                ++charcnt;
            }
            o <<= rlen;
            olen += rlen;
            c = (char)((o |= r) & 0x7F);
            r = o >>>= 7;
            rlen = olen -= 7;
            if ((c = this.gsmToIsoMap[c]) == '\u001b') {
                exttableescape = true;
            } else {
                if (exttableescape) {
                    exttableescape = false;
                    c = this.gsmToIsoExtMap[c];
                }
                msg.append(c);
                ++charcnt;
            }
            i += 2;
        }
        if (rlen > 0 && charcnt < msglen) {
            msg.append((char)r);
        }
        return msg.toString();
    }

    public String TimeStampEncode(Calendar time) {
        int year = time.get(1);
        int month = time.get(2) + 1;
        int day = time.get(5);
        int hour = time.get(11);
        int minute = time.get(12);
        int second = time.get(13);
        int zone = time.get(15) / 3600000 * 4;
        String year_str = String.valueOf(year);
        String month_str = String.valueOf(month);
        String day_str = String.valueOf(day);
        String hour_str = String.valueOf(hour);
        String minute_str = String.valueOf(minute);
        String second_str = String.valueOf(second);
        String zone_str = String.valueOf(zone);
        year_str = year_str.substring(2, 4);
        if (month_str.length() < 2) {
            month_str = "0" + month_str;
        }
        if (day_str.length() < 2) {
            day_str = "0" + day_str;
        }
        if (hour_str.length() < 2) {
            hour_str = "0" + hour_str;
        }
        if (minute_str.length() < 2) {
            minute_str = "0" + minute_str;
        }
        if (second_str.length() < 2) {
            second_str = "0" + second_str;
        }
        if (zone_str.length() < 2) {
            zone_str = "0" + zone_str;
        }
        String out = year_str + month_str + day_str + hour_str + minute_str + second_str + zone_str;
        out = this.swapDigits(out);
        return out;
    }

    public Date TimeStampDecode(String timestamp) {
        timestamp = this.swapDigits(timestamp);
        int year = Integer.parseInt(timestamp.substring(0, 2));
        int month = Integer.parseInt(timestamp.substring(2, 4)) - 1;
        int day = Integer.parseInt(timestamp.substring(4, 6));
        int hour = Integer.parseInt(timestamp.substring(6, 8));
        int minute = Integer.parseInt(timestamp.substring(8, 10));
        int second = Integer.parseInt(timestamp.substring(10, 12));
        int zone = Integer.parseInt(timestamp.substring(10, 12)) * 3600000 / 4;
        GregorianCalendar time = new GregorianCalendar(year, month, day, hour, minute, second);
        return time.getTime();
    }

    public String eightBitDecode(String encmsg) {
        StringBuffer msg = new StringBuffer(160);
        for (int i = 0; i < encmsg.length(); i += 2) {
            String ostr = encmsg.substring(i, i + 2);
            int o = Integer.parseInt(ostr, 16);
            char c = (char)o;
            c = this.gsmToIsoMap[c];
            msg.append(c);
        }
        return msg.toString();
    }

    public String sevenBitEncode(String message, int x) {
        if (message == null) {
            return message;
        }
        StringBuffer msg = new StringBuffer(message);
        StringBuffer encmsg = new StringBuffer(320);
        int bb = 1;
        int bblen = 0;
        char o = '\u0000';
        char c = '\u0000';
        for (int i = 0; i < msg.length() || bblen >= 8; ++i) {
            if (i < msg.length()) {
                char tc;
                c = msg.charAt(i);
                c = tc = this.isoToGsmMap[c];
                if (i == 0) {
                    c = (char)(c & 0xFFFFFF7F);
                    bb |= c << x;
                    bblen += 7 + x;
                } else {
                    c = (char)(c & 0xFFFFFF7F);
                    bb |= c << bblen;
                    bblen += 7;
                }
            }
            while (bblen >= 8) {
                o = (char)(bb & 0xFF);
                encmsg.append(this.toHexString(o));
                bb >>>= 8;
                bblen -= 8;
            }
        }
        if (bblen > 0) {
            encmsg.append(this.toHexString(bb));
        }
        return encmsg.toString();
    }
}

