/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.sms;

import gnu.io.SerialPort;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.baraza.server.sms.BSMSMessage;
import org.baraza.utils.BLogHandle;

public class BSMSend {
    Logger log = Logger.getLogger(BSMSend.class.getName());
    OutputStream outputStream = null;
    boolean DATA_BUFFER;
    BSMSMessage smsmsg;
    private int bufferOffset = 0;
    public final int OK = 1;
    public final int CONNERR = 10;
    private int portStatus = 1;

    public BSMSend(SerialPort port, BLogHandle logHandle) {
        logHandle.config(this.log);
        try {
            this.outputStream = port.getOutputStream();
        }
        catch (IOException ex) {
            this.log.severe("Can't open input stream: write-only : " + ex);
        }
    }

    public void sendMessage(String request) {
        this.log.fine("Writing : " + request);
        try {
            this.outputStream.write(request.getBytes());
        }
        catch (IOException ex) {
            this.portStatus = 10;
            this.log.severe("IO Error on writting to output stream : " + ex);
        }
        this.gotosleep(1000);
    }

    public int getPortStatus() {
        return this.portStatus;
    }

    public void gotosleep(int i) {
        try {
            Thread.sleep(i);
        }
        catch (InterruptedException e) {
            this.log.severe("Sending sleep error");
        }
    }

    public void close() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException ex) {
            this.log.severe("IO Exception on stream close : " + ex);
        }
        this.gotosleep(100);
    }
}

