/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.sqlcron;

import java.util.HashMap;
import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BSQLCron {
    Logger log = Logger.getLogger(BSQLCron.class.getName());
    BDB db = null;
    BElement root = null;
    int delay = 10000;

    public BSQLCron(BDB db, BElement root, BLogHandle logHandle) {
        this.root = root;
        this.db = db;
        logHandle.config(this.log);
        this.delay = Integer.valueOf(root.getAttribute("delay", "1")) * 60 * 1000;
    }

    public int process() {
        this.log.info("--------------- Processing SQL Cron");
        String mysql = "";
        HashMap attr = new HashMap();
        for (BElement el : this.root.getElements()) {
            mysql = el.getAttribute("fnct") == null ? "SELECT " + el.getValue() : "SELECT " + el.getAttribute("fnct") + " as " + el.getValue();
            if (el.getAttribute("table") != null) {
                mysql = mysql + " FROM " + el.getAttribute("table");
            }
            if (el.getAttribute("wheresql") != null) {
                mysql = mysql + " WHERE " + el.getAttribute("wheresql");
            }
            this.db.executeQuery(mysql);
        }
        return this.delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void close() {
        this.db.close();
    }
}

