/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.tomcat;

import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.JDBCRealm;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;

public class BJDBCRealm
extends JDBCRealm {
    Logger log = Logger.getLogger(BJDBCRealm.class.getName());
    private Map<String, String> userList = new HashMap<String, String>();
    private Map<String, String> IPList = new HashMap<String, String>();

    public BJDBCRealm() {
        this.log.info("Authenticating class starting");
    }

    public Principal authenticate(String username, String credentials) {
        Principal principal = super.authenticate(username, credentials);
        if (principal != null) {
            String loginId = this.logUser(principal.getName());
            this.userList.put(username, loginId);
            this.IPList.remove(username);
        }
        return principal;
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        SecurityConstraint[] sc = super.findSecurityConstraints(request, context);
        String userName = request.getRemoteUser();
        if (userName != null && this.IPList.get(userName) == null) {
            String loginId = this.userList.get(userName);
            if (loginId != null) {
                this.logUserIP(loginId, request.getRemoteAddr());
            }
            this.IPList.put(userName, request.getRemoteAddr());
        }
        return sc;
    }

    public String logUser(String userName) {
        String loginId = null;
        try {
            String mysql = "SELECT add_sys_login('" + userName + "')";
            Connection db = this.open();
            Statement st = db.createStatement();
            ResultSet rs = st.executeQuery(mysql);
            db.commit();
            if (rs.next()) {
                loginId = rs.getString(1);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            this.log.severe("Database executeAutoKey error : " + ex);
        }
        return loginId;
    }

    public void logUserIP(String loginId, String userIP) {
        try {
            String mysql = "UPDATE sys_logins SET login_ip = '" + userIP + "' WHERE sys_login_id = " + loginId;
            Connection db = this.open();
            Statement st = db.createStatement();
            st.execute(mysql);
            db.commit();
            st.close();
        }
        catch (SQLException ex) {
            this.log.severe("Database executeAutoKey error : " + ex);
        }
    }
}

