/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.swing;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class BFileDialogueFilter
extends FileFilter {
    private List<String> filters = new ArrayList<String>();
    private String description = "";

    public BFileDialogueFilter(String[] filterArray, String description) {
        for (String filter : filterArray) {
            this.filters.add(filter);
        }
        this.description = description != null ? description : "";
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension == null) {
                return false;
            }
            if (this.filters.contains(extension)) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    @Override
    public String getDescription() {
        String fullDescription = this.description;
        for (String filter : this.filters) {
            fullDescription = fullDescription + ", ." + filter;
        }
        return fullDescription;
    }
}

