/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.baraza.utils.Bio;
import org.baraza.xml.BElement;
import org.baraza.xml.BTreeNode;

public class BImageTree
extends JTree
implements Autoscroll,
ActionListener {
    JPopupMenu popup;
    JMenuItem mi;
    DefaultTreeModel treeModel;
    BTreeNode oldNode = null;
    BTreeNode oldParentNode = null;
    int nodeStatus = 0;
    private BufferedImage img = null;
    private int iw;
    private int ih;
    private int margin = 12;

    public BImageTree(String imgFileName, DefaultTreeModel treeModel, boolean hasMenu) {
        super(treeModel);
        super.setOpaque(false);
        this.treeModel = treeModel;
        Bio io = new Bio();
        this.img = io.loadImage(imgFileName);
        this.iw = this.img.getWidth();
        this.ih = this.img.getHeight();
        this.popup = new JPopupMenu();
        if (hasMenu) {
            String[] mnArray = new String[]{"Copy", "Cut", "Insert", "Paste", "New", "Delete"};
            for (int i = 0; i < mnArray.length; ++i) {
                this.mi = new JMenuItem(mnArray[i]);
                this.mi.addActionListener(this);
                this.popup.add(this.mi);
            }
            this.popup.setOpaque(true);
            this.popup.setLightWeightPopupEnabled(true);
            this.setComponentPopupMenu(this.popup);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            if (ev.getActionCommand().equals("Copy")) {
                this.oldNode = (BTreeNode)path.getLastPathComponent();
                this.nodeStatus = 1;
            } else if (ev.getActionCommand().equals("Cut")) {
                this.oldNode = (BTreeNode)path.getLastPathComponent();
                this.oldParentNode = (BTreeNode)path.getParentPath().getLastPathComponent();
                this.nodeStatus = 2;
            } else if (ev.getActionCommand().equals("Insert")) {
                BTreeNode parentNode = (BTreeNode)path.getParentPath().getLastPathComponent();
                BTreeNode selectedNode = (BTreeNode)path.getLastPathComponent();
                int i = parentNode.getIndex(selectedNode);
                if (this.nodeStatus == 1) {
                    BElement newEl = this.oldNode.getKey().copy();
                    BTreeNode newNode = this.makeNode(newEl);
                    parentNode.insert(newNode, i);
                    parentNode.getKey().addNode(newNode.getKey(), i);
                } else if (this.nodeStatus == 2) {
                    if (this.oldParentNode != null) {
                        this.oldParentNode.getKey().delNode(this.oldNode.getKey());
                    }
                    parentNode.insert(this.oldNode, i);
                    parentNode.getKey().addNode(this.oldNode.getKey(), i);
                    if (this.oldParentNode != null) {
                        this.treeModel.reload(this.oldParentNode);
                    }
                }
                this.treeModel.reload(parentNode);
            } else if (ev.getActionCommand().equals("Paste")) {
                if (this.nodeStatus == 1) {
                    BElement newEl = this.oldNode.getKey().copy();
                    BTreeNode newNode = this.makeNode(newEl);
                    BTreeNode selectedNode = (BTreeNode)path.getLastPathComponent();
                    selectedNode.add(newNode);
                    selectedNode.getKey().addNode(newNode.getKey());
                    this.treeModel.reload(selectedNode);
                } else if (this.nodeStatus == 2) {
                    BTreeNode selectedNode = (BTreeNode)path.getLastPathComponent();
                    if (this.oldParentNode != null) {
                        this.oldParentNode.getKey().delNode(this.oldNode.getKey());
                    }
                    selectedNode.add(this.oldNode);
                    selectedNode.getKey().addNode(this.oldNode.getKey());
                    this.treeModel.reload(selectedNode);
                    if (this.oldParentNode != null) {
                        this.treeModel.reload(this.oldParentNode);
                    }
                }
            } else if (ev.getActionCommand().equals("New")) {
                BTreeNode selectedNode = (BTreeNode)path.getLastPathComponent();
                if (selectedNode != null) {
                    BTreeNode newNode = this.makeNode(new BElement("NODE"));
                    selectedNode.add(newNode);
                    selectedNode.getKey().addNode(newNode.getKey());
                    this.treeModel.reload(selectedNode);
                }
            } else if (ev.getActionCommand().equals("Delete")) {
                BTreeNode selectedNode = (BTreeNode)path.getLastPathComponent();
                BTreeNode parentNode = (BTreeNode)path.getParentPath().getLastPathComponent();
                if (parentNode != null) {
                    parentNode.getKey().delNode(selectedNode.getKey());
                    parentNode.remove(selectedNode);
                    this.treeModel.reload(parentNode);
                }
            }
        }
    }

    public BTreeNode makeNode(BElement sbn) {
        String title = sbn.getName() + " : ";
        if (sbn.getAttribute("title") != null) {
            title = title + sbn.getAttribute("title");
        } else if (sbn.getAttribute("name") != null) {
            title = title + sbn.getAttribute("name");
        }
        BTreeNode firstNode = new BTreeNode(sbn, title);
        for (BElement el : sbn.getElements()) {
            firstNode.add(this.makeNode(el));
        }
        return firstNode;
    }

    @Override
    public void autoscroll(Point p) {
        int realrow = this.getRowForLocation(p.x, p.y);
        Rectangle outer = this.getBounds();
        realrow = p.y + outer.y <= this.margin ? (realrow < 1 ? 0 : realrow - 1) : (realrow < this.getRowCount() - 1 ? realrow + 1 : realrow);
        this.scrollRowToVisible(realrow);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle outer = this.getBounds();
        Rectangle inner = this.getParent().getBounds();
        return new Insets(inner.y - outer.y + this.margin, inner.x - outer.x + this.margin, outer.height - inner.height - inner.y + outer.y + this.margin, outer.width - inner.width - inner.x + outer.x + this.margin);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.img != null) {
            Dimension d = this.getSize();
            int w = (int)d.getWidth();
            int h = (int)d.getHeight();
            g.drawImage(this.img, 0, 0, w, h, 0, 0, this.iw, this.ih, null);
        }
        super.paintComponent(g);
    }
}

