/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.swing;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.baraza.swing.BFindReplaceDialog;
import org.baraza.utils.BLogHandle;

public class BTextArea
extends JTextArea
implements KeyListener,
MouseListener,
ClipboardOwner,
UndoableEditListener,
ActionListener {
    UndoManager undo;
    JPopupMenu contextMenu;
    JMenuItem mnuCopy;
    JMenuItem mnuPaste;
    JMenuItem mnuCut;
    JMenuItem mnuUndo;
    JMenuItem mnuRedo;
    Logger log = Logger.getLogger(BTextArea.class.getName());
    int undoCounter;

    public BTextArea(BLogHandle logHandle) {
        this.undo = new UndoManager();
        this.getDocument().addUndoableEditListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.undoCounter = 0;
        logHandle.config(this.log);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.undo.addEdit(e.getEdit());
        ++this.undoCounter;
    }

    public void BUndo() {
        if (this.undoCounter <= 0) {
            this.log.info("Cannot Undo Further : " + this.undoCounter);
        } else {
            try {
                this.undo.undo();
                --this.undoCounter;
            }
            catch (CannotUndoException ex) {
                this.log.info("Unable to undo: " + ex);
                ex.printStackTrace();
            }
        }
    }

    public void BRedo() {
        if (this.undoCounter >= this.undo.getLimit()) {
            this.log.info("Cannot ReDo Further : " + this.undoCounter + "\nLimit : " + this.undo.getLimit());
        } else {
            try {
                this.undo.redo();
                ++this.undoCounter;
            }
            catch (CannotRedoException ex) {
                this.log.info("Unable to redo:Counter " + this.undoCounter + "\nLimit : " + this.undo.getLimit() + "\nUnable to redo: " + ex);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isControlDown() && e.getKeyCode() == 90) {
            this.BUndo();
        } else if (e.isControlDown() && e.getKeyCode() == 89) {
            this.BRedo();
        } else if (e.isControlDown() && e.getKeyCode() == 70) {
            this.findReplace();
        }
    }

    public void findReplace() {
        BFindReplaceDialog fr = new BFindReplaceDialog(this);
        fr.setVisible(true);
        fr.setLocationRelativeTo(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.contextMenu = new JPopupMenu();
            this.contextMenu.setBackground(Color.LIGHT_GRAY);
            this.mnuCopy = new JMenuItem("Copy");
            this.mnuPaste = new JMenuItem("Paste");
            this.mnuCut = new JMenuItem("Cut");
            this.mnuUndo = new JMenuItem("Undo");
            this.mnuRedo = new JMenuItem("Redo");
            this.mnuCopy.addActionListener(this);
            this.mnuPaste.addActionListener(this);
            this.mnuCut.addActionListener(this);
            this.mnuUndo.addActionListener(this);
            this.mnuRedo.addActionListener(this);
            this.contextMenu.add(this.mnuCopy);
            this.contextMenu.add(this.mnuPaste);
            this.contextMenu.add(this.mnuCut);
            this.contextMenu.add(this.mnuUndo);
            this.contextMenu.add(this.mnuRedo);
            this.contextMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log.info("ACTION : " + e.getActionCommand());
        if (e.getActionCommand().equals(this.mnuCopy.getActionCommand())) {
            String toCopy = this.getSelectedText();
            this.setClipboardContents(toCopy);
        } else if (e.getActionCommand().equals(this.mnuPaste.getActionCommand())) {
            this.insert(this.getClipboardContents(), this.getCaretPosition());
        } else if (e.getActionCommand().equals(this.mnuCut.getActionCommand())) {
            this.setClipboardContents(this.getSelectedText());
            this.replaceSelection("");
        } else if (e.getActionCommand().equals(this.mnuUndo.getActionCommand())) {
            this.BUndo();
        } else if (e.getActionCommand().equals(this.mnuRedo.getActionCommand())) {
            this.BRedo();
        }
    }

    public void setClipboardContents(String aString) {
        StringSelection stringSelection = new StringSelection(aString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    public String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException | IOException ex) {
                this.log.info(" : " + ex);
                ex.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

