/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.utils;

import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JTextArea;
import org.baraza.utils.Bio;
import org.baraza.xml.BElement;

public class BLogHandle
extends Handler {
    JTextArea statusBar = null;
    String logFile = null;
    Level logLevel = Level.INFO;

    public BLogHandle() {
        this.statusBar = new JTextArea();
    }

    public BLogHandle(JTextArea statusBar) {
        this.statusBar = statusBar;
    }

    public BLogHandle(BElement root) {
        this.logFile = root.getAttribute("logfile");
        this.setLogLevel(root);
    }

    public BLogHandle(String logFile) {
        this.logFile = logFile;
    }

    public void setLogLevel(BElement root) {
        this.logLevel = Level.parse(root.getAttribute("loglevel", "INFO").toUpperCase());
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public void config(Logger logger) {
        this.removeHandle(logger);
        if (this.statusBar != null) {
            BLogHandle nlgh = new BLogHandle(this.statusBar);
            nlgh.setLogLevel(this.logLevel);
            logger.addHandler(nlgh);
        } else {
            BLogHandle nlgh = new BLogHandle(this.logFile);
            nlgh.setLogLevel(this.logLevel);
            logger.addHandler(nlgh);
        }
        logger.setUseParentHandlers(false);
        logger.setLevel(this.logLevel);
    }

    public void removeHandle(Logger logger) {
        Handler[] myha;
        for (Handler myh : myha = logger.getHandlers()) {
            logger.removeHandler(myh);
        }
    }

    public JTextArea getStatusBar() {
        return this.statusBar;
    }

    @Override
    public void publish(LogRecord logRecord) {
        Date date = new Date();
        String errDf = date.toString() + " " + logRecord.getSourceClassName() + " ";
        errDf = errDf + logRecord.getSourceMethodName() + "\n";
        String errMsg = logRecord.getLevel() + " : " + logRecord.getMessage();
        if (this.logFile != null) {
            Bio io = new Bio();
            errMsg = errDf + errMsg + "\n";
            io.saveFile(this.logFile, errMsg, true);
        } else if (this.statusBar != null) {
            this.statusBar.setText(errMsg);
        } else {
            System.out.println(errDf + errMsg);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

