/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.baraza.DB.BUser;
import org.baraza.xml.BElement;

public class BWebUtils {
    static Logger log = Logger.getLogger(BWebUtils.class.getName());

    public static void showHeaders(HttpServletRequest request) {
        System.out.println("HEADERS ------- ");
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            System.out.println(headerName);
            request.getHeader(headerName);
            Enumeration headers = request.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String headerValue = (String)headers.nextElement();
                System.out.println("\t" + headerValue);
            }
        }
        System.out.print("\n");
    }

    public static void showParameters(HttpServletRequest request) {
        System.out.println("PARAMETERS ------- ");
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String paramName = (String)en.nextElement();
            System.out.println(paramName + " : " + request.getParameter(paramName));
        }
        System.out.print("\n");
    }

    public static String createToken(String userId) {
        String token = null;
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)"demo$secret");
            token = JWT.create().withIssuer("auth0").withSubject(userId).sign(algorithm);
        }
        catch (UnsupportedEncodingException ex) {
            log.severe("UnsupportedEncodingException : " + ex);
        }
        catch (JWTCreationException ex) {
            log.severe("JWTCreationException : " + (Object)((Object)ex));
        }
        return token;
    }

    public static String decodeToken(String token) {
        String payLoad = null;
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)"demo$secret");
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer("auth0").build();
            DecodedJWT jwt = verifier.verify(token);
            payLoad = jwt.getSubject();
        }
        catch (UnsupportedEncodingException ex) {
            log.severe("UnsupportedEncodingException : " + ex);
        }
        catch (JWTVerificationException ex) {
            log.severe("JWTVerificationException : " + (Object)((Object)ex));
        }
        return payLoad;
    }

    public static String requestBody(HttpServletRequest request) {
        StringBuffer jb = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                jb.append(line);
            }
        }
        catch (IOException ex) {
            log.severe("JWTVerificationException : " + ex);
        }
        return jb.toString();
    }

    public static int getViewType(String viewTypeName) {
        int type = 0;
        if (viewTypeName == null) {
            type = 0;
        } else if (viewTypeName.equals("ACCORDION")) {
            type = 1;
        } else if (viewTypeName.equals("CROSSTAB")) {
            type = 2;
        } else if (viewTypeName.equals("DASHBOARD")) {
            type = 3;
        } else if (viewTypeName.equals("DIARY")) {
            type = 4;
        } else if (viewTypeName.equals("FILES")) {
            type = 5;
        } else if (viewTypeName.equals("FILTER")) {
            type = 6;
        } else if (viewTypeName.equals("FORM")) {
            type = 7;
        } else if (viewTypeName.equals("FORMVIEW")) {
            type = 8;
        } else if (viewTypeName.equals("GRID")) {
            type = 9;
        } else if (viewTypeName.equals("JASPER")) {
            type = 10;
        } else if (viewTypeName.equals("TABLEVIEW")) {
            type = 11;
        }
        return type;
    }

    public static int getFieldType(String fieldTypeName) {
        int type = 0;
        if (fieldTypeName == null) {
            type = 0;
        } else if (fieldTypeName.equals("TEXTFIELD")) {
            type = 0;
        } else if (fieldTypeName.equals("TEXTAREA")) {
            type = 1;
        } else if (fieldTypeName.equals("CHECKBOX")) {
            type = 2;
        } else if (fieldTypeName.equals("TEXTTIME")) {
            type = 3;
        } else if (fieldTypeName.equals("TEXTDATE")) {
            type = 4;
        } else if (fieldTypeName.equals("TEXTTIMESTAMP")) {
            type = 5;
        } else if (fieldTypeName.equals("SPINTIME")) {
            type = 6;
        } else if (fieldTypeName.equals("SPINDATE")) {
            type = 7;
        } else if (fieldTypeName.equals("SPINTIMESTAMP")) {
            type = 8;
        } else if (fieldTypeName.equals("TEXTDECIMAL")) {
            type = 9;
        } else if (fieldTypeName.equals("COMBOLIST")) {
            type = 10;
        } else if (fieldTypeName.equals("COMBOBOX")) {
            type = 11;
        } else if (fieldTypeName.equals("GRIDBOX")) {
            type = 12;
        } else if (fieldTypeName.equals("DEFAULT")) {
            type = 13;
        } else if (fieldTypeName.equals("EDITOR")) {
            type = 14;
        } else if (fieldTypeName.equals("FUNCTION")) {
            type = 15;
        } else if (fieldTypeName.equals("USERFIELD")) {
            type = 16;
        } else if (fieldTypeName.equals("USERNAME")) {
            type = 17;
        } else if (fieldTypeName.equals("PICTURE")) {
            type = 18;
        } else if (fieldTypeName.equals("LOCATION")) {
            type = 19;
        }
        return type;
    }

    public static boolean canDisplayField(String fieldTypeName) {
        boolean canDisplay = true;
        if (fieldTypeName == null) {
            canDisplay = false;
        } else if (fieldTypeName.equals("DEFAULT")) {
            canDisplay = false;
        } else if (fieldTypeName.equals("FUNCTION")) {
            canDisplay = false;
        } else if (fieldTypeName.equals("USERFIELD")) {
            canDisplay = false;
        } else if (fieldTypeName.equals("USERNAME")) {
            canDisplay = false;
        } else if (fieldTypeName.equals("FORMVIEW")) {
            canDisplay = false;
        } else if (fieldTypeName.equals("LOCATION")) {
            canDisplay = false;
        }
        return canDisplay;
    }

    public static boolean checkInjection(String filterValue) {
        if (filterValue == null) {
            return false;
        }
        if (filterValue.toLowerCase().contains("select")) {
            return true;
        }
        if (filterValue.toLowerCase().contains("update")) {
            return true;
        }
        if (filterValue.toLowerCase().contains("insert")) {
            return true;
        }
        return filterValue.toLowerCase().contains("delete");
    }

    public static String comboboxSQL(BElement el, BUser user, String orgID, String formLinkData) {
        String orderBySql;
        String selectDetail = el.getAttribute("select.detail");
        String lptable = el.getAttribute("lptable");
        String lpfield = el.getAttribute("lpfield");
        String lpkey = el.getAttribute("lpkey");
        String cmb_fnct = el.getAttribute("cmb_fnct");
        if (lpkey == null) {
            lpkey = el.getValue();
        }
        String userOrg = null;
        if (user != null) {
            userOrg = user.getUserOrg();
        }
        String mysql = "";
        mysql = lpkey.equals(lpfield) ? "SELECT " + lpfield : (cmb_fnct == null ? "SELECT " + lpkey + ", " + lpfield : "SELECT " + lpkey + ", (" + cmb_fnct + ") as " + lpfield);
        if (selectDetail != null) {
            mysql = mysql + ", " + selectDetail;
        }
        mysql = mysql + " FROM " + lptable;
        String cmbWhereSql = el.getAttribute("where");
        if (el.getAttribute("noorg") == null && orgID != null && userOrg != null) {
            cmbWhereSql = cmbWhereSql == null ? "(" : cmbWhereSql + " AND (";
            cmbWhereSql = el.getAttribute("org.id") == null ? cmbWhereSql + orgID + "=" + userOrg + ")" : cmbWhereSql + el.getAttribute("org.id") + "=" + userOrg + ")";
        }
        if (el.getAttribute("user") != null) {
            String userFilter = "(" + el.getAttribute("user") + " = '" + user.getUserID() + "')";
            cmbWhereSql = cmbWhereSql == null ? userFilter : cmbWhereSql + " AND " + userFilter;
        }
        String tableFilter = null;
        String linkField = el.getAttribute("linkfield");
        if (linkField != null && formLinkData != null) {
            tableFilter = el.getAttribute("linkfnct") == null ? linkField + " = '" + formLinkData + "'" : linkField + " = " + el.getAttribute("linkfnct") + "('" + formLinkData + "')";
            cmbWhereSql = cmbWhereSql == null ? "(" + tableFilter + ")" : cmbWhereSql + " AND (" + tableFilter + ")";
        }
        if (cmbWhereSql != null) {
            mysql = mysql + " WHERE " + cmbWhereSql;
        }
        mysql = (orderBySql = el.getAttribute("orderby")) == null ? mysql + " ORDER BY " + lpfield : mysql + " ORDER BY " + orderBySql;
        return mysql;
    }
}

