/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BAppLauncher
extends HttpServlet {
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String jnlp = request.getParameter("jnlp");
        try {
            PrintWriter out = response.getWriter();
            if (jnlp == null) {
                response.setContentType("text/html;charset=\"utf-8\"");
                out.println(this.getApplet(request));
            } else {
                response.setContentType("application/x-java-jnlp-file");
                response.setHeader("Content-Disposition", "attachment; filename=app.jnlp");
                out.println(this.getApp(request));
            }
        }
        catch (IOException ex) {
            System.out.println("ERROR : Cannot get writer from response : " + ex);
        }
    }

    public String getApplet(HttpServletRequest request) {
        String rurl = request.getRequestURI();
        int locDot = rurl.indexOf(".");
        String appBase = rurl.substring(0, locDot);
        String appMap = rurl.substring(locDot + 1, rurl.length()) + ".xml";
        String scPath = request.getServletPath().replace("/", "");
        ServletContext sc = this.getServletContext();
        String appDB = sc.getInitParameter("app_db");
        String encryptionKey = sc.getInitParameter("encryptionkey");
        if (encryptionKey != null) {
            if (encryptionKey.length() > 0) {
                appMap = rurl.substring(locDot + 1, rurl.length()) + ".cph";
            } else {
                encryptionKey = null;
            }
        }
        String appPath = "http://" + request.getLocalAddr() + ":" + request.getLocalPort() + appBase + "/projects/";
        String archive = "http://" + request.getLocalAddr() + ":" + request.getLocalPort() + appBase + "/baraza.jar";
        String dbPath = "jdbc:postgresql://" + request.getLocalAddr() + "/" + appDB;
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "run";
        }
        String appStr = "<html>\n";
        appStr = appStr + "<head>\n<title>baraza project</title>\n</head>\n";
        appStr = appStr + "<body>\n";
        appStr = appStr + "\t<applet code='org.baraza.Baraza.class' archive='" + archive + "' width='940' height='590'>\n";
        appStr = appStr + "\t\t<param name='config' value='" + appPath + "'/>\n";
        appStr = appStr + "\t\t<param name='mode' value='" + mode + "'/>\n";
        appStr = appStr + "\t\t<param name='dbpath' value='" + dbPath + "'/>\n";
        appStr = appStr + "\t\t<param name='configfile' value='" + appMap + "'/>\n";
        if (encryptionKey != null) {
            appStr = appStr + "\t\t<param name='encryptionkey' value='" + encryptionKey + "'/>\n";
        }
        appStr = appStr + "\t\t<param name='permissions' value='all-permissions'/>\n";
        appStr = appStr + "\t</applet>\n";
        appStr = appStr + "\t<hr width='100%'>\n";
        appStr = appStr + "\t<a href='" + scPath + "?jnlp=yes'>launch the application</a>\n";
        appStr = appStr + "\t<p><a href='http://www.openbaraza.org' target='_blank'>An open baraza project</a> |\n";
        appStr = appStr + "\t<a href='http://www.dewcis.com' target='_blank'>Developed by Dew CIS Solutions Ltd - kenya</a></b></p>\n";
        appStr = appStr + "</body>\n";
        appStr = appStr + "</html>\n";
        return appStr;
    }

    public String getApp(HttpServletRequest request) {
        String rurl = request.getRequestURI();
        int locDot = rurl.indexOf(".");
        String appBase = rurl.substring(0, locDot);
        String appMap = rurl.substring(locDot + 1, rurl.length()) + ".xml";
        ServletContext sc = this.getServletContext();
        String appDB = sc.getInitParameter("app_db");
        String encryptionKey = sc.getInitParameter("encryptionkey");
        if (encryptionKey != null) {
            if (encryptionKey.length() > 0) {
                appMap = rurl.substring(locDot + 1, rurl.length()) + ".cph";
            } else {
                encryptionKey = null;
            }
        }
        String codeBase = "http://" + request.getLocalAddr() + ":" + request.getLocalPort() + appBase;
        String appPath = codeBase + "/projects/";
        String dbPath = "jdbc:postgresql://" + request.getLocalAddr() + "/" + appDB;
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "run";
        }
        String appStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        appStr = appStr + "<jnlp codebase=\"" + codeBase + "\">\n";
        appStr = appStr + "\t<information>\n";
        appStr = appStr + "\t\t<title>Baraza Project</title>\n";
        appStr = appStr + "\t\t<vendor>Dew Cis Solutions Ltd</vendor>\n";
        appStr = appStr + "\t\t<description>The Dew Cis Solutions, Baraza Project</description>\n";
        appStr = appStr + "\t\t<icon href=\"resources/baraza_logo.jpg\"/>\n";
        appStr = appStr + "\t</information>\n";
        appStr = appStr + "\t<resources>\n";
        appStr = appStr + "\t\t<j2se version=\"1.5+\" initial-heap-size=\"64m\" max-heap-size=\"128m\"/>\n";
        appStr = appStr + "\t\t<jar href=\"baraza.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/activation-1.1.1.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/barbecue-1.5-beta1.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/commons-beanutils-1.9.0.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/commons-collections-3.2.2.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/commons-codec-1.9.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/commons-digester-2.1.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/commons-logging-1.1.1.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/commons-lang-2.6.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/groovy-all-2.4.3.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/itext-2.1.7.js5.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/jasperreports-6.3.0.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/jcommon-1.0.15.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/jfreechart-1.0.12.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/mail.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/poi-3.10.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/postgresql-9.4.1208.jre7.jar\"/>\n";
        appStr = appStr + "\t\t<jar href=\"lib/server/tomcat-embed-core.jar\"/>\n";
        appStr = appStr + "\t</resources>\n";
        appStr = appStr + "\t<application-desc main-class=\"org.baraza.Baraza\">\n";
        appStr = appStr + "\t\t<argument>" + mode + "</argument>\n";
        appStr = appStr + "\t\t<argument>" + appPath + "</argument>\n";
        appStr = appStr + "\t\t<argument>" + dbPath + "</argument>\n";
        appStr = appStr + "\t\t<argument>" + appMap + "</argument>\n";
        if (encryptionKey != null) {
            appStr = appStr + "\t\t<argument>" + encryptionKey + "</argument>\n";
        }
        appStr = appStr + "\t</application-desc>\n";
        appStr = appStr + "\t<security>\n";
        appStr = appStr + "\t\t<all-permissions/>\n";
        appStr = appStr + "\t</security>\n";
        appStr = appStr + "</jnlp>\n";
        return appStr;
    }
}

