/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.baraza.DB.BDB;
import org.baraza.DB.BUser;
import org.baraza.reports.BWebReport;
import org.baraza.web.BWeb;
import org.baraza.xml.BElement;

public class BShowReport
extends HttpServlet {
    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        ServletContext context = this.getServletContext();
        HttpSession session = request.getSession(true);
        String xmlcnf = request.getParameter("xml");
        if (xmlcnf == null) {
            xmlcnf = (String)session.getAttribute("xmlcnf");
        }
        String ps = System.getProperty("file.separator");
        String xmlfile = context.getRealPath("WEB-INF") + ps + "configs" + ps + xmlcnf;
        String reportPath = context.getRealPath("reports") + ps;
        String dbconfig = "java:/comp/env/jdbc/database";
        String projectDir = context.getInitParameter("projectDir");
        if (projectDir != null) {
            xmlfile = projectDir + ps + "configs" + ps + xmlcnf;
            reportPath = projectDir + ps + "reports" + ps;
        }
        BWeb web = new BWeb(dbconfig, xmlfile, context);
        web.init(request);
        BDB db = web.getDB();
        BUser user = web.getUser();
        String reportType = request.getParameter("report");
        if (reportType == null) {
            reportType = "pdf";
        }
        BWebReport webreport = new BWebReport(web.getView(), user.getUserID(), user.getGroupID(), request);
        if (reportType.equals("pdf")) {
            webreport.getReport(db, db.getUser(), request, response, 0);
        }
        if (reportType.equals("excel")) {
            webreport.getReport(db, db.getUser(), request, response, 1);
        }
        if (reportType.equals("direct")) {
            BElement view = web.getView();
            String reportName = view.getAttribute("reportfile");
            webreport.getDirectReport(db, db.getUser(), request, response, reportPath, reportName);
        }
        web.close();
    }
}

