/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.baraza.DB.BDB;
import org.baraza.DB.BImportVector;
import org.baraza.DB.BQuery;
import org.baraza.utils.BWebdav;
import org.baraza.web.BWeb;
import org.baraza.xml.BElement;

public class BWebFiles
extends HttpServlet {
    BWeb web = null;
    BWebdav webdav = null;
    BElement view = null;
    BDB db = null;
    BQuery query = null;
    String fileTable = null;
    String linkField = null;
    String linkValue = null;
    String userField = null;
    String folder = null;
    long maxfs = 0L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String sp = request.getServletPath();
        this.configure(request);
        String resp = null;
        if (this.view.getName().equals("GRID")) {
            resp = this.importFile(request);
        }
        if (this.view.getName().equals("FILES")) {
            if (sp.equals("/barazafiles")) {
                this.getFile(request, response);
            }
            if (sp.equals("/webdavfiles")) {
                this.getWebDavFile(request, response);
            }
            if (sp.equals("/putbarazafiles")) {
                resp = this.receiveFile(request);
            }
            if (sp.equals("/delbarazafiles")) {
                this.delFile(request, response);
            }
        }
        if (resp != null) {
            response.setContentType("application/json;charset=\"utf-8\"");
            try {
                PrintWriter out = response.getWriter();
                out.println(resp);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.query.close();
        this.web.close();
    }

    public void configure(HttpServletRequest request) {
        ServletContext context = this.getServletContext();
        HttpSession session = request.getSession(true);
        String dbconfig = "java:/comp/env/jdbc/database";
        String xmlcnf = (String)session.getAttribute("xmlcnf");
        String ps = System.getProperty("file.separator");
        String xmlfile = context.getRealPath("WEB-INF") + ps + "configs" + ps + xmlcnf;
        String projectDir = context.getInitParameter("projectDir");
        if (projectDir != null) {
            xmlfile = projectDir + ps + "configs" + ps + xmlcnf;
        }
        String webPath = "http://" + request.getLocalAddr() + ":" + request.getLocalPort();
        this.web = new BWeb(dbconfig, xmlfile, context);
        this.web.init(request);
        this.view = this.web.getView();
        this.maxfs = Long.valueOf(this.view.getAttribute("maxfilesize", "16777216"));
        this.fileTable = this.view.getAttribute("filetable");
        this.linkField = this.view.getAttribute("linkfield");
        this.userField = this.view.getAttribute("user");
        this.linkValue = this.web.getDataItem();
        if (this.view.getName().equals("FILES")) {
            String repository = webPath + this.view.getAttribute("repository");
            String username = this.view.getAttribute("username");
            String password = this.view.getAttribute("password");
            this.folder = this.view.getAttribute("folder");
            if (repository != null) {
                this.webdav = new BWebdav(repository, username, password);
            }
            System.out.println("BASE 1020 : " + repository);
        }
        this.db = this.web.getDB();
        this.query = new BQuery(this.db, this.view, null, null, false);
        System.out.println(this.linkValue);
    }

    public String importFile(HttpServletRequest request) {
        String resp = "{\"success\": 0, \"message\": \"Upload Failed\"}";
        JsonObjectBuilder jshd = Json.createObjectBuilder();
        int yourMaxMemorySize = 262144;
        ServletContext sc = this.getServletContext();
        String tmpPath = sc.getRealPath("/WEB-INF/tmp");
        File yourTempDirectory = new File(tmpPath);
        String fileName = null;
        DiskFileItemFactory factory = new DiskFileItemFactory(yourMaxMemorySize, yourTempDirectory);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            String orgID = this.db.getOrgID();
            String userOrg = this.db.getUserOrg();
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField()) {
                    String name = item.getFieldName();
                    String value = item.getString();
                    System.out.println(name + " = " + value);
                    continue;
                }
                String contentType = item.getContentType();
                String fieldName = item.getFieldName();
                fileName = item.getName();
                long fs = item.getSize();
                if (fs >= this.maxfs) continue;
                System.out.println("BASE IMPORT 1410 : " + fileName);
                String importType = this.view.getAttribute("import");
                BImportVector iv = new BImportVector(this.view);
                if (importType.equals("excel")) {
                    String worksheet = this.view.getAttribute("worksheet", "0");
                    Integer firstRow = new Integer(this.view.getAttribute("firstrow", "0"));
                    iv.getExcelData(item.getInputStream(), fileName, worksheet, firstRow);
                } else if (importType.equals("text")) {
                    iv.getTextData(item.getInputStream());
                } else if (importType.equals("record")) {
                    iv.getRecordData(item.getInputStream());
                }
                this.query.importData(iv.getData());
                iv.close();
                jshd.add("success", 1);
                jshd.add("name", item.getName());
                jshd.add("size", item.getSize());
                jshd.add("message", "Process File");
                JsonObject jsObj = jshd.build();
                resp = jsObj.toString();
            }
        }
        catch (FileUploadException ex) {
            System.out.println("File upload exception " + (Object)((Object)ex));
        }
        catch (IOException ex) {
            System.out.println("File saving failed IO Exception " + ex);
        }
        catch (Exception ex) {
            System.out.println("File saving failed Exception " + ex);
        }
        System.out.println("BASE IMPORT 1420 : " + resp);
        return resp;
    }

    public String receiveFile(HttpServletRequest request) {
        String resp = "{\"success\": 0, \"message\": \"Upload Failed\"}";
        int yourMaxMemorySize = 262144;
        ServletContext sc = this.getServletContext();
        String tmpPath = sc.getRealPath("/WEB-INF/tmp");
        File yourTempDirectory = new File(tmpPath);
        DiskFileItemFactory factory = new DiskFileItemFactory(yourMaxMemorySize, yourTempDirectory);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            List items = upload.parseRequest(request);
            Iterator itr = items.iterator();
            String narrative = request.getParameter("narrative");
            while (itr.hasNext()) {
                FileItem item = (FileItem)itr.next();
                if (item.isFormField()) {
                    String name = item.getFieldName();
                    String value = item.getString();
                    System.out.println(name + " = " + value);
                    continue;
                }
                String contentType = item.getContentType();
                String fieldName = item.getFieldName();
                String fileName = item.getName();
                long fs = item.getSize();
                if (fs >= this.maxfs) continue;
                System.out.println("BASE 1410 : " + fileName);
                String orgID = this.db.getOrgID();
                String userOrg = this.db.getUserOrg();
                String userID = this.db.getUserID();
                System.out.println("BASE 1420 : " + orgID + " : " + userOrg + " : " + userID);
                System.out.println("BASE 1405 : " + narrative);
                this.query.recAdd();
                this.query.updateField("file_name", fileName);
                if (this.linkField != null) {
                    this.query.updateField(this.linkField, this.linkValue);
                }
                if (this.userField != null) {
                    this.query.updateField(this.userField, userID);
                }
                if (this.fileTable != null) {
                    this.query.updateField("table_name", this.fileTable);
                }
                if (contentType != null) {
                    this.query.updateField("file_type", contentType);
                }
                if (narrative != null) {
                    this.query.updateField("narrative", narrative);
                }
                if (orgID != null) {
                    this.query.updateField(orgID, userOrg);
                }
                this.query.updateField("file_size", String.valueOf(fs));
                String ext = ".dat";
                if (fileName.lastIndexOf(".") > 0) {
                    ext = fileName.substring(fileName.lastIndexOf("."));
                }
                if (ext == null) {
                    ext = ".dat";
                }
                this.query.recSave();
                String folder_name = "";
                if (this.folder != null) {
                    folder_name = this.query.getString(this.folder) + "/";
                    System.out.println("BASE 1420 : " + folder_name);
                    if (!this.webdav.fileExists(folder_name)) {
                        this.webdav.createDir(folder_name);
                    }
                    this.webdav.listDir(folder_name);
                }
                String wdfn = folder_name + this.query.getKeyField() + "ob" + ext;
                System.out.println("BASE 1440 : " + wdfn);
                this.webdav.saveFile(item.getInputStream(), wdfn);
            }
            resp = "{\"success\": 1, ";
            if (narrative != null) {
                resp = resp + "\"narrative\": \"" + narrative + "\", ";
            }
            resp = resp + "\"message\": \"Upload Sucessful\"}";
        }
        catch (FileUploadException ex) {
            System.out.println("File upload exception " + (Object)((Object)ex));
        }
        catch (IOException ex) {
            System.out.println("File saving failed IO Exception " + ex);
        }
        catch (Exception ex) {
            System.out.println("File saving failed Exception " + ex);
        }
        return resp;
    }

    public void getFile(HttpServletRequest request, HttpServletResponse response) {
        String wdfn = request.getParameter("fileid");
        if (wdfn != null) {
            this.query.filter(this.query.getKeyFieldName() + " = '" + wdfn + "'", null);
            this.query.moveFirst();
            String folder_name = "";
            if (this.folder != null) {
                folder_name = this.query.getString(this.folder) + "/";
            }
            String fileName = this.query.readField("file_name");
            String ext = ".dat";
            if (fileName.lastIndexOf(".") > 0) {
                ext = fileName.substring(fileName.lastIndexOf("."));
            }
            if (ext == null) {
                ext = ".dat";
            }
            wdfn = folder_name + wdfn + "ob" + ext;
            System.out.println("BASE 1520 : " + wdfn);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            try {
                int c;
                InputStream in = this.webdav.getFile(wdfn);
                ServletOutputStream out = response.getOutputStream();
                int size = in.available();
                byte[] content = new byte[1024];
                while ((c = in.read(content)) != -1) {
                    out.write(content, 0, c);
                }
                out.close();
                in.close();
            }
            catch (IOException ex) {
                System.out.println("IO Error : " + ex);
            }
        }
    }

    public void getWebDavFile(HttpServletRequest request, HttpServletResponse response) {
        String wdfn = request.getParameter("filename");
        if (wdfn != null) {
            System.out.println("BASE 1010 : " + wdfn);
            int lifn = wdfn.lastIndexOf("/");
            String repository = wdfn.substring(0, lifn - 1);
            String fileName = wdfn.substring(lifn, wdfn.length());
            System.out.println("Repository : " + repository);
            System.out.println("File : " + fileName);
            String username = this.view.getAttribute("username");
            String password = this.view.getAttribute("password");
            this.webdav = new BWebdav(repository, username, password);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            try {
                int c;
                InputStream in = this.webdav.getFile(wdfn);
                ServletOutputStream out = response.getOutputStream();
                int size = in.available();
                byte[] content = new byte[size];
                while ((c = in.read(content)) != -1) {
                    out.write(content);
                }
                out.close();
                in.close();
            }
            catch (IOException ex) {
                System.out.println("IO Error : " + ex);
            }
        }
    }

    public String delFile(HttpServletRequest request, HttpServletResponse response) {
        String resp = "{\"success\": 0, \"message\": \"Delete Failed\"}";
        String wdfn = request.getParameter("fileid");
        System.out.println("BASE 1010 : " + wdfn);
        if (wdfn != null) {
            this.query.filter(this.query.getKeyFieldName() + " = '" + wdfn + "'", null);
            this.query.moveFirst();
            String folder_name = "";
            if (this.folder != null) {
                folder_name = this.query.getString(this.folder) + "/";
            }
            String fileName = this.query.readField("file_name");
            String ext = ".dat";
            if (fileName.lastIndexOf(".") > 0) {
                ext = fileName.substring(fileName.lastIndexOf("."));
            }
            if (ext == null) {
                ext = ".dat";
            }
            wdfn = folder_name + wdfn + "ob" + ext;
            this.query.recDelete();
            this.webdav.delFile(wdfn);
            resp = "{\"success\": 1, \"message\": \"Delete Sucessful\"}";
        }
        try {
            String referer = request.getHeader("Referer");
            System.out.println("Referer : " + referer);
            response.sendRedirect(referer);
        }
        catch (IOException ex) {
            System.out.println("IO Error : " + ex);
        }
        return resp;
    }
}

