/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;

public class BWebForms {
    Logger log = Logger.getLogger(BWebForms.class.getName());
    Map<String, String[]> params;
    JsonObject answers;
    String entryFormId = null;
    String formid = "0";
    String fhead;
    String ffoot;
    String ftitle;
    boolean saveStatus = false;
    BDB db = null;
    String access_text = null;

    public BWebForms(String dbconfig) {
        this.db = new BDB(dbconfig);
        this.answers = Json.createObjectBuilder().build();
        this.params = new HashMap<String, String[]>();
    }

    public BWebForms(String dbconfig, String at) {
        this.db = new BDB(dbconfig);
        this.access_text = at;
        this.answers = Json.createObjectBuilder().build();
        this.params = new HashMap<String, String[]>();
    }

    public BWebForms(BDB db) {
        this.db = db;
        this.answers = Json.createObjectBuilder().build();
        this.params = new HashMap<String, String[]>();
    }

    public String getWebForm(Map<String, String[]> sParams) {
        String mystr = "";
        this.answers = Json.createObjectBuilder().build();
        this.params = new HashMap<String, String[]>(sParams);
        String entityId = null;
        String approveStatus = null;
        String action = this.getParameter("action");
        if (action == null || action.trim().equals("FORM")) {
            this.formid = this.getParameter("actionvalue");
        } else {
            this.entryFormId = this.getParameter("actionvalue");
            Map<String, String> formRS = this.db.readFields("form_id, entity_id, approve_status, answer", "entry_forms WHERE entry_form_id = " + this.entryFormId);
            this.processAnswers(formRS.get("answer"));
            this.formid = formRS.get("form_id");
            entityId = formRS.get("entity_id");
            approveStatus = formRS.get("approve_status");
            if (this.entryFormId != null && "Draft".equals(approveStatus)) {
                this.saveStatus = true;
            }
        }
        this.getFormType();
        mystr = mystr + this.fhead;
        mystr = mystr + this.printForm(null, "false");
        mystr = mystr + this.ffoot;
        return mystr;
    }

    public void getFormType() {
        this.fhead = "";
        this.ffoot = "";
        this.ftitle = "";
        String mysql = "SELECT form_header, form_footer, form_name, form_number ";
        BQuery rs = new BQuery(this.db, mysql = mysql + "FROM forms WHERE form_id = " + this.formid);
        if (rs.moveNext()) {
            this.fhead = rs.getString("form_header");
            this.ffoot = rs.getString("form_footer");
            this.ftitle = rs.getString("form_number") + " : " + rs.getString("form_name");
        }
        rs.close();
        this.fhead = this.fhead == null ? "" : "<section>" + this.fhead + "</section>\n";
        this.ffoot = this.ffoot == null ? "" : "<section>" + this.ffoot + "</section>\n";
    }

    public String getFormTabs() {
        StringBuilder myhtml = new StringBuilder();
        String mysql = "SELECT * FROM fields WHERE (form_id = " + this.formid + ")";
        mysql = mysql + " AND (field_type = 'TAB') ";
        mysql = mysql + " ORDER BY field_order, field_id;";
        BQuery rs = new BQuery(this.db, mysql);
        int tabCount = 0;
        String tabs = "";
        while (rs.moveNext()) {
            String question = rs.getString("question");
            if (rs.getString("question") == null) {
                question = "";
            }
            tabs = tabCount == 0 ? "<li class='active'>" : tabs + "\n<li>";
            tabs = tabs + "<a href='#tab" + rs.getString("field_id") + "' data-toggle='tab'>" + question + " </a></li>\n";
            ++tabCount;
        }
        if (tabCount > 0) {
            myhtml.append("<div class='row'>\n\t<div class='col-md-12'>\n\t\t<div class='tabbable portlet-tabs'>\n\t\t\t<ul class='nav nav-tabs'>\n" + tabs + "\t\t\t</ul>\n\t\t</div>\n\t</div>\n</div>\n<div class='tab-content'>\n");
        }
        return myhtml.toString();
    }

    public String printForm(String disabled, String process) {
        StringBuilder myhtml = new StringBuilder();
        int fieldOrder = 0;
        int shareLine = 0;
        int sl = -1;
        int cnt_title = 0;
        int size = 0;
        int table_count = 0;
        String label = "";
        String input = "";
        String fieldType = "TEXTFIELD";
        String fieldclass = "";
        String question = "";
        String details = "";
        String label_position = "";
        disabled = disabled == null ? "" : " disabled=\"true\" ";
        boolean isTabs = false;
        String tab = "";
        String tab_head = "";
        String tab_body = "";
        String mysql = "SELECT * FROM fields WHERE form_id = " + this.formid;
        mysql = mysql + " ORDER BY field_order, field_id;";
        BQuery rs = new BQuery(this.db, mysql);
        int elCount = 0;
        int fieldRows = 2;
        int fieldCount = 0;
        int tabCount = 0;
        String fieldId = "";
        while (rs.moveNext()) {
            String lookups;
            fieldOrder = rs.getInt("field_order");
            fieldId = rs.getString("field_id");
            shareLine = rs.getInt("share_line");
            fieldType = "TEXTFIELD";
            if (rs.getString("field_type") != null) {
                fieldType = rs.getString("field_type").trim().toUpperCase();
            }
            question = rs.getString("question");
            if (rs.getString("question") == null) {
                question = "";
            }
            details = rs.getString("details");
            if (rs.getString("details") == null) {
                details = "";
            }
            fieldclass = "";
            if (rs.getString("field_class") != null) {
                fieldclass = " class='" + rs.getString("field_class") + "' ";
            }
            size = 10;
            if (rs.getString("field_size") != null) {
                size = rs.getInt("field_size");
            }
            if (rs.getBoolean("field_bold").booleanValue()) {
                question = "<b>" + question + "</b>";
            }
            if (rs.getBoolean("field_italics").booleanValue()) {
                question = "<i>" + question + "</i>";
            }
            label = "<label for='F" + rs.getString("field_id") + "'> " + question + "</label>";
            if (fieldType.equals("TITLE") || fieldType.equals("TEXT") || fieldType.equals("SUBGRID") || fieldType.equals("TABLE")) {
                if (elCount == 0 && tabCount == 0) {
                    myhtml.append("<table class='table' width='95%' >\n");
                }
                if (fieldCount != 0 && fieldCount < fieldRows) {
                    myhtml.append("<td colspan='" + String.valueOf(fieldRows * 2 - fieldCount) + "'></td></tr>\n");
                }
                myhtml.append("<tr>");
                fieldCount = 0;
            } else if (fieldType.equals("TAB")) {
                if (tabCount == 0) {
                    myhtml.append("<div class='tab-pane active' id='tab" + fieldId + "'>\n");
                } else {
                    myhtml.append("</table></div>");
                    myhtml.append("<div class='tab-pane' id='tab" + fieldId + "'>\n");
                }
                myhtml.append("<table class='table' width='95%' >\n");
                ++tabCount;
            } else {
                if (elCount == 0 && tabCount == 0) {
                    myhtml.append("<table class='table' width='95%' >\n");
                }
                if (fieldCount % fieldRows == 0) {
                    myhtml.append("<tr>");
                    fieldCount = 0;
                }
                if (!question.equals("")) {
                    myhtml.append("<td style='width:200px'>" + label + "</td>");
                }
            }
            if (fieldType.equals("TEXTFIELD")) {
                input = "<td><input " + disabled + " type='text'  style='width:" + size + "0px'  name='F" + fieldId + "' id ='F" + fieldId + "'" + this.getAnswer(fieldId) + " placeholder='" + details + "' class='form-control' /></td>\n";
                ++fieldCount;
            } else if (fieldType.equals("TEXTAREA")) {
                input = "<td><textarea " + disabled + " type='text'  style='width:" + size + "0px'  name='F" + fieldId + "' id ='F" + fieldId + "' placeholder='" + details + "' class='form-control' />" + this.getAnswer(fieldId, false) + "</textarea></td>\n";
                ++fieldCount;
            } else if (fieldType.equals("DATE")) {
                input = "<td><div class='input-group input-medium date date-picker' data-date-format='dd-mm-yyyy' data-date-viewmode='years'>";
                input = input + "<input " + disabled + " type='text'  style='width:" + size + "0px'  name='F" + fieldId + "' id ='F" + fieldId + "'" + this.getAnswer(fieldId) + " class='form-control'/>";
                input = input + "<span class='input-group-btn'><button class='btn default' type='button'><i class='fa fa-calendar'></i></button></span>";
                input = input + "</div></td>\n";
                ++fieldCount;
            } else if (fieldType.equals("TIME")) {
                input = "<td><div class='input-group input-medium'>\n";
                input = input + "<input " + disabled + " type='text'  style='width:" + size + "0px'  name='F" + fieldId + "' id ='F" + fieldId + "'" + this.getAnswer(fieldId) + " class='form-control'/>";
                input = input + "<span class='input-group-btn'>\t<button class='btn default clockface-toggle' data-target='F" + fieldId + "' type='button'><i class='fa fa-clock-o'></i></button></span>";
                input = input + "</div></td>\n";
                ++fieldCount;
            } else if (fieldType.equals("LIST")) {
                input = "<td><select class='form-control' ";
                input = input + " style='width:" + size + "0px' ";
                input = input + " name='F" + fieldId + "'";
                input = input + " id='F" + fieldId + "'";
                input = input + ">\n";
                lookups = rs.getString("field_lookup");
                String listVal = this.getAnswer(fieldId, false);
                listVal = listVal == null ? "" : listVal.replace("\"", "").trim();
                if (lookups != null) {
                    String[] lookup;
                    for (String lps : lookup = lookups.split("#")) {
                        input = lps.compareToIgnoreCase(listVal) == 0 ? input + "<option selected='selected'>" + lps + "</option>\n" : input + "<option>" + lps + "</option>\n";
                    }
                }
                input = input + "</select></td>\n";
                ++fieldCount;
            } else if (fieldType.equals("SELECT")) {
                input = "<td><select class='form-control' ";
                input = input + " name='F" + fieldId + "'";
                input = input + " id='F" + fieldId + "'";
                input = input + " style='width:" + size + "0px' ";
                input = input + ">\n";
                lookups = rs.getString("field_lookup");
                String selectVal = this.getAnswer(fieldId, false);
                selectVal = selectVal == null ? "" : selectVal.replace("\"", "").trim();
                String spanVal = "";
                if (lookups != null) {
                    BQuery lprs = new BQuery(this.db, lookups);
                    int cols = lprs.getColnum();
                    while (lprs.moveNext()) {
                        if (cols == 1) {
                            if (lprs.readField(1).trim().compareToIgnoreCase(selectVal) == 0) {
                                spanVal = lprs.readField(1);
                                input = input + "<option value='" + lprs.readField(1) + "' selected='selected'>" + lprs.readField(1) + "</option>\n";
                                continue;
                            }
                            input = input + "<option value='" + lprs.readField(1) + "'>" + lprs.readField(1) + "</option>\n";
                            continue;
                        }
                        if (lprs.readField(1).trim().compareToIgnoreCase(selectVal) == 0) {
                            spanVal = lprs.readField(2);
                            input = input + "<option value='" + lprs.readField(1) + "' selected='selected'>" + lprs.readField(2) + "</option>\n";
                            continue;
                        }
                        input = input + "<option value='" + lprs.readField(1) + "'>" + lprs.readField(2) + "</option>\n";
                    }
                    lprs.close();
                }
                input = input + "</select></td>\n";
                ++fieldCount;
            } else if (fieldType.equals("TITLE")) {
                ++cnt_title;
                input = "<td colspan='" + String.valueOf(fieldRows * 2) + "'>";
                input = input + "<div class='form_title'><b><strong>" + question + "</strong></b></div>";
                input = input + "</td>\n";
                fieldCount = 0;
            } else if (fieldType.equals("TEXT")) {
                ++cnt_title;
                input = "<td colspan='" + String.valueOf(fieldRows * 2) + "'>";
                input = input + "<div class='form_text'>" + question + "</div>";
                input = input + "</td>\n";
                fieldCount = 0;
            } else if (fieldType.equals("SUBGRID") || fieldType.equals("TABLE")) {
                input = "";
                myhtml.append("<td colspan='" + String.valueOf(fieldRows * 2) + "'><div class='container'>\t<div class='col-md-12 column'>\t\t<div id='sub_table" + fieldId + "'></div>\t</div></div></td>");
                ++table_count;
                fieldCount = 0;
            } else if (fieldType.equals("TAB")) {
                input = "";
                fieldCount = 0;
            } else {
                System.out.println("TYPE NOT DEFINED : " + fieldType);
            }
            myhtml.append(input);
            if (!fieldType.equals("TAB")) {
                if (shareLine == -1) {
                    if (fieldCount != 0 && fieldCount < fieldRows) {
                        myhtml.append("<td colspan='" + String.valueOf(fieldRows * 2 - fieldCount) + "'></td></tr>\n");
                    }
                    fieldCount = 0;
                } else if (fieldCount % fieldRows == 0) {
                    myhtml.append("</tr>\n");
                }
            }
            ++elCount;
        }
        if (fieldCount % fieldRows != 0) {
            myhtml.append("</tr>\n");
        }
        if (tabCount == 0) {
            myhtml.append("</table>");
        } else {
            myhtml.append("</table>\n</div>\n</div>");
        }
        rs.close();
        return myhtml.toString();
    }

    public String printSubForm() {
        String myhtml = "";
        String tableList = null;
        String mysql = "SELECT * FROM fields WHERE (form_id = " + this.formid + ")";
        mysql = mysql + " AND ((field_type = 'SUBGRID') OR (field_type = 'TABLE')) ";
        mysql = mysql + " ORDER BY field_order, field_id;";
        BQuery rs = new BQuery(this.db, mysql);
        while (rs.moveNext()) {
            myhtml = myhtml + "\n\n" + this.printSubTable(rs.getString("field_id"), rs.getString("field_size"));
            if (tableList == null) {
                tableList = "var db_list = ['db" + rs.getString("field_id") + ".table'";
                continue;
            }
            tableList = tableList + ", 'db" + rs.getString("field_id") + ".table'";
        }
        if (tableList == null) {
            tableList = "var db_list = [";
        }
        tableList = tableList + "];";
        myhtml = myhtml + "\n\n" + tableList;
        rs.close();
        return myhtml;
    }

    public String printSubTable(String fieldId, String tableSize) {
        JsonObjectBuilder jsColEl;
        StringBuilder myhtml = new StringBuilder();
        String mysql = "SELECT sub_field_id, sub_field_type, sub_field_size, sub_field_lookup, question ";
        mysql = mysql + " FROM vw_sub_fields WHERE field_id = " + fieldId;
        mysql = mysql + " ORDER BY sub_field_order";
        BQuery rs = new BQuery(this.db, mysql);
        myhtml.append("var db" + fieldId + " = {\nloadData: function(filter) { return this.table;  },\ninsertItem: function(insertingClient) { this.table.push(insertingClient); },\nupdateItem: function(updatingClient) { },\ndeleteItem: function(deletingClient) {\nvar clientIndex = $.inArray(deletingClient, this.table);\nthis.table.splice(clientIndex, 1);\n}\n};\nwindow.db" + fieldId + " = db" + fieldId + ";\ndb" + fieldId + ".table = " + this.getSubAnswer(fieldId) + ";\n\n");
        JsonObjectBuilder jshd = Json.createObjectBuilder();
        jshd.add("width", tableSize + "%");
        jshd.add("height", "200px");
        jshd.add("inserting", true);
        jshd.add("editing", true);
        jshd.add("filtering", false);
        jshd.add("sorting", false);
        jshd.add("paging", false);
        jshd.add("data", "#db_table#");
        HashMap<String, String> jsTables = new HashMap<String, String>();
        JsonArrayBuilder jsColModel = Json.createArrayBuilder();
        while (rs.moveNext()) {
            JsonArrayBuilder jsSelModel;
            JsonObjectBuilder jsSelObj;
            String lookups;
            jsColEl = Json.createObjectBuilder();
            String fld_name = "SF" + rs.getString("sub_field_id");
            String fld_title = rs.getString("question");
            String fld_size = rs.getString("sub_field_size");
            String fld_type = rs.getString("sub_field_type");
            if (fld_title == null) {
                fld_title = "";
            }
            fld_size = fld_size == null ? "100" : fld_size + "0";
            jsColEl.add("title", fld_title);
            jsColEl.add("name", fld_name);
            jsColEl.add("width", Integer.valueOf(fld_size).intValue());
            if (fld_type.equals("TEXTFIELD")) {
                jsColEl.add("type", "text");
            } else if (fld_type.equals("TEXTAREA")) {
                jsColEl.add("type", "textarea");
            } else if (fld_type.equals("DATEFIELD")) {
                jsColEl.add("type", "myDateField");
            } else if (fld_type.equals("LIST")) {
                lookups = rs.getString("sub_field_lookup");
                if (lookups != null) {
                    String[] lookup;
                    jsColEl.add("type", "select");
                    jsColEl.add("items", "#db" + fieldId + ".sel_" + fld_name + "#");
                    jsColEl.add("valueField", "Name");
                    jsColEl.add("textField", "Name");
                    jsColEl.add("align", "left");
                    jsSelObj = Json.createObjectBuilder();
                    jsSelModel = Json.createArrayBuilder();
                    for (String lps : lookup = lookups.split("#")) {
                        jsSelObj.add("Name", lps);
                        jsSelModel.add(jsSelObj);
                    }
                    jsTables.put("db" + fieldId + ".sel_" + fld_name, jsSelModel.build().toString());
                }
            } else if (fld_type.equals("SELECT") && (lookups = rs.getString("sub_field_lookup")) != null) {
                jsColEl.add("type", "select");
                jsColEl.add("items", "#db" + fieldId + ".sel_" + fld_name + "#");
                jsColEl.add("valueField", "Id");
                jsColEl.add("textField", "Name");
                jsColEl.add("align", "left");
                jsSelObj = Json.createObjectBuilder();
                jsSelModel = Json.createArrayBuilder();
                BQuery lprs = new BQuery(this.db, lookups);
                int cols = lprs.getColnum();
                while (lprs.moveNext()) {
                    if (cols == 1) {
                        jsSelObj.add("Id", lprs.readField(1));
                        jsSelObj.add("Name", lprs.readField(1));
                        jsSelModel.add(jsSelObj);
                        continue;
                    }
                    jsSelObj.add("Id", lprs.readField(1));
                    jsSelObj.add("Name", lprs.readField(2));
                    jsSelModel.add(jsSelObj);
                }
                lprs.close();
                jsTables.put("db" + fieldId + ".sel_" + fld_name, jsSelModel.build().toString());
            }
            jsColModel.add(jsColEl);
        }
        jsColEl = Json.createObjectBuilder();
        jsColEl.add("width", 75);
        jsColEl.add("type", "control");
        jsColModel.add(jsColEl);
        jshd.add("fields", jsColModel);
        JsonObject jsObj = jshd.build();
        String tableDef = jsObj.toString().replaceAll("\"#db_table#\"", "db" + fieldId + ".table");
        for (String jsTable : jsTables.keySet()) {
            tableDef = tableDef.replace("\"#" + jsTable + "#\"", jsTable);
            myhtml.append(jsTable + "=" + (String)jsTables.get(jsTable) + ";\n");
        }
        myhtml.append("$('#sub_table" + fieldId + "').jsGrid(" + tableDef + "\n);\n");
        rs.close();
        return myhtml.toString();
    }

    public String updateForm(String entryFormId, String jsonData) {
        this.entryFormId = entryFormId;
        String resp = "";
        System.out.println("Start saving the form " + jsonData);
        String updSql = "SELECT entry_form_id, form_id, answer FROM entry_forms WHERE entry_form_id = " + entryFormId;
        BQuery rs = new BQuery(this.db, updSql);
        if (rs.moveNext()) {
            rs.recEdit();
            rs.updateRecField("answer", jsonData);
            rs.recSave();
            resp = "{\"success\": 1, \"message\": \"Form data updated\"}";
        } else {
            resp = "{\"success\": 0, \"message\": \"Unable to update form data\"}";
        }
        rs.close();
        return resp;
    }

    public String submitForm(String entryFormId, String jsonData) {
        this.entryFormId = entryFormId;
        String resp = "";
        System.out.println("Start saving the form " + entryFormId);
        String updSql = "SELECT entry_form_id, form_id, answer, approve_status FROM entry_forms WHERE entry_form_id = " + entryFormId;
        BQuery rs = new BQuery(this.db, updSql);
        if (rs.moveNext()) {
            rs.recEdit();
            rs.updateRecField("answer", jsonData);
            rs.recSave();
            resp = this.submitValidate(rs.getString("form_id"), entryFormId, jsonData);
            resp = "{\"success\": 1, \"message\": \"" + resp + "\"}";
        } else {
            resp = "{\"success\": 0, \"message\": \"" + resp + "\"}";
        }
        rs.close();
        return resp;
    }

    public String submitValidate(String formId, String entryFormId, String jsonData) {
        String resp = "";
        String mysql = "SELECT * FROM fields  WHERE (form_id = " + formId + ") AND (manditory = '1') ";
        mysql = mysql + "ORDER BY field_order, field_id;";
        BQuery rs = new BQuery(this.db, mysql);
        this.processAnswers(jsonData);
        String ans = "";
        boolean verified = true;
        while (rs.moveNext()) {
            String fieldType = "TEXTFIELD";
            if (rs.getString("field_type") != null) {
                fieldType = rs.getString("field_type");
            }
            String question = rs.getString("question");
            if (rs.getString("question") == null) {
                question = "";
            }
            if (!fieldType.equals("TEXTFIELD") && !fieldType.equals("DATE") && !fieldType.equals("TIME") && !fieldType.equals("TEXTAREA") && !fieldType.equals("LIST") && !fieldType.equals("SELECT") || !(ans = this.getAnswer(rs.getString("field_id"))).trim().equals("")) continue;
            verified = false;
            resp = resp + "<div style='color:#FF0000; font-weight:bold;'>* You need to answer : " + question + "</div><br/>";
        }
        rs.close();
        if (verified && this.saveTable(formId, entryFormId) != null) {
            verified = false;
        }
        if (verified) {
            mysql = "UPDATE entry_forms SET approve_status = 'Completed', completion_date = now() WHERE (entry_form_id = " + entryFormId + ")";
            this.db.executeQuery(mysql);
            resp = resp + "<b>The form has been submitted successfully</b><br/>";
        } else {
            resp = resp + "<b>You need to ensure you have made the selection properly</b><br/>";
        }
        return resp;
    }

    public String saveTable(String formid, String entryformid) {
        String dbErr = null;
        String mysql = "SELECT table_name FROM forms WHERE form_id = " + formid;
        String tableName = this.db.executeFunction(mysql);
        if (tableName != null) {
            mysql = "SELECT field_name, field_id, field_fnct FROM fields WHERE form_id = " + formid;
            mysql = mysql + " ORDER BY field_order, field_id;";
            BQuery rs = new BQuery(this.db, mysql);
            mysql = "INSERT INTO " + tableName + " (entry_form_id";
            String values = ") VALUES (" + entryformid;
            while (rs.moveNext()) {
                String fieldName = rs.getString("field_name");
                if (fieldName == null) continue;
                String fieldFnct = rs.getString("field_fnct");
                String ans = this.getAnswer(rs.getString("field_id"), false);
                String ansa = "'" + ans + "'";
                if (ans == null) {
                    ansa = "null";
                    ans = "";
                }
                if (fieldFnct != null && ans != null) {
                    ansa = fieldFnct.replace("#", ans);
                }
                if (!ans.equals("")) {
                    mysql = mysql + ", " + fieldName;
                    values = values + ", " + ansa;
                }
                System.out.println("BASE 1010 : " + fieldName + " : " + ansa);
            }
            mysql = mysql + values + ")";
            dbErr = this.db.executeQuery(mysql);
            rs.close();
            System.out.println("\n\nBASE 1020 : " + mysql);
        }
        return dbErr;
    }

    public String getParameter(String paramName) {
        String paramValue = null;
        if (this.params.get(paramName) != null) {
            paramValue = this.params.get(paramName)[0];
        }
        return paramValue;
    }

    public void processAnswers(String answer) {
        if (answer == null) {
            return;
        }
        JsonReader jr = Json.createReader((Reader)new StringReader(answer));
        this.answers = jr.readObject();
        jr.close();
    }

    public String getAnswer(String fieldid) {
        return this.getAnswer(fieldid, true);
    }

    public String getAnswer(String fieldid, boolean addValue) {
        String aId = "F" + fieldid;
        if (!this.answers.containsKey((Object)aId)) {
            return "";
        }
        if (this.answers.get((Object)aId) instanceof JsonObject || this.answers.get((Object)aId) instanceof JsonArray) {
            return "";
        }
        String answer = this.answers.getString(aId);
        if (answer == null) {
            answer = "";
        } else if (answer.trim().equals("")) {
            answer = "";
        } else if (addValue) {
            answer = answer.replaceAll("&", "&amp;").replaceAll("\"", "&quot;");
            answer = " value=\"" + answer + "\"";
        }
        return answer;
    }

    public String getSubAnswer(String fieldid) {
        String aId = "db" + fieldid + ".table";
        if (!this.answers.containsKey((Object)aId)) {
            return "[ ]";
        }
        if (!(this.answers.get((Object)aId) instanceof JsonArray)) {
            return "[ ]";
        }
        String answer = this.answers.getJsonArray(aId).toString();
        return answer;
    }

    public String getTitle() {
        return this.ftitle;
    }

    public String getEntryFormId() {
        return this.entryFormId;
    }

    public boolean canSave() {
        return this.saveStatus;
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
        }
    }
}

