/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.impl;

import com.github.sardine.DavAce;
import com.github.sardine.DavAcl;
import com.github.sardine.DavPrincipal;
import com.github.sardine.DavQuota;
import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import com.github.sardine.Version;
import com.github.sardine.impl.handler.ExistsResponseHandler;
import com.github.sardine.impl.handler.LockResponseHandler;
import com.github.sardine.impl.handler.MultiStatusResponseHandler;
import com.github.sardine.impl.handler.VoidResponseHandler;
import com.github.sardine.impl.io.ConsumingInputStream;
import com.github.sardine.impl.methods.HttpAcl;
import com.github.sardine.impl.methods.HttpCopy;
import com.github.sardine.impl.methods.HttpLock;
import com.github.sardine.impl.methods.HttpMkCol;
import com.github.sardine.impl.methods.HttpMove;
import com.github.sardine.impl.methods.HttpPropFind;
import com.github.sardine.impl.methods.HttpPropPatch;
import com.github.sardine.impl.methods.HttpUnlock;
import com.github.sardine.model.Ace;
import com.github.sardine.model.Acl;
import com.github.sardine.model.Allprop;
import com.github.sardine.model.Displayname;
import com.github.sardine.model.Exclusive;
import com.github.sardine.model.Group;
import com.github.sardine.model.Lockinfo;
import com.github.sardine.model.Lockscope;
import com.github.sardine.model.Locktype;
import com.github.sardine.model.Multistatus;
import com.github.sardine.model.Owner;
import com.github.sardine.model.PrincipalCollectionSet;
import com.github.sardine.model.PrincipalURL;
import com.github.sardine.model.Prop;
import com.github.sardine.model.Propertyupdate;
import com.github.sardine.model.Propfind;
import com.github.sardine.model.Propstat;
import com.github.sardine.model.QuotaAvailableBytes;
import com.github.sardine.model.QuotaUsedBytes;
import com.github.sardine.model.Remove;
import com.github.sardine.model.Resourcetype;
import com.github.sardine.model.Response;
import com.github.sardine.model.Set;
import com.github.sardine.model.Write;
import com.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SardineImpl
implements Sardine {
    private static Logger log = LoggerFactory.getLogger(DavResource.class);
    private static final String UTF_8 = "UTF-8";
    private AbstractHttpClient client;
    private HttpContext context = new BasicHttpContext();

    public SardineImpl() {
        this(null, null);
    }

    public SardineImpl(String username, String password) {
        this(username, password, null);
    }

    public SardineImpl(String username, String password, ProxySelector selector) {
        this.init(this.createDefaultClient(selector), username, password);
    }

    public SardineImpl(AbstractHttpClient http) {
        this(http, null, null);
    }

    public SardineImpl(AbstractHttpClient http, String username, String password) {
        this.init(http, username, password);
    }

    private void init(AbstractHttpClient http, String username, String password) {
        this.client = http;
        this.client.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                int statusCode = response.getStatusLine().getStatusCode();
                String method = request.getRequestLine().getMethod();
                Header locationHeader = response.getFirstHeader("location");
                switch (statusCode) {
                    case 302: {
                        return (method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD") || method.equalsIgnoreCase("LOCK") || method.equalsIgnoreCase("ACL") || method.equalsIgnoreCase("PROPFIND")) && locationHeader != null;
                    }
                    case 301: 
                    case 307: {
                        return method.equalsIgnoreCase("GET") || method.equalsIgnoreCase("HEAD") || method.equalsIgnoreCase("LOCK") || method.equalsIgnoreCase("ACL") || method.equalsIgnoreCase("PROPFIND");
                    }
                    case 303: {
                        return true;
                    }
                }
                return false;
            }

            public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                String method = request.getRequestLine().getMethod();
                if (method.equalsIgnoreCase("PROPFIND")) {
                    return new HttpPropFind(this.getLocationURI(request, response, context));
                }
                if (method.equalsIgnoreCase("LOCK")) {
                    return new HttpLock(this.getLocationURI(request, response, context));
                }
                return super.getRedirect(request, response, context);
            }
        });
        this.setCredentials(username, password);
    }

    @Override
    public void setCredentials(String username, String password) {
        this.setCredentials(username, password, "", "");
    }

    @Override
    public void setCredentials(String username, String password, String domain, String workstation) {
        if (username != null) {
            this.client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "NTLM"), (Credentials)new NTCredentials(username, password, workstation, domain));
            this.client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic"), (Credentials)new UsernamePasswordCredentials(username, password));
            this.client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Digest"), (Credentials)new UsernamePasswordCredentials(username, password));
            this.client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "negotiate"), (Credentials)new UsernamePasswordCredentials(username, password));
            this.client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Kerberos"), (Credentials)new UsernamePasswordCredentials(username, password));
        }
    }

    @Override
    public void enableCompression() {
        this.client.addRequestInterceptor((HttpRequestInterceptor)new RequestAcceptEncoding());
        this.client.addResponseInterceptor((HttpResponseInterceptor)new ResponseContentEncoding());
    }

    @Override
    public void disableCompression() {
        this.client.removeRequestInterceptorByClass(RequestAcceptEncoding.class);
        this.client.removeResponseInterceptorByClass(ResponseContentEncoding.class);
    }

    @Override
    public void enablePreemptiveAuthentication(String hostname) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        SchemeRegistry registry = this.client.getConnectionManager().getSchemeRegistry();
        for (String scheme : registry.getSchemeNames()) {
            int port = registry.getScheme(scheme).getDefaultPort();
            authCache.put(new HttpHost(hostname), (AuthScheme)basicAuth);
            authCache.put(new HttpHost(hostname, -1, scheme), (AuthScheme)basicAuth);
            authCache.put(new HttpHost(hostname, port, scheme), (AuthScheme)basicAuth);
        }
        this.context.setAttribute("http.auth.auth-cache", (Object)authCache);
    }

    @Override
    public void disablePreemptiveAuthentication() {
        this.context.removeAttribute("http.auth.auth-cache");
    }

    @Override
    public List<DavResource> getResources(String url) throws IOException {
        return this.list(url);
    }

    @Override
    public List<DavResource> list(String url) throws IOException {
        return this.list(url, 1);
    }

    @Override
    public List<DavResource> list(String url, int depth) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth(Integer.toString(depth));
        Propfind body = new Propfind();
        body.setAllprop(new Allprop());
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException e) {
                log.warn(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    @Override
    public void setCustomProps(String url, Map<String, String> set, List<String> remove) throws IOException {
        this.patch(url, SardineUtil.toQName(set), SardineUtil.toQName(remove));
    }

    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps) throws IOException {
        return this.patch(url, setProps, Collections.<QName>emptyList());
    }

    @Override
    public List<DavResource> patch(String url, Map<QName, String> setProps, List<QName> removeProps) throws IOException {
        Element element;
        HttpPropPatch entity = new HttpPropPatch(url);
        Propertyupdate body = new Propertyupdate();
        Set set = new Set();
        body.getRemoveOrSet().add(set);
        Prop prop = new Prop();
        List<Element> any = prop.getAny();
        for (Map.Entry<QName, String> entry : setProps.entrySet()) {
            element = SardineUtil.createElement(entry.getKey());
            element.setTextContent(entry.getValue());
            any.add(element);
        }
        set.setProp(prop);
        Remove remove = new Remove();
        body.getRemoveOrSet().add(remove);
        prop = new Prop();
        any = prop.getAny();
        for (QName qName : removeProps) {
            element = SardineUtil.createElement(qName);
            any.add(element);
        }
        remove.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        ArrayList<DavResource> resources = new ArrayList<DavResource>(responses.size());
        for (Response response : responses) {
            try {
                resources.add(new DavResource(response));
            }
            catch (URISyntaxException e) {
                log.warn(String.format("Ignore resource with invalid URI %s", response.getHref().get(0)));
            }
        }
        return resources;
    }

    @Override
    public String lock(String url) throws IOException {
        HttpLock entity = new HttpLock(url);
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        body.setLocktype(lockType);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        return this.execute((HttpRequestBase)entity, new LockResponseHandler());
    }

    @Override
    public void unlock(String url, String token) throws IOException {
        HttpUnlock entity = new HttpUnlock(url, token);
        Lockinfo body = new Lockinfo();
        Lockscope scopeType = new Lockscope();
        scopeType.setExclusive(new Exclusive());
        body.setLockscope(scopeType);
        Locktype lockType = new Locktype();
        lockType.setWrite(new Write());
        body.setLocktype(lockType);
        this.execute(entity, new VoidResponseHandler());
    }

    @Override
    public void setAcl(String url, List<DavAce> aces) throws IOException {
        HttpAcl entity = new HttpAcl(url);
        Acl body = new Acl();
        body.setAce(new ArrayList<Ace>());
        for (DavAce davAce : aces) {
            if (davAce.getInherited() != null || davAce.isProtected()) continue;
            Ace ace = davAce.toModel();
            body.getAce().add(ace);
        }
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        this.execute((HttpRequestBase)entity, new VoidResponseHandler());
    }

    @Override
    public DavAcl getAcl(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setOwner(new Owner());
        prop.setGroup(new Group());
        prop.setAcl(new Acl());
        body.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        return new DavAcl(responses.get(0));
    }

    @Override
    public DavQuota getQuota(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setQuotaAvailableBytes(new QuotaAvailableBytes());
        prop.setQuotaUsedBytes(new QuotaUsedBytes());
        body.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        return new DavQuota(responses.get(0));
    }

    @Override
    public List<DavPrincipal> getPrincipals(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("1");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setDisplayname(new Displayname());
        prop.setResourcetype(new Resourcetype());
        prop.setPrincipalURL(new PrincipalURL());
        body.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        ArrayList<DavPrincipal> collections = new ArrayList<DavPrincipal>();
        for (Response r : responses) {
            if (r.getPropstat() == null) continue;
            for (Propstat propstat : r.getPropstat()) {
                if (propstat.getProp() == null || propstat.getProp().getResourcetype() == null || propstat.getProp().getResourcetype().getPrincipal() == null) continue;
                collections.add(new DavPrincipal(DavPrincipal.PrincipalType.HREF, r.getHref().get(0), propstat.getProp().getDisplayname().getContent().get(0)));
            }
        }
        return collections;
    }

    @Override
    public List<String> getPrincipalCollectionSet(String url) throws IOException {
        HttpPropFind entity = new HttpPropFind(url);
        entity.setDepth("0");
        Propfind body = new Propfind();
        Prop prop = new Prop();
        prop.setPrincipalCollectionSet(new PrincipalCollectionSet());
        body.setProp(prop);
        entity.setEntity((HttpEntity)new StringEntity(SardineUtil.toXml(body), UTF_8));
        Multistatus multistatus = this.execute((HttpRequestBase)entity, new MultiStatusResponseHandler());
        List<Response> responses = multistatus.getResponse();
        if (responses.isEmpty()) {
            return null;
        }
        ArrayList<String> collections = new ArrayList<String>();
        for (Response r : responses) {
            if (r.getPropstat() == null) continue;
            for (Propstat propstat : r.getPropstat()) {
                if (propstat.getProp() == null || propstat.getProp().getPrincipalCollectionSet() == null || propstat.getProp().getPrincipalCollectionSet().getHref() == null) continue;
                collections.addAll(propstat.getProp().getPrincipalCollectionSet().getHref());
            }
        }
        return collections;
    }

    @Override
    public InputStream get(String url) throws IOException {
        return this.get(url, Collections.<String, String>emptyMap());
    }

    @Override
    public InputStream get(String url, Map<String, String> headers) throws IOException {
        HttpGet get = new HttpGet(url);
        for (String header : headers.keySet()) {
            get.addHeader(header, headers.get(header));
        }
        HttpResponse response = this.execute((HttpRequestBase)get);
        VoidResponseHandler handler = new VoidResponseHandler();
        try {
            handler.handleResponse(response);
            return new ConsumingInputStream(response);
        }
        catch (IOException ex) {
            get.abort();
            throw ex;
        }
    }

    @Override
    public void put(String url, byte[] data) throws IOException {
        this.put(url, data, null);
    }

    @Override
    public void put(String url, byte[] data, String contentType) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(data);
        this.put(url, (HttpEntity)entity, contentType, true);
    }

    @Override
    public void put(String url, InputStream dataStream) throws IOException {
        this.put(url, dataStream, (String)null);
    }

    @Override
    public void put(String url, InputStream dataStream, String contentType) throws IOException {
        this.put(url, dataStream, contentType, true);
    }

    @Override
    public void put(String url, InputStream dataStream, String contentType, boolean expectContinue) throws IOException {
        InputStreamEntity entity = new InputStreamEntity(dataStream, -1L);
        this.put(url, (HttpEntity)entity, contentType, expectContinue);
    }

    @Override
    public void put(String url, InputStream dataStream, Map<String, String> headers) throws IOException {
        InputStreamEntity entity = new InputStreamEntity(dataStream, -1L);
        this.put(url, (HttpEntity)entity, headers);
    }

    public void put(String url, HttpEntity entity, String contentType, boolean expectContinue) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (contentType != null) {
            headers.put("Content-Type", contentType);
        }
        if (expectContinue) {
            headers.put("Expect", "100-continue");
        }
        this.put(url, entity, headers);
    }

    public void put(String url, HttpEntity entity, Map<String, String> headers) throws IOException {
        HttpPut put = new HttpPut(url);
        put.setEntity(entity);
        for (String header : headers.keySet()) {
            put.addHeader(header, headers.get(header));
        }
        if (entity.getContentType() == null && !put.containsHeader("Content-Type")) {
            put.addHeader("Content-Type", HTTP.DEF_CONTENT_CHARSET.name());
        }
        try {
            this.execute((HttpRequestBase)put, new VoidResponseHandler());
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 417) {
                put.removeHeaders("Expect");
                if (entity.isRepeatable()) {
                    this.execute((HttpRequestBase)put, new VoidResponseHandler());
                    return;
                }
            }
            throw e;
        }
    }

    @Override
    public void delete(String url) throws IOException {
        HttpDelete delete = new HttpDelete(url);
        this.execute((HttpRequestBase)delete, new VoidResponseHandler());
    }

    @Override
    public void move(String sourceUrl, String destinationUrl) throws IOException {
        HttpMove move = new HttpMove(sourceUrl, destinationUrl);
        this.execute(move, new VoidResponseHandler());
    }

    @Override
    public void copy(String sourceUrl, String destinationUrl) throws IOException {
        HttpCopy copy = new HttpCopy(sourceUrl, destinationUrl);
        this.execute(copy, new VoidResponseHandler());
    }

    @Override
    public void createDirectory(String url) throws IOException {
        HttpMkCol mkcol = new HttpMkCol(url);
        this.execute((HttpRequestBase)mkcol, new VoidResponseHandler());
    }

    @Override
    public boolean exists(String url) throws IOException {
        HttpHead head = new HttpHead(url);
        return this.execute((HttpRequestBase)head, new ExistsResponseHandler());
    }

    protected <T> T execute(HttpRequestBase request, ResponseHandler<T> responseHandler) throws IOException {
        try {
            this.context.removeAttribute("http.protocol.redirect-locations");
            return (T)this.client.execute((HttpUriRequest)request, responseHandler, this.context);
        }
        catch (IOException e) {
            request.abort();
            throw e;
        }
    }

    protected HttpResponse execute(HttpRequestBase request) throws IOException {
        try {
            this.context.removeAttribute("http.protocol.redirect-locations");
            return this.client.execute((HttpUriRequest)request, this.context);
        }
        catch (IOException e) {
            request.abort();
            throw e;
        }
    }

    @Override
    public void shutdown() {
        this.client.getConnectionManager().shutdown();
    }

    protected AbstractHttpClient createDefaultClient(ProxySelector selector) {
        SchemeRegistry schemeRegistry = this.createDefaultSchemeRegistry();
        ClientConnectionManager cm = this.createDefaultConnectionManager(schemeRegistry);
        HttpParams params = this.createDefaultHttpParams();
        DefaultHttpClient c = new DefaultHttpClient(cm, params);
        c.setRoutePlanner(this.createDefaultRoutePlanner(schemeRegistry, selector));
        return c;
    }

    protected HttpParams createDefaultHttpParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        String version = Version.getSpecification();
        if (version == null) {
            version = "UNAVAILABLE";
        }
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)("Sardine/" + version));
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)HTTP.DEF_CONTENT_CHARSET.name());
        HttpConnectionParams.setTcpNoDelay((HttpParams)params, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        return params;
    }

    protected SchemeRegistry createDefaultSchemeRegistry() {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)this.createDefaultSocketFactory()));
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)this.createDefaultSecureSocketFactory()));
        return registry;
    }

    protected PlainSocketFactory createDefaultSocketFactory() {
        return PlainSocketFactory.getSocketFactory();
    }

    protected SSLSocketFactory createDefaultSecureSocketFactory() {
        return SSLSocketFactory.getSocketFactory();
    }

    protected ClientConnectionManager createDefaultConnectionManager(SchemeRegistry schemeRegistry) {
        return new PoolingClientConnectionManager(schemeRegistry);
    }

    protected HttpRoutePlanner createDefaultRoutePlanner(SchemeRegistry schemeRegistry, ProxySelector selector) {
        return new ProxySelectorRoutePlanner(schemeRegistry, selector);
    }
}

