/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine.impl.handler;

import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.handler.ValidatingResponseHandler;
import com.github.sardine.model.Multistatus;
import com.github.sardine.util.SardineUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

public class MultiStatusResponseHandler
extends ValidatingResponseHandler<Multistatus> {
    public Multistatus handleResponse(HttpResponse response) throws IOException {
        super.validateResponse(response);
        HttpEntity entity = response.getEntity();
        StatusLine statusLine = response.getStatusLine();
        if (entity == null) {
            throw new SardineException("No entity found in response", statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return this.getMultistatus(entity.getContent());
    }

    protected Multistatus getMultistatus(InputStream stream) throws IOException {
        return (Multistatus)SardineUtil.unmarshal(stream);
    }
}

