/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.sf.jasperreports.components.html.HtmlComponent;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.base.JRBasePrintImage;
import net.sf.jasperreports.engine.type.HorizontalImageAlignEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalImageAlignEnum;
import net.sf.jasperreports.engine.util.HtmlPrintElement;
import net.sf.jasperreports.engine.util.JRExpressionUtil;
import net.sf.jasperreports.renderers.FlyingSaucerXhtmlToImageRenderer;
import org.w3c.dom.Document;
import org.w3c.tidy.Tidy;

public class FlyingSaucerHtmlPrintElement
implements HtmlPrintElement {
    @Override
    public JRPrintImage createImageFromElement(JRGenericPrintElement element) throws JRException {
        String htmlContent = (String)element.getParameterValue("htmlContent");
        String scaleType = (String)element.getParameterValue("scaleType");
        String horizontalAlignment = (String)element.getParameterValue("horizontalAlign");
        String verticalAlignment = (String)element.getParameterValue("verticalAlign");
        Boolean hasOverflowed = (Boolean)element.getParameterValue("hasOverflowed");
        Boolean clipOnOverflow = (Boolean)element.getParameterValue("clipOnOverflow");
        JRBasePrintImage printImage = new JRBasePrintImage(element.getDefaultStyleProvider());
        printImage.setStyle(element.getStyle());
        printImage.setMode(element.getModeValue());
        printImage.setBackcolor(element.getBackcolor());
        printImage.setForecolor(element.getForecolor());
        printImage.setX(element.getX());
        printImage.setY(element.getY());
        printImage.setWidth(element.getWidth());
        printImage.setScaleImage(ScaleImageEnum.getByName((String)scaleType));
        printImage.setHorizontalImageAlign(HorizontalImageAlignEnum.getByName((String)horizontalAlignment));
        printImage.setVerticalImageAlign(VerticalImageAlignEnum.getByName((String)verticalAlignment));
        FlyingSaucerXhtmlToImageRenderer renderer = new FlyingSaucerXhtmlToImageRenderer(this.getHtmlDocument(htmlContent), element.getWidth(), element.getHeight());
        if (printImage.getScaleImageValue() == ScaleImageEnum.REAL_HEIGHT || printImage.getScaleImageValue() == ScaleImageEnum.REAL_SIZE) {
            boolean canClip;
            boolean bl = canClip = hasOverflowed != null ? hasOverflowed : false;
            if (canClip) {
                printImage.setHeight(element.getHeight());
                if (clipOnOverflow.booleanValue()) {
                    printImage.setScaleImage(ScaleImageEnum.CLIP);
                }
            } else {
                printImage.setHeight(renderer.getComputedSize().height);
            }
        } else {
            printImage.setHeight(element.getHeight());
        }
        printImage.setRenderable((Renderable)renderer);
        return printImage;
    }

    @Override
    public JRPrintImage createImageFromComponentElement(JRComponentElement componentElement) throws JRException {
        HtmlComponent html = (HtmlComponent)componentElement.getComponent();
        String htmlContent = "";
        if (html.getHtmlContentExpression() != null) {
            htmlContent = JRExpressionUtil.getExpressionText((JRExpression)html.getHtmlContentExpression());
        }
        JRBasePrintImage printImage = new JRBasePrintImage(componentElement.getDefaultStyleProvider());
        printImage.setStyle(componentElement.getStyle());
        printImage.setMode(componentElement.getModeValue());
        printImage.setBackcolor(componentElement.getBackcolor());
        printImage.setForecolor(componentElement.getForecolor());
        printImage.setX(componentElement.getX());
        printImage.setY(componentElement.getY());
        printImage.setWidth(componentElement.getWidth());
        printImage.setHeight(componentElement.getHeight());
        printImage.setScaleImage(html.getScaleType());
        printImage.setHorizontalImageAlign(html.getHorizontalImageAlign());
        printImage.setVerticalImageAlign(html.getVerticalImageAlign());
        FlyingSaucerXhtmlToImageRenderer renderer = new FlyingSaucerXhtmlToImageRenderer(this.getHtmlDocument(htmlContent), componentElement.getWidth(), componentElement.getHeight());
        printImage.setRenderable((Renderable)renderer);
        return printImage;
    }

    @Override
    public Dimension getComputedSize(JRGenericPrintElement element) {
        String htmlContent = (String)element.getParameterValue("htmlContent");
        FlyingSaucerXhtmlToImageRenderer renderer = new FlyingSaucerXhtmlToImageRenderer(this.getHtmlDocument(htmlContent), element.getWidth(), element.getHeight());
        return renderer.getComputedSize();
    }

    private Document getHtmlDocument(String htmlContent) {
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        buf.append("<head><style language='text/css'>");
        buf.append("@page{ margin: 0; }");
        buf.append("body{ margin:0;}");
        buf.append("</style></head>");
        buf.append("<body>");
        buf.append(htmlContent);
        buf.append("</body>");
        buf.append("</html>");
        Tidy tidy = new Tidy();
        tidy.setXHTML(true);
        tidy.setQuiet(true);
        tidy.setShowWarnings(false);
        return tidy.parseDOM((InputStream)new ByteArrayInputStream(buf.toString().getBytes()), null);
    }
}

