/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.ArrayDescriptor;
import interbase.interclient.BugCheckException;
import interbase.interclient.Connection;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.IBTypes;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.SQLException;
import java.sql.ResultSet;
import java.util.Map;

public final class Array
implements java.sql.Array {
    Object data_ = null;
    long id_ = 0L;
    ArrayDescriptor descriptor_ = null;
    Connection connection_ = null;

    Array(Object object) throws java.sql.SQLException {
        if (!object.getClass().isArray()) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 131);
        }
        this.data_ = object;
    }

    Array(Object object, ArrayDescriptor arrayDescriptor) throws java.sql.SQLException {
        if (!object.getClass().isArray()) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 132);
        }
        this.setDescriptor(arrayDescriptor);
        this.data_ = object;
    }

    Array(long l, ArrayDescriptor arrayDescriptor, Connection connection) throws java.sql.SQLException {
        this.setDescriptor(arrayDescriptor);
        this.id_ = l;
        this.connection_ = connection;
    }

    void setDescriptor(ArrayDescriptor arrayDescriptor) throws java.sql.SQLException {
        if (arrayDescriptor == null) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 133);
        }
        if (this.data_ != null) {
            this.checkDimensions(this.data_, arrayDescriptor, 0);
        }
        this.descriptor_ = arrayDescriptor;
    }

    private void checkDimensions(Object object, ArrayDescriptor arrayDescriptor, int n) throws java.sql.SQLException {
        if (object == null) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
        }
        int n2 = java.lang.reflect.Array.getLength(object);
        if (arrayDescriptor.dimensionBounds_[n][1] - arrayDescriptor.dimensionBounds_[n][0] + 1 != n2) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
        }
        if (object.getClass().getComponentType().isArray()) {
            if (++n >= arrayDescriptor.dimensions_) {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
            }
            for (int i = 0; i < n2; ++i) {
                this.checkDimensions(java.lang.reflect.Array.get(object, i), arrayDescriptor, n);
            }
        } else if (n != arrayDescriptor.dimensions_ - 1) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_dimensions__);
        }
    }

    void putArraySlice() throws SQLException {
        long l = this.descriptor_.dimensionBounds_[0][1] - this.descriptor_.dimensionBounds_[0][0] + 1;
        for (int i = 1; i < this.descriptor_.dimensions_; ++i) {
            l *= (long)(this.descriptor_.dimensionBounds_[i][1] - this.descriptor_.dimensionBounds_[i][0] + 1);
        }
        l *= (long)this.descriptor_.elementLength_;
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    private Object remote_GET_ARRAY_SLICE(int[][] nArray) throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String getBaseTypeName() throws java.sql.SQLException {
        return IBTypes.getIBTypeName(this.descriptor_.elementDataType_);
    }

    public synchronized int getBaseType() throws java.sql.SQLException {
        return IBTypes.getSQLType(this.descriptor_.elementDataType_);
    }

    public synchronized Object getArray() throws java.sql.SQLException {
        if (this.data_ != null) {
            return this.data_;
        }
        this.data_ = this.remote_GET_ARRAY_SLICE(this.descriptor_.dimensionBounds_);
        this.connection_.transactionStartedOnServer_ = true;
        return this.data_;
    }

    public synchronized Object getArray(Map map) throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Object getArray(long l, int n) throws java.sql.SQLException {
        int[][] nArray = this.descriptor_.getDimensions();
        nArray[0][0] = (int)l;
        nArray[0][1] = (int)(l + (long)n - 1L);
        boolean bl = this.descriptor_.checkSliceBounds(nArray);
        Object object = this.remote_GET_ARRAY_SLICE(nArray);
        if (bl) {
            this.data_ = object;
        }
        return object;
    }

    public synchronized Object getArray(long l, int n, Map map) throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet() throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet(Map map) throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet(long l, int n) throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized ResultSet getResultSet(long l, int n, Map map) throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Object getArray(int[][] nArray) throws java.sql.SQLException {
        boolean bl = this.descriptor_.checkSliceBounds(nArray);
        Object object = this.remote_GET_ARRAY_SLICE(nArray);
        if (bl) {
            this.data_ = object;
        }
        return object;
    }

    public synchronized ResultSet getResultSet(int[][] nArray) throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }
}

