/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.Connection;
import interbase.interclient.ErrorKey;
import interbase.interclient.IBTypes;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.ResultSet;
import interbase.interclient.SQLException;
import interbase.interclient.Statement;

final class ArrayDescriptor {
    String columnName_ = null;
    String tableName_ = null;
    int elementDataType_ = 0;
    int elementIBDataType_ = 0;
    int elementScale_ = 0;
    int elementPrecision_ = 0;
    int elementLength_ = 0;
    int flags_ = 0;
    int dimensions_ = 0;
    int elementIBSubType_ = 0;
    int[][] dimensionBounds_ = null;
    static final int MAX_DIMENSIONS = 16;
    static final int array_bound_upper = 1;
    static final int array_bound_lower = 0;

    ArrayDescriptor(Connection connection, String string, String string2) throws java.sql.SQLException {
        this.lookupBounds(connection, string, string2);
    }

    ArrayDescriptor() throws SQLException {
        this.dimensionBounds_ = new int[16][2];
    }

    private void lookupBounds(Connection connection, String string, String string2) throws java.sql.SQLException {
        Statement statement = (Statement)connection.createStatement();
        ResultSet resultSet = (ResultSet)statement.executeQuery("select y.rdb$field_type, y.rdb$field_scale, y.rdb$field_length, y.rdb$field_name , y.rdb$dimensions, y.rdb$field_sub_type from rdb$relation_fields x, rdb$fields y  where x.rdb$field_source = y.rdb$field_name and x.rdb$relation_name = '" + string.toUpperCase() + "' " + "and x.rdb$field_name = '" + string2.toUpperCase() + "'");
        if (resultSet.next()) {
            this.elementIBDataType_ = resultSet.getInt(1);
            this.elementIBSubType_ = resultSet.getInt(6);
            this.elementScale_ = Math.abs(resultSet.getInt(2));
            this.elementDataType_ = IBTypes.getIBArrayType(this.elementIBDataType_, this.elementScale_, this.elementIBSubType_);
            this.elementLength_ = resultSet.getInt(3);
            this.elementPrecision_ = IBTypes.getIBArrayPrecision(resultSet.getInt(1), this.elementLength_);
            this.dimensions_ = resultSet.getInt(5);
            this.columnName_ = resultSet.getString(4).trim();
        }
        resultSet.close();
        resultSet = (ResultSet)statement.executeQuery("select x.rdb$lower_bound, x.rdb$upper_bound from rdb$field_dimensions x where rdb$field_name = '" + this.columnName_ + "' order by rdb$dimension");
        this.dimensionBounds_ = new int[this.dimensions_][2];
        int n = 0;
        while (resultSet.next()) {
            this.dimensionBounds_[n][0] = resultSet.getInt(1);
            this.dimensionBounds_[n][1] = resultSet.getInt(2);
            ++n;
        }
        resultSet.close();
        statement.close();
        this.columnName_ = new String(string2);
        this.tableName_ = new String(string);
    }

    int[][] getDimensions() throws java.sql.SQLException {
        int[][] nArray = new int[this.dimensions_][2];
        for (int i = 0; i < this.dimensions_; ++i) {
            nArray[i][0] = this.dimensionBounds_[i][0];
            nArray[i][1] = this.dimensionBounds_[i][1];
        }
        return nArray;
    }

    boolean checkSliceBounds(int[][] nArray) throws java.sql.SQLException {
        if (nArray.length != this.dimensions_) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_slice__);
        }
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i][0] < this.dimensionBounds_[i][0] || nArray[i][0] > this.dimensionBounds_[i][1] || nArray[i][1] > this.dimensionBounds_[i][1] || nArray[i][1] < this.dimensionBounds_[i][0] || nArray[i][0] > nArray[i][1]) {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__invalid_array_slice__);
            }
            if (nArray[i][0] == this.dimensionBounds_[i][0] && nArray[i][1] == this.dimensionBounds_[i][1]) continue;
            bl = false;
        }
        return bl;
    }
}

